/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.lexicoder.Encoder;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.ValueFormatException;

public abstract class TypedValueCombiner<V>
extends Combiner {
    private Encoder<V> encoder = null;
    private boolean lossy = false;
    protected static final String LOSSY = "lossy";

    protected void setEncoder(Encoder<V> encoder) {
        this.encoder = encoder;
    }

    protected void setEncoder(String encoderClass) {
        try {
            Class<Encoder> clazz = ClassLoaderUtil.loadClass(encoderClass, Encoder.class);
            this.encoder = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void testEncoder(V v) {
        if (this.encoder == null) {
            throw new IllegalStateException("encoder has not been initialized");
        }
        TypedValueCombiner.testEncoder(this.encoder, v);
    }

    public static <V> void testEncoder(Encoder<V> encoder, V v) {
        try {
            if (!v.equals(encoder.decode(encoder.encode(v)))) {
                throw new IllegalArgumentException("something wrong with " + encoder.getClass().getName() + " -- doesn't encode and decode " + v + " properly");
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(encoder.getClass().getName() + " doesn't encode " + v.getClass().getName());
        }
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        TypedValueCombiner newInstance = (TypedValueCombiner)super.deepCopy(env);
        newInstance.setEncoder(this.encoder);
        return newInstance;
    }

    @Override
    public Value reduce(Key key, Iterator<Value> iter) {
        return new Value(this.encoder.encode(this.typedReduce(key, new VIterator<V>(iter, this.encoder, this.lossy))));
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.setLossyness(options);
    }

    private void setLossyness(Map<String, String> options) {
        String loss = options.get(LOSSY);
        this.lossy = loss != null && Boolean.parseBoolean(loss);
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.addNamedOption(LOSSY, "if true, failed decodes are ignored. Otherwise combiner will error on failed decodes (default false): <TRUE|FALSE>");
        return io;
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (!super.validateOptions(options)) {
            return false;
        }
        try {
            this.setLossyness(options);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad boolean lossy:" + options.get(LOSSY));
        }
        return true;
    }

    public static void setLossyness(IteratorSetting is, boolean lossy) {
        is.addOption(LOSSY, Boolean.toString(lossy));
    }

    public abstract V typedReduce(Key var1, Iterator<V> var2);

    private static class VIterator<V>
    implements Iterator<V> {
        private Iterator<Value> source;
        private Encoder<V> encoder;
        private boolean lossy;
        V next = null;
        boolean hasNext = false;

        VIterator(Iterator<Value> iter, Encoder<V> encoder, boolean lossy) {
            this.source = iter;
            this.encoder = encoder;
            this.lossy = lossy;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            while (this.source.hasNext()) {
                try {
                    this.next = this.encoder.decode(this.source.next().get());
                    this.hasNext = true;
                    return true;
                }
                catch (ValueFormatException vfe) {
                    if (this.lossy) continue;
                    throw vfe;
                }
                break;
            }
            return false;
        }

        @Override
        public V next() {
            if (!this.hasNext && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            V toRet = this.next;
            this.next = null;
            this.hasNext = false;
            return toRet;
        }

        @Override
        public void remove() {
            this.source.remove();
        }
    }
}

