/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public abstract class WrappingIterator
implements SortedKeyValueIterator<Key, Value> {
    private SortedKeyValueIterator<Key, Value> source = null;
    private IteratorEnvironment env = null;
    boolean seenSeek = false;

    protected void setSource(SortedKeyValueIterator<Key, Value> source) {
        this.source = source;
    }

    protected SortedKeyValueIterator<Key, Value> getSource() {
        if (this.source == null) {
            throw new IllegalStateException("getting null source");
        }
        return this.source;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Key getTopKey() {
        if (!this.seenSeek) {
            throw new IllegalStateException("never been seeked");
        }
        return this.getSource().getTopKey();
    }

    @Override
    public Value getTopValue() {
        if (!this.seenSeek) {
            throw new IllegalStateException("never been seeked");
        }
        return this.getSource().getTopValue();
    }

    @Override
    public boolean hasTop() {
        if (!this.seenSeek) {
            throw new IllegalStateException("never been seeked");
        }
        return this.getSource().hasTop();
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.setSource(source);
        this.env = env;
    }

    @Override
    public void next() throws IOException {
        if (!this.seenSeek) {
            throw new IllegalStateException("never been seeked");
        }
        this.getSource().next();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.getSource().seek(range, columnFamilies, inclusive);
        this.seenSeek = true;
    }

    @Override
    public boolean isRunningLowOnMemory() {
        if (this.env == null) {
            return SortedKeyValueIterator.super.isRunningLowOnMemory();
        }
        return this.env.isRunningLowOnMemory();
    }
}

