/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.LinkingIterator;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.RootTabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;

public class TabletsMetadata
implements Iterable<TabletMetadata>,
AutoCloseable {
    private final AutoCloseable closeable;
    private final Iterable<TabletMetadata> tablets;

    public static TableOptions builder(AccumuloClient client) {
        return new Builder(client);
    }

    private static TabletMetadata getRootMetadata(ClientContext ctx, Ample.ReadConsistency readConsistency) {
        String zkRoot = ctx.getZooKeeperRoot();
        switch (readConsistency) {
            case EVENTUAL: {
                return TabletsMetadata.getRootMetadata(zkRoot, ctx.getZooCache());
            }
            case IMMEDIATE: {
                ZooReader zooReader = ctx.getZooReader();
                try {
                    String path = zkRoot + "/root_tablet";
                    zooReader.sync(path);
                    byte[] bytes = zooReader.getData(path);
                    return new RootTabletMetadata(new String(bytes, StandardCharsets.UTF_8)).toTabletMetadata();
                }
                catch (InterruptedException | KeeperException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        throw new IllegalArgumentException("Unknown consistency level " + readConsistency);
    }

    public static TabletMetadata getRootMetadata(String zkRoot, ZooCache zc) {
        byte[] jsonBytes = zc.get(zkRoot + "/root_tablet");
        return new RootTabletMetadata(new String(jsonBytes, StandardCharsets.UTF_8)).toTabletMetadata();
    }

    private TabletsMetadata(TabletMetadata tm) {
        this.closeable = null;
        this.tablets = Collections.singleton(tm);
    }

    private TabletsMetadata(AutoCloseable closeable, Iterable<TabletMetadata> tmi) {
        this.closeable = closeable;
        this.tablets = tmi;
    }

    @Override
    public void close() {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public Iterator<TabletMetadata> iterator() {
        return this.tablets.iterator();
    }

    public Stream<TabletMetadata> stream() {
        return StreamSupport.stream(this.tablets.spliterator(), false);
    }

    private static class TabletMetadataIterator
    implements Iterator<TabletMetadata> {
        private boolean sawLast = false;
        private final Iterator<TabletMetadata> iter;
        private final Text endRow;

        TabletMetadataIterator(Iterator<TabletMetadata> source, Text endRow) {
            this.iter = source;
            this.endRow = endRow;
        }

        @Override
        public boolean hasNext() {
            return !this.sawLast && this.iter.hasNext();
        }

        @Override
        public TabletMetadata next() {
            if (this.sawLast) {
                throw new NoSuchElementException();
            }
            TabletMetadata next = this.iter.next();
            if (next.getExtent().contains((BinaryComparable)this.endRow)) {
                this.sawLast = true;
            }
            return next;
        }
    }

    public static interface TableRangeOptions
    extends Options {
        default public Options overlapping(byte[] startRow, byte[] endRow) {
            return this.overlapping(startRow == null ? null : new Text(startRow), endRow == null ? null : new Text(endRow));
        }

        public Options overlapping(Text var1, Text var2);

        public Options overlapping(Text var1, boolean var2, Text var3);
    }

    public static interface TableOptions {
        public Options forLevel(Ample.DataLevel var1);

        public Options forTablet(KeyExtent var1);

        public Options forTablets(Collection<KeyExtent> var1, Optional<Consumer<KeyExtent>> var2);

        public TableRangeOptions forTable(TableId var1);

        default public RangeOptions scanMetadataTable() {
            return this.scanTable(MetadataTable.NAME);
        }

        public RangeOptions scanTable(String var1);
    }

    public static interface RangeOptions
    extends Options {
        public Options overRange(Range var1);
    }

    public static interface Options {
        public TabletsMetadata build();

        public Options checkConsistency();

        public Options fetch(TabletMetadata.ColumnType ... var1);

        public Options saveKeyValues();

        public Options readConsistency(Ample.ReadConsistency var1);
    }

    public static class Builder
    implements TableRangeOptions,
    TableOptions,
    RangeOptions,
    Options {
        private final List<Text> families = new ArrayList<Text>();
        private final List<ColumnFQ> qualifiers = new ArrayList<ColumnFQ>();
        private Set<KeyExtent> extentsToFetch = null;
        private boolean fetchTablets = false;
        private Optional<Consumer<KeyExtent>> notFoundHandler;
        private Ample.DataLevel level;
        private String table;
        private Range range;
        private EnumSet<TabletMetadata.ColumnType> fetchedCols = EnumSet.noneOf(TabletMetadata.ColumnType.class);
        private Text endRow;
        private boolean checkConsistency = false;
        private boolean saveKeyValues;
        private TableId tableId;
        private Ample.ReadConsistency readConsistency = Ample.ReadConsistency.IMMEDIATE;
        private final AccumuloClient _client;

        Builder(AccumuloClient client) {
            this._client = client;
        }

        @Override
        public TabletsMetadata build() {
            if (this.fetchTablets) {
                Preconditions.checkState((this.range == null && this.table == null && this.level == null && !this.checkConsistency ? 1 : 0) != 0);
                return this.buildExtents(this._client);
            }
            Preconditions.checkState((this.level == null != (this.table == null) ? 1 : 0) != 0, (String)"scanTable() cannot be used in conjunction with forLevel(), forTable() or forTablet() %s %s", (Object)((Object)this.level), (Object)this.table);
            if (this.level == Ample.DataLevel.ROOT) {
                ClientContext ctx = (ClientContext)this._client;
                return new TabletsMetadata(TabletsMetadata.getRootMetadata(ctx, this.readConsistency));
            }
            return this.buildNonRoot(this._client);
        }

        private TabletsMetadata buildExtents(AccumuloClient client) {
            Map<Ample.DataLevel, List<KeyExtent>> groupedExtents = this.extentsToFetch.stream().collect(Collectors.groupingBy(ke -> Ample.DataLevel.of(ke.tableId())));
            ArrayList iterables = new ArrayList();
            ArrayList<BatchScanner> closables = new ArrayList<BatchScanner>();
            Preconditions.checkState((this.extentsToFetch != null ? 1 : 0) != 0);
            if (!this.fetchedCols.isEmpty()) {
                this.fetch(TabletMetadata.ColumnType.PREV_ROW);
            }
            for (Ample.DataLevel level : groupedExtents.keySet()) {
                if (level == Ample.DataLevel.ROOT) {
                    iterables.add(() -> Iterators.singletonIterator((Object)TabletsMetadata.getRootMetadata((ClientContext)client, this.readConsistency)));
                    continue;
                }
                try {
                    BatchScanner scanner = client.createBatchScanner(level.metaTable(), Authorizations.EMPTY);
                    List<Range> list = groupedExtents.get((Object)level).stream().map(KeyExtent::toMetaRange).collect(Collectors.toList());
                    scanner.setRanges(list);
                    this.configureColumns(scanner);
                    IteratorSetting iterSetting = new IteratorSetting(100, WholeRowIterator.class);
                    scanner.addScanIterator(iterSetting);
                    Iterable tmi = () -> Iterators.transform(scanner.iterator(), entry -> {
                        try {
                            return TabletMetadata.convertRow(WholeRowIterator.decodeRow((Key)entry.getKey(), (Value)entry.getValue()).entrySet().iterator(), this.fetchedCols, this.saveKeyValues);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                    iterables.add(tmi);
                    closables.add(scanner);
                }
                catch (TableNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (this.notFoundHandler.isPresent()) {
                HashSet<KeyExtent> extentsNotSeen = new HashSet<KeyExtent>(this.extentsToFetch);
                List<TabletMetadata> tablets = iterables.stream().flatMap(i -> StreamSupport.stream(i.spliterator(), false)).filter(tabletMetadata -> extentsNotSeen.remove(tabletMetadata.getExtent())).collect(Collectors.toList());
                extentsNotSeen.forEach(this.notFoundHandler.orElseThrow());
                for (AutoCloseable autoCloseable : closables) {
                    try {
                        autoCloseable.close();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return new TabletsMetadata(() -> {}, tablets);
            }
            return new TabletsMetadata(() -> {
                for (AutoCloseable closable : closables) {
                    closable.close();
                }
            }, () -> iterables.stream().flatMap(i -> StreamSupport.stream(i.spliterator(), false)).filter(tabletMetadata -> this.extentsToFetch.contains(tabletMetadata.getExtent())).iterator());
        }

        private TabletsMetadata buildNonRoot(AccumuloClient client) {
            try {
                boolean extentsPresent;
                String resolvedTable = this.table == null ? this.level.metaTable() : this.table;
                IsolatedScanner scanner = new IsolatedScanner(client.createScanner(resolvedTable, Authorizations.EMPTY));
                scanner.setRange(this.range);
                boolean bl = extentsPresent = this.extentsToFetch != null;
                if (!this.fetchedCols.isEmpty() && (this.checkConsistency || extentsPresent)) {
                    this.fetch(TabletMetadata.ColumnType.PREV_ROW);
                }
                this.configureColumns(scanner);
                Range range1 = scanner.getRange();
                Function<Range, Iterator> iterFactory = r -> {
                    Scanner scanner2 = scanner;
                    synchronized (scanner2) {
                        scanner.setRange((Range)r);
                        RowIterator rowIter = new RowIterator(scanner);
                        Iterator iter = Iterators.transform((Iterator)rowIter, ri -> TabletMetadata.convertRow(ri, this.fetchedCols, this.saveKeyValues));
                        if (extentsPresent) {
                            return Iterators.filter((Iterator)iter, tabletMetadata -> this.extentsToFetch.contains(tabletMetadata.getExtent()));
                        }
                        return iter;
                    }
                };
                Iterable<TabletMetadata> tmi = this.checkConsistency ? () -> new LinkingIterator(iterFactory, range1) : () -> (Iterator)iterFactory.apply(range1);
                if (this.endRow != null) {
                    return new TabletsMetadata(scanner, () -> new TabletMetadataIterator(tmi.iterator(), this.endRow));
                }
                return new TabletsMetadata(scanner, tmi);
            }
            catch (TableNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        private void configureColumns(ScannerBase scanner) {
            this.families.forEach(scanner::fetchColumnFamily);
            this.qualifiers.forEach(col -> col.fetch(scanner));
            if (this.families.isEmpty() && this.qualifiers.isEmpty()) {
                this.fetchedCols = EnumSet.allOf(TabletMetadata.ColumnType.class);
            }
        }

        @Override
        public Options checkConsistency() {
            Preconditions.checkState((!this.fetchTablets ? 1 : 0) != 0, (Object)"Unable to check consistency of non-contiguous tablets");
            this.checkConsistency = true;
            return this;
        }

        @Override
        public Options fetch(TabletMetadata.ColumnType ... colsToFetch) {
            Preconditions.checkArgument((colsToFetch.length > 0 ? 1 : 0) != 0);
            block16: for (TabletMetadata.ColumnType colToFetch : colsToFetch) {
                this.fetchedCols.add(colToFetch);
                switch (colToFetch) {
                    case CLONED: {
                        this.families.add(MetadataSchema.TabletsSection.ClonedColumnFamily.NAME);
                        continue block16;
                    }
                    case COMPACT_ID: {
                        this.qualifiers.add(MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN);
                        continue block16;
                    }
                    case DIR: {
                        this.qualifiers.add(MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN);
                        continue block16;
                    }
                    case FILES: {
                        this.families.add(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                        continue block16;
                    }
                    case FLUSH_ID: {
                        this.qualifiers.add(MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN);
                        continue block16;
                    }
                    case LAST: {
                        this.families.add(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME);
                        continue block16;
                    }
                    case LOADED: {
                        this.families.add(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME);
                        continue block16;
                    }
                    case LOCATION: {
                        this.families.add(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
                        this.families.add(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
                        continue block16;
                    }
                    case LOGS: {
                        this.families.add(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
                        continue block16;
                    }
                    case PREV_ROW: {
                        this.qualifiers.add(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN);
                        continue block16;
                    }
                    case SCANS: {
                        this.families.add(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME);
                        continue block16;
                    }
                    case SUSPEND: {
                        this.families.add(MetadataSchema.TabletsSection.SuspendLocationColumn.SUSPEND_COLUMN.getColumnFamily());
                        continue block16;
                    }
                    case TIME: {
                        this.qualifiers.add(MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
                        continue block16;
                    }
                    case ECOMP: {
                        this.families.add(MetadataSchema.TabletsSection.ExternalCompactionColumnFamily.NAME);
                        continue block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown col type " + colToFetch);
                    }
                }
            }
            return this;
        }

        @Override
        public Options forLevel(Ample.DataLevel level) {
            this.level = level;
            this.range = MetadataSchema.TabletsSection.getRange();
            return this;
        }

        @Override
        public TableRangeOptions forTable(TableId tableId) {
            this.level = Ample.DataLevel.of(tableId);
            this.tableId = tableId;
            this.range = MetadataSchema.TabletsSection.getRange(tableId);
            return this;
        }

        @Override
        public Options forTablet(KeyExtent extent) {
            this.forTable(extent.tableId());
            this.range = new Range(extent.toMetaRow());
            this.extentsToFetch = Set.of(extent);
            return this;
        }

        @Override
        public Options forTablets(Collection<KeyExtent> extents, Optional<Consumer<KeyExtent>> notFoundHandler) {
            this.level = null;
            this.extentsToFetch = Set.copyOf(extents);
            this.notFoundHandler = Objects.requireNonNull(notFoundHandler);
            this.fetchTablets = true;
            return this;
        }

        @Override
        public Options overRange(Range range) {
            this.range = MetadataSchema.TabletsSection.getRange().clip(range);
            return this;
        }

        @Override
        public Options overlapping(Text startRow, boolean startInclusive, Text endRow) {
            Text metaStartRow = MetadataSchema.TabletsSection.encodeRow(this.tableId, startRow == null ? new Text("") : startRow);
            Text metaEndRow = MetadataSchema.TabletsSection.encodeRow(this.tableId, null);
            this.range = new Range(metaStartRow, startRow == null ? true : startInclusive, metaEndRow, true);
            this.endRow = endRow;
            return this;
        }

        @Override
        public Options overlapping(Text startRow, Text endRow) {
            return this.overlapping(startRow, false, endRow);
        }

        @Override
        public Options saveKeyValues() {
            this.saveKeyValues = true;
            return this;
        }

        @Override
        public RangeOptions scanTable(String tableName) {
            this.table = tableName;
            this.range = MetadataSchema.TabletsSection.getRange();
            return this;
        }

        @Override
        public Options readConsistency(Ample.ReadConsistency readConsistency) {
            this.readConsistency = Objects.requireNonNull(readConsistency);
            return this;
        }
    }
}

