/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;

public class TraceProtocolFactory
extends TCompactProtocol.Factory {
    private static final long serialVersionUID = 1L;

    public TProtocol getProtocol(TTransport trans) {
        return new TCompactProtocol(trans){
            private Span span;
            private Scope scope;
            {
                this.span = null;
                this.scope = null;
            }

            public void writeMessageBegin(TMessage message) throws TException {
                this.span = TraceUtil.startClientRpcSpan(((Object)((Object)this)).getClass(), message.name);
                this.scope = this.span.makeCurrent();
                super.writeMessageBegin(message);
            }

            public void writeMessageEnd() throws TException {
                super.writeMessageEnd();
                this.scope.close();
                this.span.end();
            }
        };
    }
}

