/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.balancer.data;

import java.util.Objects;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;

public class TabletMigration {
    private final TabletId tabletId;
    private final TabletServerId oldTabletServer;
    private final TabletServerId newTabletServer;

    public TabletMigration(TabletId tabletId, TabletServerId oldTabletServer, TabletServerId newTabletServer) {
        this.tabletId = Objects.requireNonNull(tabletId);
        this.oldTabletServer = Objects.requireNonNull(oldTabletServer);
        this.newTabletServer = Objects.requireNonNull(newTabletServer);
    }

    public TabletId getTablet() {
        return this.tabletId;
    }

    public TabletServerId getOldTabletServer() {
        return this.oldTabletServer;
    }

    public TabletServerId getNewTabletServer() {
        return this.newTabletServer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TabletMigration that = (TabletMigration)o;
        return this.tabletId.equals(that.tabletId) && this.oldTabletServer.equals(that.oldTabletServer) && this.newTabletServer.equals(that.newTabletServer);
    }

    public int hashCode() {
        return Objects.hash(this.tabletId, this.oldTabletServer, this.newTabletServer);
    }

    public String toString() {
        return this.tabletId + ": " + this.oldTabletServer + " -> " + this.newTabletServer;
    }
}

