/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.summary;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.summary.Gatherer;
import org.apache.accumulo.core.summary.SummarizerFactory;
import org.apache.accumulo.core.summary.SummaryInfo;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;

class SummarySerializer {
    private SummarizerConfiguration sconf;
    private LgSummaries[] allSummaries;

    private SummarySerializer(SummarizerConfiguration sconf, LgSummaries[] allSummaries) {
        this.sconf = sconf;
        this.allSummaries = allSummaries;
    }

    private SummarySerializer(SummarizerConfiguration sconf) {
        this.sconf = sconf;
        this.allSummaries = null;
    }

    public SummarizerConfiguration getSummarizerConfiguration() {
        return this.sconf;
    }

    public void print(String prefix, String indent, PrintStream out) {
        if (this.allSummaries == null) {
            out.printf("%sSummary not stored because it was too large\n", prefix + indent);
        } else {
            for (LgSummaries lgs : this.allSummaries) {
                lgs.print(prefix, indent, out);
            }
        }
    }

    public Map<String, Long> getSummary(List<Gatherer.RowRange> ranges, SummarizerFactory sf) {
        Summarizer kvs = sf.getSummarizer(this.sconf);
        HashMap<String, Long> summary = new HashMap<String, Long>();
        for (LgSummaries lgs : this.allSummaries) {
            lgs.getSummary(ranges, kvs.combiner(this.sconf), summary);
        }
        return summary;
    }

    public boolean exceedsRange(List<Gatherer.RowRange> ranges) {
        boolean er = false;
        for (LgSummaries lgs : this.allSummaries) {
            for (Gatherer.RowRange ke : ranges) {
                if (!(er |= lgs.exceedsRange(ke.getStartRow(), ke.getEndRow()))) continue;
                return er;
            }
        }
        return er;
    }

    public boolean exceededMaxSize() {
        return this.allSummaries == null;
    }

    public static Builder builder(SummarizerConfiguration conf, SummarizerFactory factory, long maxSize) {
        return new Builder(conf, factory.getSummarizer(conf), maxSize);
    }

    static void skip(DataInputStream in) throws IOException {
        boolean exceededMaxSize = in.readBoolean();
        if (!exceededMaxSize) {
            long len = WritableUtils.readVInt((DataInput)in);
            for (long skipped = in.skip(len); skipped < len; skipped += in.skip(len - skipped)) {
            }
        }
    }

    static SummarySerializer load(SummarizerConfiguration sconf, DataInputStream in) throws IOException {
        boolean exceededMaxSize = in.readBoolean();
        if (exceededMaxSize) {
            return new SummarySerializer(sconf);
        }
        WritableUtils.readVInt((DataInput)in);
        int numSymbols = WritableUtils.readVInt((DataInput)in);
        String[] symbols = new String[numSymbols];
        for (int i = 0; i < numSymbols; ++i) {
            symbols[i] = in.readUTF();
        }
        int numLGroups = WritableUtils.readVInt((DataInput)in);
        LgSummaries[] allSummaries = new LgSummaries[numLGroups];
        for (int i = 0; i < numLGroups; ++i) {
            allSummaries[i] = SummarySerializer.readLGroup(in, symbols);
        }
        return new SummarySerializer(sconf, allSummaries);
    }

    private static LgSummaries readLGroup(DataInputStream in, String[] symbols) throws IOException {
        String lgroupName = in.readUTF();
        Text firstRow = new Text();
        firstRow.readFields((DataInput)in);
        int numSummaries = WritableUtils.readVInt((DataInput)in);
        SummaryInfo[] summaries = new SummaryInfo[numSummaries];
        for (int i = 0; i < numSummaries; ++i) {
            int rowLen = WritableUtils.readVInt((DataInput)in);
            byte[] row = new byte[rowLen];
            in.readFully(row);
            int count = WritableUtils.readVInt((DataInput)in);
            Map<String, Long> summary = SummarySerializer.readSummary(in, symbols);
            summaries[i] = new SummaryInfo(row, summary, count);
        }
        return new LgSummaries(firstRow, summaries, lgroupName);
    }

    private static Map<String, Long> readSummary(DataInputStream in, String[] symbols) throws IOException {
        ImmutableMap.Builder imb = ImmutableMap.builder();
        int numEntries = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < numEntries; ++i) {
            String symbol = symbols[WritableUtils.readVInt((DataInput)in)];
            imb.put((Object)symbol, (Object)WritableUtils.readVLong((DataInput)in));
        }
        return imb.build();
    }

    private static class LgSummaries {
        private Text firstRow;
        private SummaryInfo[] summaries;
        private String lgroupName;

        LgSummaries(Text firstRow, SummaryInfo[] summaries, String lgroupName) {
            this.firstRow = firstRow;
            this.summaries = summaries;
            this.lgroupName = lgroupName;
        }

        boolean exceedsRange(Text startRow, Text endRow) {
            if (this.summaries.length == 0) {
                return false;
            }
            Text lastRow = this.summaries[this.summaries.length - 1].lastRow;
            if (startRow != null && this.firstRow.compareTo((BinaryComparable)startRow) <= 0 && startRow.compareTo((BinaryComparable)lastRow) < 0) {
                return true;
            }
            return endRow != null && endRow.compareTo((BinaryComparable)this.firstRow) >= 0 && lastRow.compareTo((BinaryComparable)endRow) > 0;
        }

        void print(String prefix, String indent, PrintStream out) {
            String p = prefix + indent;
            out.printf("%sLocality group : %s\n", p, this.lgroupName);
            p = p + indent;
            for (SummaryInfo si : this.summaries) {
                out.printf("%sSummary of %d key values (row of last key '%s') : \n", p, si.count, si.lastRow);
                Set<Map.Entry<String, Long>> es = si.summary.entrySet();
                String p2 = p + indent;
                for (Map.Entry<String, Long> entry : es) {
                    out.printf("%s%s = %s\n", p2, entry.getKey(), entry.getValue());
                }
            }
        }

        void getSummary(List<Gatherer.RowRange> ranges, Summarizer.Combiner combiner, Map<String, Long> summary) {
            boolean[] summariesThatOverlap = new boolean[this.summaries.length];
            for (Gatherer.RowRange keyExtent : ranges) {
                int i;
                Text startRow = keyExtent.getStartRow();
                Text endRow = keyExtent.getEndRow();
                if (endRow != null && endRow.compareTo((BinaryComparable)this.firstRow) < 0) continue;
                int start = -1;
                int end = this.summaries.length - 1;
                if (startRow == null) {
                    start = 0;
                } else {
                    for (i = 0; i < this.summaries.length; ++i) {
                        if (startRow.compareTo((BinaryComparable)this.summaries[i].getLastRow()) >= 0) continue;
                        start = i;
                        break;
                    }
                }
                if (start == -1) continue;
                if (endRow == null) {
                    end = this.summaries.length - 1;
                } else {
                    for (i = start; i < this.summaries.length; ++i) {
                        if (endRow.compareTo((BinaryComparable)this.summaries[i].getLastRow()) >= 0) continue;
                        end = i;
                        break;
                    }
                }
                for (i = start; i <= end; ++i) {
                    summariesThatOverlap[i] = true;
                }
            }
            for (int i = 0; i < this.summaries.length; ++i) {
                if (!summariesThatOverlap[i]) continue;
                combiner.merge(summary, this.summaries[i].summary);
            }
        }
    }

    public static class Builder {
        private Summarizer kvs;
        private SummarizerConfiguration conf;
        private List<LgBuilder> locGroups;
        private LgBuilder lgb;
        private long maxSize;

        public Builder(SummarizerConfiguration conf, Summarizer kvs, long maxSize) {
            this.conf = conf;
            this.kvs = kvs;
            this.locGroups = new ArrayList<LgBuilder>();
            this.maxSize = maxSize;
        }

        public void put(Key k, Value v) {
            this.lgb.put(k, v);
        }

        public SummarizerConfiguration getSummarizerConfiguration() {
            return this.conf;
        }

        public void save(DataOutputStream dos) throws IOException {
            if (this.lgb != null) {
                this.lgb.finish();
                this.locGroups.add(this.lgb);
            }
            byte[] data = this._save();
            while ((long)data.length > this.maxSize) {
                boolean collapsedSome = false;
                for (LgBuilder lgBuilder : this.locGroups) {
                    collapsedSome |= lgBuilder.collapse();
                }
                if (!collapsedSome) break;
                data = this._save();
            }
            if ((long)data.length > this.maxSize) {
                dos.writeBoolean(true);
            } else {
                dos.writeBoolean(false);
                WritableUtils.writeVInt((DataOutput)dos, (int)data.length);
                dos.write(data);
            }
        }

        private byte[] _save() throws IOException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Object object;
                try (DataOutputStream dos = new DataOutputStream(baos);){
                    HashMap<String, Integer> symbolTable = new HashMap<String, Integer>();
                    ArrayList<String> symbols = new ArrayList<String>();
                    for (LgBuilder lg : this.locGroups) {
                        for (SummaryInfo si : lg.summaries) {
                            for (String symbol : si.summary.keySet()) {
                                if (symbolTable.containsKey(symbol)) continue;
                                symbolTable.put(symbol, symbols.size());
                                symbols.add(symbol);
                            }
                        }
                    }
                    WritableUtils.writeVInt((DataOutput)dos, (int)symbols.size());
                    for (String symbol : symbols) {
                        dos.writeUTF(symbol);
                    }
                    WritableUtils.writeVInt((DataOutput)dos, (int)this.locGroups.size());
                    for (LgBuilder lg : this.locGroups) {
                        lg.save(dos, symbolTable);
                    }
                    dos.flush();
                    object = baos.toByteArray();
                }
                return object;
            }
        }

        public void startNewLocalityGroup(String name) {
            if (this.lgb != null) {
                this.lgb.finish();
                this.locGroups.add(this.lgb);
            }
            this.lgb = new LgBuilder(this.conf, this.kvs, name);
        }

        public void startDefaultLocalityGroup() {
            if (this.lgb != null) {
                this.lgb.finish();
                this.locGroups.add(this.lgb);
            }
            this.lgb = new LgBuilder(this.conf, this.kvs);
        }
    }

    private static class LgBuilder {
        private Summarizer summarizer;
        private SummarizerConfiguration conf;
        private Summarizer.Collector collector;
        private int maxSummaries = 10;
        private int cutoff = 1000;
        private int count = 0;
        private List<SummaryInfo> summaries = new ArrayList<SummaryInfo>();
        private Key lastKey;
        private SummaryStoreImpl sci = new SummaryStoreImpl();
        private String name;
        private boolean sawFirst = false;
        private Text firstRow;
        private boolean finished = false;

        public LgBuilder(SummarizerConfiguration conf, Summarizer kvs) {
            this.conf = conf;
            this.summarizer = kvs;
            this.name = "<DEFAULT>";
            this.collector = kvs.collector(conf);
        }

        public LgBuilder(SummarizerConfiguration conf, Summarizer kvs, String name) {
            this.conf = conf;
            this.summarizer = kvs;
            this.name = name;
            this.collector = kvs.collector(conf);
        }

        public void put(Key k, Value v) {
            this.collector.accept(k, v);
            ++this.count;
            if (!this.sawFirst) {
                this.firstRow = k.getRow();
                this.sawFirst = true;
            }
            if (this.count >= this.cutoff) {
                this.sci.summaries = new HashMap();
                this.collector.summarize(this.sci);
                this.collector = this.summarizer.collector(this.conf);
                this.addSummary(k.getRow(), this.sci.summaries, this.count);
                this.count = 0;
            }
            this.lastKey = k;
        }

        private List<SummaryInfo> merge(int end) {
            ArrayList<SummaryInfo> mergedSummaries = new ArrayList<SummaryInfo>();
            for (int i = 0; i < end; i += 2) {
                int mergedCount = this.summaries.get((int)i).count + this.summaries.get((int)(i + 1)).count;
                this.summarizer.combiner(this.conf).merge(this.summaries.get((int)i).summary, this.summaries.get((int)(i + 1)).summary);
                mergedSummaries.add(new SummaryInfo(this.summaries.get(i + 1).getLastRow(), this.summaries.get((int)i).summary, mergedCount));
            }
            return mergedSummaries;
        }

        private void addSummary(Text row, Map<String, Long> summary, int count) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            this.summaries.add(new SummaryInfo(row, summary, count));
            if (this.summaries.size() % 2 == 0 && this.summaries.size() > this.maxSummaries) {
                this.summaries = this.merge(this.summaries.size());
                this.cutoff *= 2;
            }
        }

        boolean collapse() {
            Preconditions.checkState((boolean)this.finished);
            if (this.summaries.size() <= 1) {
                return false;
            }
            int end = this.summaries.size();
            if (end % 2 == 1) {
                --end;
            }
            List<SummaryInfo> mergedSummaries = this.merge(end);
            if (this.summaries.size() % 2 == 1) {
                mergedSummaries.add(this.summaries.get(this.summaries.size() - 1));
            }
            this.summaries = mergedSummaries;
            return true;
        }

        void finish() {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            if (this.count > 0) {
                this.sci.summaries = new HashMap();
                this.collector.summarize(this.sci);
                this.collector = null;
                this.addSummary(this.lastKey.getRow(), this.sci.summaries, this.count);
                this.count = 0;
                this.finished = true;
            }
        }

        public void save(DataOutputStream dos, HashMap<String, Integer> symbolTable) throws IOException {
            Preconditions.checkState((this.count == 0 ? 1 : 0) != 0);
            dos.writeUTF(this.name);
            if (this.firstRow == null) {
                WritableUtils.writeVInt((DataOutput)dos, (int)0);
            } else {
                this.firstRow.write((DataOutput)dos);
            }
            WritableUtils.writeVInt((DataOutput)dos, (int)this.summaries.size());
            for (SummaryInfo summaryInfo : this.summaries) {
                summaryInfo.getLastRow().write((DataOutput)dos);
                WritableUtils.writeVInt((DataOutput)dos, (int)summaryInfo.count);
                this.saveSummary(dos, symbolTable, summaryInfo.summary);
            }
        }

        private void saveSummary(DataOutputStream dos, HashMap<String, Integer> symbolTable, Map<String, Long> summary) throws IOException {
            WritableUtils.writeVInt((DataOutput)dos, (int)summary.size());
            for (Map.Entry<String, Long> e : summary.entrySet()) {
                WritableUtils.writeVInt((DataOutput)dos, (int)symbolTable.get(e.getKey()));
                WritableUtils.writeVLong((DataOutput)dos, (long)e.getValue());
            }
        }
    }

    private static class SummaryStoreImpl
    implements Summarizer.StatisticConsumer {
        HashMap<String, Long> summaries;

        private SummaryStoreImpl() {
        }

        @Override
        public void accept(String summary, long value) {
            this.summaries.put(summary, value);
        }
    }
}

