/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.tabletserver.log;

import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.hadoop.io.Text;

public class LogEntry {
    private final KeyExtent extent;
    public final long timestamp;
    public final String filename;

    public LogEntry(KeyExtent extent, long timestamp, String filename) {
        this.extent = extent;
        this.timestamp = timestamp;
        this.filename = filename;
    }

    public LogEntry switchFile(String filename) {
        return new LogEntry(this.extent, this.timestamp, filename);
    }

    public String toString() {
        return this.extent.toMetaRow() + " " + this.filename;
    }

    public static LogEntry fromMetaWalEntry(Map.Entry<Key, Value> entry) {
        Key key = entry.getKey();
        Value value = entry.getValue();
        KeyExtent extent = KeyExtent.fromMetaRow(key.getRow());
        String[] parts = value.toString().split("\\|")[0].split(";");
        String filename = parts[parts.length - 1];
        long timestamp = key.getTimestamp();
        return new LogEntry(extent, timestamp, filename);
    }

    public Text getRow() {
        return this.extent.toMetaRow();
    }

    public Text getColumnFamily() {
        return MetadataSchema.TabletsSection.LogColumnFamily.NAME;
    }

    public String getUniqueID() {
        String[] parts = this.filename.split("/");
        return parts[parts.length - 1];
    }

    public Text getColumnQualifier() {
        return new Text("-/" + this.filename);
    }

    public Value getValue() {
        return new Value(this.filename);
    }
}

