/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.io.Console;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.start.spi.KeywordExecutable;

@AutoService(value={KeywordExecutable.class})
public class CreateToken
implements KeywordExecutable {
    private Console reader = null;

    private Console getConsoleReader() {
        if (this.reader == null) {
            this.reader = System.console();
        }
        return this.reader;
    }

    public static void main(String[] args) {
        new CreateToken().execute(args);
    }

    public String keyword() {
        return "create-token";
    }

    public String description() {
        return "Creates authentication token";
    }

    public void execute(String[] args) {
        AuthenticationToken token;
        String principal;
        Opts opts = new Opts();
        opts.parseArgs("accumulo create-token", args, new Object[0]);
        String pass = opts.password;
        if (pass == null && opts.securePassword != null) {
            pass = opts.securePassword;
        }
        if ((principal = opts.principal) == null) {
            principal = this.getConsoleReader().readLine("Username (aka principal): ", new Object[0]);
        }
        try {
            token = Class.forName(opts.tokenClassName).asSubclass(AuthenticationToken.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
        AuthenticationToken.Properties props = new AuthenticationToken.Properties();
        for (AuthenticationToken.TokenProperty tp : token.getProperties()) {
            String input = pass != null && tp.getKey().equals("password") ? pass : (tp.getMask() ? this.getConsoleReader().readLine(tp.getDescription() + ": ", Character.valueOf('*')) : this.getConsoleReader().readLine(tp.getDescription() + ": ", new Object[0]));
            props.put(tp.getKey(), input);
            token.init(props);
        }
        System.out.println("auth.type = " + opts.tokenClassName);
        System.out.println("auth.principal = " + principal);
        System.out.println("auth.token = " + ClientProperty.encodeToken(token));
    }

    static class Opts
    extends Help {
        @Parameter(names={"-u", "--user"}, description="Connection user")
        public String principal = null;
        @Parameter(names={"-p"}, converter=ClientOpts.PasswordConverter.class, description="Connection password")
        public String password = null;
        @Parameter(names={"--password"}, converter=ClientOpts.PasswordConverter.class, description="Enter the connection password", password=true)
        public String securePassword = null;
        @Parameter(names={"-tc", "--tokenClass"}, description="The class of the authentication token")
        public String tokenClassName = PasswordToken.class.getName();

        Opts() {
        }
    }
}

