/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merge {
    private static final Logger log = LoggerFactory.getLogger(Merge.class);

    protected void message(String format, Object ... args) {
        log.info(String.format(format, args));
    }

    public void start(String[] args) throws MergeException {
        Opts opts = new Opts();
        opts.parseArgs(Merge.class.getName(), args, new Object[0]);
        Span span = TraceUtil.startSpan(Merge.class, "start");
        try (Scope scope = span.makeCurrent();){
            try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
                if (!client.tableOperations().exists(opts.tableName)) {
                    System.err.println("table " + opts.tableName + " does not exist");
                    return;
                }
                if (opts.goalSize == null || opts.goalSize < 1L) {
                    ConfigurationCopy tableConfig = new ConfigurationCopy(client.tableOperations().getConfiguration(opts.tableName));
                    opts.goalSize = tableConfig.getAsBytes(Property.TABLE_SPLIT_THRESHOLD);
                }
                this.message("Merging tablets in table %s to %d bytes", opts.tableName, opts.goalSize);
                this.mergomatic(client, opts.tableName, opts.begin, opts.end, opts.goalSize, opts.force);
            }
            catch (Exception ex) {
                TraceUtil.setException(span, ex, true);
                throw new MergeException(ex);
            }
            finally {
                span.end();
            }
        }
    }

    public static void main(String[] args) throws MergeException {
        Merge merge = new Merge();
        merge.start(args);
    }

    public void mergomatic(AccumuloClient client, String table, Text start, Text end, long goalSize, boolean force) throws MergeException {
        try {
            if (table.equals(MetadataTable.NAME)) {
                throw new IllegalArgumentException("cannot merge tablets on the metadata table");
            }
            ArrayList<Size> sizes = new ArrayList<Size>();
            long totalSize = 0L;
            Iterator<Size> sizeIterator = this.getSizeIterator(client, table, start, end);
            while (sizeIterator.hasNext()) {
                Size next = sizeIterator.next();
                sizes.add(next);
                if ((totalSize += next.size) <= goalSize) continue;
                totalSize = this.mergeMany(client, table, sizes, goalSize, force, false);
            }
            if (sizes.size() > 1) {
                this.mergeMany(client, table, sizes, goalSize, force, true);
            }
        }
        catch (Exception ex) {
            throw new MergeException(ex);
        }
    }

    protected long mergeMany(AccumuloClient client, String table, List<Size> sizes, long goalSize, boolean force, boolean last) throws MergeException {
        while (!sizes.isEmpty() && sizes.get((int)0).size >= goalSize) {
            sizes.remove(0);
        }
        if (sizes.isEmpty()) {
            return 0L;
        }
        long mergeSize = 0L;
        int numToMerge = 0;
        for (int i = 0; i < sizes.size(); ++i) {
            if (mergeSize + sizes.get((int)i).size > goalSize) {
                numToMerge = i;
                break;
            }
            mergeSize += sizes.get((int)i).size;
        }
        if (numToMerge > 1) {
            this.mergeSome(client, table, sizes, numToMerge);
        } else if (numToMerge == 1 && sizes.size() > 1) {
            if (force) {
                this.mergeSome(client, table, sizes, 2);
            } else {
                sizes.remove(0);
            }
        }
        if (numToMerge == 0 && sizes.size() > 1 && last) {
            this.mergeSome(client, table, sizes, sizes.size());
        }
        long result = 0L;
        for (Size s : sizes) {
            result += s.size;
        }
        return result;
    }

    protected void mergeSome(AccumuloClient client, String table, List<Size> sizes, int numToMerge) throws MergeException {
        this.merge(client, table, sizes, numToMerge);
        for (int i = 0; i < numToMerge; ++i) {
            sizes.remove(0);
        }
    }

    protected void merge(AccumuloClient client, String table, List<Size> sizes, int numToMerge) throws MergeException {
        try {
            Text start = sizes.get((int)0).extent.prevEndRow();
            Text end = sizes.get((int)(numToMerge - 1)).extent.endRow();
            this.message("Merging %d tablets from (%s to %s]", numToMerge, start == null ? "-inf" : Key.toPrintableString(start.getBytes(), 0, start.getLength(), start.getLength()), end == null ? "+inf" : Key.toPrintableString(end.getBytes(), 0, end.getLength(), end.getLength()));
            client.tableOperations().merge(table, start, end);
        }
        catch (Exception ex) {
            throw new MergeException(ex);
        }
    }

    protected Iterator<Size> getSizeIterator(AccumuloClient client, String tablename, Text start, Text end) throws MergeException {
        TabletsMetadata tablets;
        try {
            ClientContext context = (ClientContext)client;
            TableId tableId = context.getTableId(tablename);
            tablets = TabletsMetadata.builder(context).scanMetadataTable().overRange(new KeyExtent(tableId, end, start).toMetaRange()).fetch(TabletMetadata.ColumnType.FILES, TabletMetadata.ColumnType.PREV_ROW).build();
        }
        catch (Exception e) {
            throw new MergeException(e);
        }
        return tablets.stream().map(tm -> {
            long size = tm.getFilesMap().values().stream().mapToLong(DataFileValue::getSize).sum();
            return new Size(tm.getExtent(), size);
        }).iterator();
    }

    public static class Size {
        KeyExtent extent;
        long size;

        public Size(KeyExtent extent, long size) {
            this.extent = extent;
            this.size = size;
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"-t", "--table"}, required=true, description="table to use")
        String tableName;
        @Parameter(names={"-s", "--size"}, description="merge goal size", converter=MemoryConverter.class)
        Long goalSize = null;
        @Parameter(names={"-f", "--force"}, description="merge small tablets even if merging them to larger tablets might cause a split")
        boolean force = false;
        @Parameter(names={"-b", "--begin"}, description="start tablet", converter=TextConverter.class)
        Text begin = null;
        @Parameter(names={"-e", "--end"}, description="end tablet", converter=TextConverter.class)
        Text end = null;

        Opts() {
        }
    }

    static class TextConverter
    implements IStringConverter<Text> {
        TextConverter() {
        }

        public Text convert(String value) {
            return new Text(value);
        }
    }

    public static class MemoryConverter
    implements IStringConverter<Long> {
        public Long convert(String value) {
            return ConfigurationTypeHelper.getFixedMemoryAsBytes(value);
        }
    }

    public static class MergeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        MergeException(Exception ex) {
            super(ex);
        }
    }
}

