/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.create;

import java.io.IOException;
import org.apache.accumulo.core.client.admin.InitialTableState;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.TableInfo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FinishCreateTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(FinishCreateTable.class);
    private final TableInfo tableInfo;

    public FinishCreateTable(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        if (this.tableInfo.getInitialTableState() == InitialTableState.OFFLINE) {
            env.getContext().getTableManager().transitionTableState(this.tableInfo.getTableId(), TableState.OFFLINE);
        } else {
            env.getContext().getTableManager().transitionTableState(this.tableInfo.getTableId(), TableState.ONLINE);
        }
        Utils.unreserveNamespace(env, this.tableInfo.getNamespaceId(), tid, false);
        Utils.unreserveTable(env, this.tableInfo.getTableId(), tid, true);
        env.getEventCoordinator().event("Created table %s ", this.tableInfo.getTableName());
        if (this.tableInfo.getInitialSplitSize() > 0) {
            this.cleanupSplitFiles(env);
        }
        return null;
    }

    private void cleanupSplitFiles(Manager env) throws IOException {
        Path p = null;
        try {
            p = this.tableInfo.getSplitPath().getParent();
            FileSystem fs = p.getFileSystem(env.getContext().getHadoopConf());
            fs.delete(p, true);
        }
        catch (IOException e) {
            log.error("Table was created, but failed to clean up temporary splits files at {}", (Object)p, (Object)e);
        }
    }

    @Override
    public String getReturn() {
        return this.tableInfo.getTableId().canonical();
    }

    @Override
    public void undo(long tid, Manager env) {
    }
}

