/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.tableImport;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TableOperationsImpl;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.tableImport.ImportSetupPermissions;
import org.apache.accumulo.manager.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.server.AccumuloDataVersion;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTable
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(ImportTable.class);
    private static final long serialVersionUID = 2L;
    private final ImportedTableInfo tableInfo = new ImportedTableInfo();

    public ImportTable(String user, String tableName, Set<String> exportDirs, NamespaceId namespaceId, boolean keepMappings, boolean onlineTable) {
        this.tableInfo.tableName = tableName;
        this.tableInfo.user = user;
        this.tableInfo.namespaceId = namespaceId;
        this.tableInfo.directories = ImportTable.parseExportDir(exportDirs);
        this.tableInfo.keepMappings = keepMappings;
        this.tableInfo.onlineTable = onlineTable;
    }

    @Override
    public long isReady(long tid, Manager environment) throws Exception {
        long result = 0L;
        for (ImportedTableInfo.DirectoryMapping dm : this.tableInfo.directories) {
            result += Utils.reserveHdfsDirectory(environment, new Path(dm.exportDir).toString(), tid);
        }
        return result += Utils.reserveNamespace(environment, this.tableInfo.namespaceId, tid, false, true, TableOperation.IMPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        this.checkVersions(env);
        Utils.getIdLock().lock();
        try {
            this.tableInfo.tableId = Utils.getNextId(this.tableInfo.tableName, env.getContext(), TableId::of);
            ImportSetupPermissions importSetupPermissions = new ImportSetupPermissions(this.tableInfo);
            return importSetupPermissions;
        }
        finally {
            Utils.getIdLock().unlock();
        }
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="closing intermediate readers would close the ZipInputStream")
    public void checkVersions(Manager env) throws AcceptableThriftTableOperationException {
        Set exportDirs = this.tableInfo.directories.stream().map(dm -> dm.exportDir).collect(Collectors.toSet());
        log.debug("Searching for export file in {}", exportDirs);
        Integer exportVersion = null;
        Integer dataVersion = null;
        try {
            ZipEntry zipEntry;
            Path exportFilePath = TableOperationsImpl.findExportFile((ClientContext)env.getContext(), exportDirs);
            this.tableInfo.exportFile = exportFilePath.toString();
            log.info("Export file is {}", (Object)this.tableInfo.exportFile);
            ZipInputStream zis = new ZipInputStream((InputStream)env.getVolumeManager().open(exportFilePath));
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (!zipEntry.getName().equals("accumulo_export_info.txt")) continue;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String[] sa = line.split(":", 2);
                    if (sa[0].equals("exportVersion")) {
                        exportVersion = Integer.parseInt(sa[1]);
                        continue;
                    }
                    if (!sa[0].equals("srcDataVersion")) continue;
                    dataVersion = Integer.parseInt(sa[1]);
                }
                break;
            }
        }
        catch (IOException | AccumuloException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
            throw new AcceptableThriftTableOperationException(null, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Failed to read export metadata " + e.getMessage());
        }
        if (exportVersion == null || exportVersion > 1) {
            throw new AcceptableThriftTableOperationException(null, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Incompatible export version " + exportVersion);
        }
        if (dataVersion == null || dataVersion > AccumuloDataVersion.get()) {
            throw new AcceptableThriftTableOperationException(null, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Incompatible data version " + dataVersion);
        }
    }

    @Override
    public void undo(long tid, Manager env) throws Exception {
        for (ImportedTableInfo.DirectoryMapping dm : this.tableInfo.directories) {
            Utils.unreserveHdfsDirectory(env, new Path(dm.exportDir).toString(), tid);
        }
        Utils.unreserveNamespace(env, this.tableInfo.namespaceId, tid, false);
    }

    static List<ImportedTableInfo.DirectoryMapping> parseExportDir(Set<String> exportDirs) {
        if (exportDirs == null || exportDirs.isEmpty()) {
            return Collections.emptyList();
        }
        return exportDirs.stream().filter(Predicate.not(String::isEmpty)).map(ImportedTableInfo.DirectoryMapping::new).collect(Collectors.toList());
    }
}

