/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MiniDFSUtil {
    public static String computeDatanodeDirectoryPermission() {
        String string;
        Process p = Runtime.getRuntime().exec("/bin/sh -c umask");
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String line = bri.readLine();
            p.waitFor();
            if (line == null) {
                throw new IOException("umask input stream closed prematurely");
            }
            short umask = Short.parseShort(line.trim(), 8);
            int newPermission = 0x1FF ^ umask;
            string = String.format("%03o", newPermission);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bri.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InterruptedException e) {
                throw new IllegalStateException("Error getting umask from O/S", e);
            }
        }
        bri.close();
        return string;
    }
}

