/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.tables;

import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.manager.thrift.TableInfo;
import org.apache.accumulo.core.manager.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.tables.TableInformation;
import org.apache.accumulo.monitor.rest.tables.TableInformationList;
import org.apache.accumulo.monitor.rest.tservers.TabletServer;
import org.apache.accumulo.monitor.rest.tservers.TabletServers;
import org.apache.accumulo.server.manager.state.MetaDataTableScanner;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.hadoop.io.Text;

@Path(value="/tables")
@Produces(value={"application/json", "application/xml"})
public class TablesResource {
    @Inject
    private Monitor monitor;
    private static final TabletServerStatus NO_STATUS = new TabletServerStatus();

    @GET
    public TableInformationList getTables() {
        return TablesResource.getTables(this.monitor);
    }

    public static TableInformationList getTables(Monitor monitor) {
        TableInformationList tableList = new TableInformationList();
        ManagerMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return tableList;
        }
        TreeMap<TableId, TableInfo> tableStats = new TreeMap<TableId, TableInfo>();
        if (mmi.tableMap != null) {
            for (Map.Entry te : mmi.tableMap.entrySet()) {
                tableStats.put(TableId.of((String)((String)te.getKey())), (TableInfo)te.getValue());
            }
        }
        Map compactingByTable = TableInfoUtil.summarizeTableStats((ManagerMonitorInfo)mmi);
        TableManager tableManager = monitor.getContext().getTableManager();
        for (Map.Entry entry : monitor.getContext().getTableNameToIdMap().entrySet()) {
            String tableName = (String)entry.getKey();
            TableId tableId = (TableId)entry.getValue();
            TableInfo tableInfo = (TableInfo)tableStats.get(tableId);
            TableState tableState = tableManager.getTableState(tableId);
            if (tableInfo != null && tableState != TableState.OFFLINE) {
                Double holdTime = (Double)compactingByTable.get(tableId.canonical());
                if (holdTime == null) {
                    holdTime = 0.0;
                }
                tableList.addTable(new TableInformation(tableName, tableId, tableInfo, holdTime, tableState.name()));
                continue;
            }
            tableList.addTable(new TableInformation(tableName, tableId, tableState.name()));
        }
        return tableList;
    }

    @Path(value="{tableId}")
    @GET
    public TabletServers getParticipatingTabletServers(@PathParam(value="tableId") @NotNull @Pattern(regexp="[!+]?\\w+") @NotNull @Pattern(regexp="[!+]?\\w+") String tableIdStr) {
        String rootTabletLocation = this.monitor.getContext().getRootTabletLocation();
        TableId tableId = TableId.of((String)tableIdStr);
        ManagerMonitorInfo mmi = this.monitor.getMmi();
        if (mmi == null) {
            return new TabletServers();
        }
        TabletServers tabletServers = new TabletServers(mmi.tServerInfo.size());
        if (tableIdStr.isBlank()) {
            return tabletServers;
        }
        TreeSet<String> locs = new TreeSet<String>();
        if (RootTable.ID.equals((Object)tableId)) {
            locs.add(rootTabletLocation);
        } else {
            String systemTableName = MetadataTable.ID.equals((Object)tableId) ? RootTable.NAME : MetadataTable.NAME;
            MetaDataTableScanner scanner = new MetaDataTableScanner((ClientContext)this.monitor.getContext(), new Range(MetadataSchema.TabletsSection.encodeRow((TableId)tableId, (Text)new Text()), MetadataSchema.TabletsSection.encodeRow((TableId)tableId, null)), systemTableName);
            while (scanner.hasNext()) {
                TabletLocationState state = scanner.next();
                if (state.current == null) continue;
                try {
                    locs.add(state.current.getHostPort());
                }
                catch (Exception ex) {
                    scanner.close();
                    return tabletServers;
                }
            }
            scanner.close();
        }
        ArrayList<TabletServerStatus> tservers = new ArrayList<TabletServerStatus>();
        for (TabletServerStatus tss : mmi.tServerInfo) {
            try {
                if (tss.name == null || !locs.contains(tss.name)) continue;
                tservers.add(tss);
            }
            catch (Exception ex) {
                return tabletServers;
            }
        }
        for (TabletServerStatus status : tservers) {
            TableInfo summary;
            if (status == null) {
                status = NO_STATUS;
            }
            if ((summary = (TableInfo)status.tableMap.get(tableId.canonical())) == null) continue;
            TabletServer tabletServerInfo = new TabletServer();
            tabletServerInfo.server.updateTabletServerInfo(this.monitor, status, summary);
            tabletServers.addTablet(tabletServerInfo);
        }
        return tabletServers;
    }
}

