/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.lang.ref.Cleaner;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.util.cleaner.CleanerUtil;
import org.apache.accumulo.tserver.NativeMap;
import org.slf4j.Logger;

public class NativeMapCleanerUtil {
    public static Cleaner.Cleanable deleteNM(Object obj, Logger log, AtomicLong nmPtr) {
        Objects.requireNonNull(nmPtr);
        Objects.requireNonNull(log);
        return CleanerUtil.CLEANER.register(obj, () -> {
            long nmPointer = nmPtr.get();
            if (nmPointer != 0L) {
                log.warn(String.format("Deallocating native map 0x%016x in finalize", nmPointer));
                NativeMap._deleteNativeMap(nmPointer);
            }
        });
    }

    public static Cleaner.Cleanable deleteNMIterator(Object obj, AtomicLong nmiPtr) {
        Objects.requireNonNull(nmiPtr);
        return CleanerUtil.CLEANER.register(obj, () -> {
            long nmiPointer = nmiPtr.get();
            if (nmiPointer != 0L) {
                NativeMap._deleteNMI(nmiPointer);
            }
        });
    }
}

