/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.IteratorBuilder;
import org.apache.accumulo.core.iteratorsImpl.IteratorConfigUtil;
import org.apache.accumulo.core.iteratorsImpl.system.IterationInterruptedException;
import org.apache.accumulo.core.iteratorsImpl.system.MultiIterator;
import org.apache.accumulo.core.iteratorsImpl.system.SourceSwitchingIterator;
import org.apache.accumulo.core.iteratorsImpl.system.StatsIterator;
import org.apache.accumulo.core.iteratorsImpl.system.SystemIteratorUtil;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.FileManager;
import org.apache.accumulo.server.iterators.TabletIteratorEnvironment;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.scan.ScanParameters;
import org.apache.accumulo.tserver.tablet.TabletBase;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScanDataSource
implements SourceSwitchingIterator.DataSource {
    private static final Logger log = LoggerFactory.getLogger(ScanDataSource.class);
    private final TabletBase tablet;
    private FileManager.ScanFileManager fileManager;
    private SortedKeyValueIterator<Key, Value> iter;
    private long expectedDeletionCount;
    private List<InMemoryMap.MemoryIterator> memIters = null;
    private long fileReservationId;
    private AtomicBoolean interruptFlag;
    private StatsIterator statsIterator;
    private final ScanParameters scanParams;
    private final boolean loadIters;
    private final byte[] defaultLabels;

    ScanDataSource(TabletBase tablet, ScanParameters scanParams, boolean loadIters, AtomicBoolean interruptFlag) {
        this.tablet = tablet;
        this.expectedDeletionCount = tablet.getDataSourceDeletions();
        this.scanParams = scanParams;
        this.interruptFlag = interruptFlag;
        this.loadIters = loadIters;
        this.defaultLabels = tablet.getDefaultSecurityLabels();
        if (log.isTraceEnabled()) {
            log.trace("new scan data source, tablet: {}, params: {}, loadIterators: {}", new Object[]{this.tablet, this.scanParams, this.loadIters});
        }
    }

    public SourceSwitchingIterator.DataSource getNewDataSource() {
        if (this.isCurrent()) {
            return this;
        }
        if (this.memIters != null) {
            this.tablet.returnMemIterators(this.memIters);
            this.memIters = null;
            this.tablet.returnFilesForScan(this.fileReservationId);
            this.fileReservationId = -1L;
        }
        if (this.fileManager != null) {
            this.tablet.getScanMetrics().decrementOpenFiles(this.fileManager.getNumOpenFiles());
            this.fileManager.releaseOpenFiles(false);
        }
        this.expectedDeletionCount = this.tablet.getDataSourceDeletions();
        this.iter = null;
        return this;
    }

    public boolean isCurrent() {
        return this.expectedDeletionCount == this.tablet.getDataSourceDeletions();
    }

    public SortedKeyValueIterator<Key, Value> iterator() throws IOException {
        if (this.iter == null) {
            this.iter = this.createIterator();
        }
        return this.iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedKeyValueIterator<Key, Value> createIterator() throws IOException {
        Map files;
        SamplerConfigurationImpl samplerConfig = this.scanParams.getSamplerConfigurationImpl();
        TabletBase tabletBase = this.tablet;
        synchronized (tabletBase) {
            if (this.memIters != null) {
                throw new IllegalStateException("Tried to create new scan iterator w/o releasing memory");
            }
            if (this.tablet.isClosed()) {
                throw new TabletClosedException();
            }
            if (this.interruptFlag.get()) {
                throw new IterationInterruptedException(this.tablet.getExtent() + " " + this.interruptFlag.hashCode());
            }
            if (this.fileManager == null) {
                this.fileManager = this.tablet.getTabletResources().newScanFileManager(this.scanParams.getScanDispatch());
                this.tablet.getScanMetrics().incrementOpenFiles(this.fileManager.getNumOpenFiles());
                this.tablet.addActiveScans(this);
            }
            if (this.fileManager.getNumOpenFiles() != 0) {
                throw new IllegalStateException("Tried to create new scan iterator w/o releasing files");
            }
            this.expectedDeletionCount = this.tablet.getDataSourceDeletions();
            this.memIters = this.tablet.getMemIterators(samplerConfig);
            Pair<Long, Map<StoredTabletFile, DataFileValue>> reservation = this.tablet.reserveFilesForScan();
            this.fileReservationId = (Long)reservation.getFirst();
            files = (Map)reservation.getSecond();
        }
        List datafiles = this.fileManager.openFiles(files, this.scanParams.isIsolated(), samplerConfig);
        List.of(datafiles, this.memIters).forEach(c -> c.forEach(ii -> ii.setInterruptFlag(this.interruptFlag)));
        ArrayList<InMemoryMap.MemoryIterator> iters = new ArrayList<InMemoryMap.MemoryIterator>(datafiles.size() + this.memIters.size());
        iters.addAll(datafiles);
        iters.addAll(this.memIters);
        MultiIterator multiIter = new MultiIterator(iters, this.tablet.getExtent());
        TabletIteratorEnvironment iterEnv = new TabletIteratorEnvironment(this.tablet.getContext(), IteratorUtil.IteratorScope.scan, (AccumuloConfiguration)this.tablet.getTableConfiguration(), this.tablet.getExtent().tableId(), this.fileManager, files, this.scanParams.getAuthorizations(), samplerConfig, new ArrayList());
        this.statsIterator = new StatsIterator((SortedKeyValueIterator)multiIter, TabletServer.seekCount, this.tablet.getScannedCounter(), this.tablet.getScanMetrics().getScannedCounter());
        SortedKeyValueIterator visFilter = SystemIteratorUtil.setupSystemScanIterators((SortedKeyValueIterator)this.statsIterator, this.scanParams.getColumnSet(), (Authorizations)this.scanParams.getAuthorizations(), (byte[])this.defaultLabels, (AccumuloConfiguration)this.tablet.getTableConfiguration());
        if (this.loadIters) {
            String context;
            HashMap iterOpts;
            ArrayList iterInfos;
            TableConfiguration.ParsedIteratorConfig pic = this.tablet.getTableConfiguration().getParsedIteratorConfig(IteratorUtil.IteratorScope.scan);
            if (this.scanParams.getSsiList().isEmpty() && this.scanParams.getSsio().isEmpty()) {
                iterInfos = pic.getIterInfo();
                iterOpts = pic.getOpts();
            } else {
                iterOpts = new HashMap(pic.getOpts().size() + this.scanParams.getSsio().size());
                iterInfos = new ArrayList(pic.getIterInfo().size() + this.scanParams.getSsiList().size());
                IteratorConfigUtil.mergeIteratorConfig(iterInfos, iterOpts, (List)pic.getIterInfo(), (Map)pic.getOpts(), this.scanParams.getSsiList(), this.scanParams.getSsio());
            }
            if (this.scanParams.getClassLoaderContext() != null) {
                log.trace("Loading iterators for scan with scan context: {}", (Object)this.scanParams.getClassLoaderContext());
                context = this.scanParams.getClassLoaderContext();
            } else {
                context = pic.getServiceEnv();
                if (context != null) {
                    log.trace("Loading iterators for scan with table context: {}", (Object)this.scanParams.getClassLoaderContext());
                } else {
                    log.trace("Loading iterators for scan");
                }
            }
            IteratorBuilder iteratorBuilder = IteratorBuilder.builder(iterInfos).opts(iterOpts).env((IteratorEnvironment)iterEnv).useClassLoader(context).build();
            return iterEnv.getTopLevelIterator(IteratorConfigUtil.loadIterators((SortedKeyValueIterator)visFilter, (IteratorBuilder)iteratorBuilder));
        }
        return visFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean sawErrors) {
        if (this.memIters != null) {
            this.tablet.returnMemIterators(this.memIters);
            this.memIters = null;
            this.tablet.returnFilesForScan(this.fileReservationId);
            this.fileReservationId = -1L;
        }
        TabletBase tabletBase = this.tablet;
        synchronized (tabletBase) {
            if (this.tablet.removeScan(this) == 0) {
                this.tablet.notifyAll();
            }
        }
        if (this.fileManager != null) {
            this.tablet.getScanMetrics().decrementOpenFiles(this.fileManager.getNumOpenFiles());
            this.fileManager.releaseOpenFiles(sawErrors);
            this.fileManager = null;
        }
        if (this.statsIterator != null) {
            this.statsIterator.report();
        }
    }

    public void interrupt() {
        this.interruptFlag.set(true);
    }

    public SourceSwitchingIterator.DataSource getDeepCopyDataSource(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public void reattachFileManager() throws IOException {
        if (this.fileManager != null) {
            this.fileManager.reattach(this.scanParams.getSamplerConfigurationImpl());
        }
    }

    public void detachFileManager() {
        if (this.fileManager != null) {
            this.fileManager.detach();
        }
    }

    public void setInterruptFlag(AtomicBoolean flag) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("isNull(memIters)", this.memIters == null).append("isNull(fileManager)", this.fileManager == null).append("fileReservationId", this.fileReservationId).append("interruptFlag", this.interruptFlag.get()).append("expectedDeletionCount", this.expectedDeletionCount).append("scanParams", (Object)this.scanParams).toString();
    }
}

