/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.routing.ConnectionRouter;
import org.apache.activemq.artemis.core.server.routing.RoutingContext;
import org.apache.activemq.artemis.core.server.routing.targets.TargetResult;

public abstract class RoutingHandler<T extends RoutingContext> {
    private final ActiveMQServer server;

    public ActiveMQServer getServer() {
        return this.server;
    }

    protected RoutingHandler(ActiveMQServer server) {
        this.server = server;
    }

    protected abstract void refuse(T var1) throws Exception;

    protected abstract void redirect(T var1) throws Exception;

    protected boolean route(T context) throws Exception {
        ConnectionRouter connectionRouter = this.getServer().getConnectionRouterManager().getRouter(((RoutingContext)context).getRouter());
        if (connectionRouter == null) {
            ActiveMQServerLogger.LOGGER.connectionRouterNotFound(((RoutingContext)context).getRouter());
            this.refuse(context);
            return true;
        }
        ((RoutingContext)context).setResult(connectionRouter.getTarget(((RoutingContext)context).getTransportConnection(), ((RoutingContext)context).getClientID(), ((RoutingContext)context).getUsername()));
        if (TargetResult.Status.OK != ((RoutingContext)context).getResult().getStatus()) {
            ActiveMQServerLogger.LOGGER.cannotRouteClientConnection(((RoutingContext)context).getTransportConnection());
            this.refuse(context);
            return true;
        }
        ActiveMQServerLogger.LOGGER.routeClientConnection(((RoutingContext)context).getTransportConnection(), ((RoutingContext)context).getTarget());
        if (!((RoutingContext)context).getTarget().isLocal()) {
            this.redirect(context);
            return true;
        }
        return false;
    }
}

