/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.activemq.store.kahadb.disk.util.CommandLineSupport;
import org.apache.activemq.util.RecoverableRandomAccessFile;

public class DiskBenchmark {
    private static final boolean SKIP_METADATA_UPDATE = Boolean.getBoolean("org.apache.activemq.file.skipMetadataUpdate");
    boolean verbose;
    int bs = 4096;
    long size = 524288000L;
    long sampleInterval = 10000L;

    public static void main(String[] args) {
        DiskBenchmark benchmark = new DiskBenchmark();
        args = CommandLineSupport.setOptions(benchmark, args);
        ArrayList<String> files = new ArrayList<String>();
        if (args.length == 0) {
            files.add("disk-benchmark.dat");
        } else {
            files.addAll(Arrays.asList(args));
        }
        for (String f : files) {
            try {
                File file = new File(f);
                if (file.exists()) {
                    System.out.println("File " + file + " already exists, will not benchmark.");
                    continue;
                }
                System.out.println("Benchmarking: " + file.getCanonicalPath());
                Report report = benchmark.benchmark(file);
                file.delete();
                System.out.println(report.toString());
            }
            catch (Throwable e) {
                if (benchmark.verbose) {
                    System.out.println("ERROR:");
                    e.printStackTrace(System.out);
                    continue;
                }
                System.out.println("ERROR: " + e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public Report benchmark(File file) throws Exception {
        rc = new Report();
        data = new byte[this.bs];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)(97 + i % 26);
        }
        rc.size = data.length;
        raf = new RecoverableRandomAccessFile(file, "rw");
        var10_7 = null;
        try {
            this.preallocateDataFile(raf, file.getParentFile());
            start = System.currentTimeMillis();
            now = System.currentTimeMillis();
            ioCount = 0;
            while (now - start <= this.sampleInterval) {
                raf.seek(0L);
                i = 0L;
                while (i + (long)data.length < this.size) {
                    raf.write(data);
                    ++ioCount;
                    now = System.currentTimeMillis();
                    if (now - start > this.sampleInterval) break;
                    i += (long)data.length;
                }
                raf.getChannel().force(DiskBenchmark.SKIP_METADATA_UPDATE == false);
            }
            raf.getChannel().force(DiskBenchmark.SKIP_METADATA_UPDATE == false);
        }
        catch (Throwable i) {
            var10_7 = i;
            throw i;
        }
        finally {
            if (raf != null) {
                if (var10_7 != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable i) {
                        var10_7.addSuppressed(i);
                    }
                } else {
                    raf.close();
                }
            }
        }
        now = System.currentTimeMillis();
        rc.size = data.length;
        rc.writes = ioCount;
        rc.writeDuration = now - start;
        raf = new RecoverableRandomAccessFile(file, "rw");
        var10_7 = null;
        try {
            start = System.currentTimeMillis();
            now = System.currentTimeMillis();
            ioCount = 0;
            block30: while (true) {
                if (now - start > this.sampleInterval) {
                    break;
                }
                i = 0L;
                while (true) {
                    if (i + (long)data.length >= this.size) continue block30;
                    raf.seek(i);
                    raf.write(data);
                    raf.getChannel().force(DiskBenchmark.SKIP_METADATA_UPDATE == false);
                    ++ioCount;
                    now = System.currentTimeMillis();
                    if (now - start <= this.sampleInterval) ** break;
                    continue block30;
                    i += (long)data.length;
                }
                break;
            }
        }
        catch (Throwable i) {
            var10_7 = i;
            throw i;
        }
        finally {
            if (raf != null) {
                if (var10_7 != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable i) {
                        var10_7.addSuppressed(i);
                    }
                } else {
                    raf.close();
                }
            }
        }
        now = System.currentTimeMillis();
        rc.syncWrites = ioCount;
        rc.syncWriteDuration = now - start;
        raf = new RecoverableRandomAccessFile(file, "rw");
        var10_7 = null;
        try {
            start = System.currentTimeMillis();
            now = System.currentTimeMillis();
            ioCount = 0;
            block32: while (true) {
                if (now - start > this.sampleInterval) {
                    break;
                }
                raf.seek(0L);
                i = 0L;
                while (true) {
                    if (i + (long)data.length >= this.size) continue block32;
                    raf.seek(i);
                    raf.readFully(data);
                    ++ioCount;
                    now = System.currentTimeMillis();
                    if (now - start <= this.sampleInterval) ** break;
                    continue block32;
                    i += (long)data.length;
                }
                break;
            }
        }
        catch (Throwable var11_19) {
            var10_7 = var11_19;
            throw var11_19;
        }
        finally {
            if (raf != null) {
                if (var10_7 != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable var11_18) {
                        var10_7.addSuppressed(var11_18);
                    }
                } else {
                    raf.close();
                }
            }
        }
        rc.reads = ioCount;
        rc.readDuration = now - start;
        return rc;
    }

    private void preallocateDataFile(RecoverableRandomAccessFile raf, File location) throws Exception {
        File tmpFile = location != null && location.isDirectory() ? new File(location, "template.dat") : new File("template.dat");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        RandomAccessFile templateFile = new RandomAccessFile(tmpFile, "rw");
        templateFile.setLength(this.size);
        templateFile.getChannel().force(true);
        templateFile.getChannel().transferTo(0L, this.size, raf.getChannel());
        templateFile.close();
        tmpFile.delete();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getBs() {
        return this.bs;
    }

    public void setBs(int bs) {
        this.bs = bs;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSampleInterval() {
        return this.sampleInterval;
    }

    public void setSampleInterval(long sampleInterval) {
        this.sampleInterval = sampleInterval;
    }

    public static class Report {
        public int size;
        public int writes;
        public long writeDuration;
        public int syncWrites;
        public long syncWriteDuration;
        public int reads;
        public long readDuration;

        public String toString() {
            return "Writes: \n  " + this.writes + " writes of size " + this.size + " written in " + (double)this.writeDuration / 1000.0 + " seconds.\n  " + this.getWriteRate() + " writes/second.\n  " + this.getWriteSizeRate() + " megs/second.\n\nSync Writes: \n  " + this.syncWrites + " writes of size " + this.size + " written in " + (double)this.syncWriteDuration / 1000.0 + " seconds.\n  " + this.getSyncWriteRate() + " writes/second.\n  " + this.getSyncWriteSizeRate() + " megs/second.\n\nReads: \n  " + this.reads + " reads of size " + this.size + " read in " + (double)this.readDuration / 1000.0 + " seconds.\n  " + this.getReadRate() + " writes/second.\n  " + this.getReadSizeRate() + " megs/second.\n\n";
        }

        private float getWriteSizeRate() {
            float rc = this.writes;
            rc *= (float)this.size;
            rc /= 1048576.0f;
            rc = (float)((double)rc / ((double)this.writeDuration / 1000.0));
            return rc;
        }

        private float getWriteRate() {
            float rc = this.writes;
            rc = (float)((double)rc / ((double)this.writeDuration / 1000.0));
            return rc;
        }

        private float getSyncWriteSizeRate() {
            float rc = this.syncWrites;
            rc *= (float)this.size;
            rc /= 1048576.0f;
            rc = (float)((double)rc / ((double)this.syncWriteDuration / 1000.0));
            return rc;
        }

        private float getSyncWriteRate() {
            float rc = this.syncWrites;
            rc = (float)((double)rc / ((double)this.syncWriteDuration / 1000.0));
            return rc;
        }

        private float getReadSizeRate() {
            float rc = this.reads;
            rc *= (float)this.size;
            rc /= 1048576.0f;
            rc = (float)((double)rc / ((double)this.readDuration / 1000.0));
            return rc;
        }

        private float getReadRate() {
            float rc = this.reads;
            rc = (float)((double)rc / ((double)this.readDuration / 1000.0));
            return rc;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getWrites() {
            return this.writes;
        }

        public void setWrites(int writes) {
            this.writes = writes;
        }

        public long getWriteDuration() {
            return this.writeDuration;
        }

        public void setWriteDuration(long writeDuration) {
            this.writeDuration = writeDuration;
        }

        public int getSyncWrites() {
            return this.syncWrites;
        }

        public void setSyncWrites(int syncWrites) {
            this.syncWrites = syncWrites;
        }

        public long getSyncWriteDuration() {
            return this.syncWriteDuration;
        }

        public void setSyncWriteDuration(long syncWriteDuration) {
            this.syncWriteDuration = syncWriteDuration;
        }

        public int getReads() {
            return this.reads;
        }

        public void setReads(int reads) {
            this.reads = reads;
        }

        public long getReadDuration() {
            return this.readDuration;
        }

        public void setReadDuration(long readDuration) {
            this.readDuration = readDuration;
        }
    }
}

