/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.pagination;

public class PaginationContext {
    private int start;
    private int count;
    private String sortOrder;
    private String sortBy;
    private int limit;
    private static final ThreadLocal<PaginationContext> PAGINATION_CONTEXT_THREAD_LOCAL = new ThreadLocal();

    private PaginationContext() {
    }

    public static PaginationContext init(int start, int count, String sortOrder, String sortBy, int limit) {
        PaginationContext paginationContext = new PaginationContext();
        paginationContext.setStart(start);
        paginationContext.setCount(count);
        paginationContext.setSortOrder(sortOrder);
        paginationContext.setSortBy(sortBy);
        paginationContext.setLimit(limit);
        PaginationContext.setPaginationContextThreadLocal(paginationContext);
        return paginationContext;
    }

    private static void setPaginationContextThreadLocal(PaginationContext paginationContext) {
        PAGINATION_CONTEXT_THREAD_LOCAL.set(paginationContext);
    }

    public static void destroy() {
        PAGINATION_CONTEXT_THREAD_LOCAL.remove();
    }

    public static PaginationContext getInstance() {
        return PAGINATION_CONTEXT_THREAD_LOCAL.get();
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

