/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class AuthorizationUtils {
    private static final Log log = LogFactory.getLog(AuthorizationUtils.class);

    public static boolean authorize(String resourcePath, String action) throws RegistryException {
        UserRealm userRealm = CurrentSession.getUserRealm();
        String userName = CurrentSession.getUser();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, action)) {
                return false;
            }
        }
        catch (UserStoreException e) {
            String msg = "Could not check authorization. \nCaused by " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        return true;
    }

    @Deprecated
    public static void setAnonAuthorization(String path, UserRealm userRealm) throws RegistryException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public static void clearAuthorizations(String resourcePath) throws RegistryException {
        UserRealm userRealm = CurrentSession.getUserRealm();
        try {
            userRealm.getAuthorizationManager().clearResourceAuthorizations(resourcePath);
        }
        catch (UserStoreException e) {
            String msg = "Could not clear authorizations. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
    }

    public static void copyAuthorizations(String sourcePath, String targetPath) throws RegistryException {
        UserRealm userRealm = CurrentSession.getUserRealm();
        try {
            if (sourcePath != null && targetPath != null) {
                AuthorizationUtils.clearAuthorizations(targetPath);
                if (RegistryUtils.getParentPath(sourcePath).equals(RegistryUtils.getParentPath(targetPath))) {
                    String[] actions;
                    for (String action : actions = new String[]{"http://www.wso2.org/projects/registry/actions/get", "http://www.wso2.org/projects/registry/actions/add", "http://www.wso2.org/projects/registry/actions/delete", "authorize"}) {
                        String[] roles = userRealm.getAuthorizationManager().getAllowedRolesForResource(sourcePath, action);
                        if (roles != null && roles.length > 0) {
                            for (String role : roles) {
                                if (userRealm.getAuthorizationManager().isRoleAuthorized(role, targetPath, action)) continue;
                                userRealm.getAuthorizationManager().authorizeRole(role, targetPath, action);
                            }
                        }
                        if ((roles = userRealm.getAuthorizationManager().getDeniedRolesForResource(sourcePath, action)) == null || roles.length <= 0) continue;
                        for (String role : roles) {
                            if (!userRealm.getAuthorizationManager().isRoleAuthorized(role, targetPath, action)) continue;
                            userRealm.getAuthorizationManager().denyRole(role, targetPath, action);
                        }
                    }
                }
            }
        }
        catch (UserStoreException e) {
            String msg = "Could not copy authorizations to the " + targetPath + ". \nCaused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
    }

    @Deprecated
    public static void denyAnonAuthorization(String path, UserRealm userRealm) throws RegistryException {
        throw new UnsupportedOperationException("This method is no longer supported");
    }

    public static void setRootAuthorizations(String rootPath, UserRealm userRealm) throws RegistryException {
        if (userRealm == null) {
            return;
        }
        try {
            RealmConfiguration realmConfig;
            AuthorizationManager accessControlAdmin = userRealm.getAuthorizationManager();
            try {
                realmConfig = userRealm.getRealmConfiguration();
            }
            catch (UserStoreException e) {
                String msg = "Failed to retrieve realm configuration.";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, e);
            }
            String adminRoleName = realmConfig.getAdminRoleName();
            String everyoneRoleName = realmConfig.getEveryOneRoleName();
            if (!accessControlAdmin.isRoleAuthorized(adminRoleName, rootPath, "http://www.wso2.org/projects/registry/actions/get")) {
                accessControlAdmin.authorizeRole(adminRoleName, rootPath, "http://www.wso2.org/projects/registry/actions/get");
            }
            if (!accessControlAdmin.isRoleAuthorized(adminRoleName, rootPath, "http://www.wso2.org/projects/registry/actions/add")) {
                accessControlAdmin.authorizeRole(adminRoleName, rootPath, "http://www.wso2.org/projects/registry/actions/add");
            }
            if (!accessControlAdmin.isRoleAuthorized(adminRoleName, rootPath, "http://www.wso2.org/projects/registry/actions/delete")) {
                accessControlAdmin.authorizeRole(adminRoleName, rootPath, "http://www.wso2.org/projects/registry/actions/delete");
            }
            if (!accessControlAdmin.isRoleAuthorized(adminRoleName, rootPath, "authorize")) {
                accessControlAdmin.authorizeRole(adminRoleName, rootPath, "authorize");
            }
            if (!accessControlAdmin.isRoleAuthorized(everyoneRoleName, rootPath, "http://www.wso2.org/projects/registry/actions/get")) {
                accessControlAdmin.authorizeRole(everyoneRoleName, rootPath, "http://www.wso2.org/projects/registry/actions/get");
            }
        }
        catch (UserStoreException e) {
            String msg = "Could not set authorizations for the root. \nCaused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg);
        }
    }

    @Deprecated
    public static void populateUserStore(UserRealm realm) throws UserStoreException {
        throw new UnsupportedOperationException("This method is no longer used");
    }

    public static String getAuthorizationPath(String resourcePath) {
        String preparedPath = resourcePath;
        if (resourcePath.indexOf(63) > 0) {
            preparedPath = resourcePath.split("\\?")[0];
        } else if (resourcePath.indexOf(";") > 0) {
            preparedPath = resourcePath.split("\\;")[0];
        }
        if (preparedPath.equals("/")) {
            return preparedPath;
        }
        if (!preparedPath.startsWith("/")) {
            preparedPath = "/" + preparedPath;
        }
        if (preparedPath.endsWith("/")) {
            preparedPath = preparedPath.substring(0, preparedPath.length() - 1);
        }
        return preparedPath;
    }

    public static void addAuthorizeRoleListener(int executionId, String path, String permission, String executeAction, String[] actions) {
        RegistryCoreServiceComponent.addAuthorizeRoleListener(executionId, path, permission, executeAction, actions);
    }

    public static void addAuthorizeRoleListener(int executionId, String path, String permission, String executeAction) {
        RegistryCoreServiceComponent.addAuthorizeRoleListener(executionId, path, permission, executeAction, null);
    }
}

