/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.apache.cxf.bus.osgi.CXFExtensionBundleListener;
import org.apache.cxf.bus.osgi.ManagedWorkQueueList;
import org.apache.cxf.bus.osgi.OSGIBusListener;
import org.apache.cxf.bus.osgi.WorkQueueSingleConfig;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class CXFActivator
implements BundleActivator {
    private List<Extension> extensions;
    private ManagedWorkQueueList workQueues = new ManagedWorkQueueList();
    private ServiceTracker configAdminTracker;
    private CXFExtensionBundleListener cxfBundleListener;
    private ServiceRegistration workQueueServiceRegistration;
    private ServiceRegistration wqSingleConfigRegistratin;

    public void start(BundleContext context) throws Exception {
        this.cxfBundleListener = new CXFExtensionBundleListener(context.getBundle().getBundleId());
        context.addBundleListener((BundleListener)this.cxfBundleListener);
        this.cxfBundleListener.registerExistingBundles(context);
        this.configAdminTracker = new ServiceTracker(context, ConfigurationAdmin.class.getName(), null);
        this.configAdminTracker.open();
        this.workQueues.setConfigAdminTracker(this.configAdminTracker);
        this.workQueueServiceRegistration = this.registerManagedServiceFactory(context, ManagedServiceFactory.class, this.workQueues, "org.apache.cxf.workqueues");
        WorkQueueSingleConfig wqSingleConfig = new WorkQueueSingleConfig(this.workQueues);
        this.wqSingleConfigRegistratin = this.registerManagedServiceFactory(context, ManagedService.class, wqSingleConfig, "org.apache.cxf.workqueue");
        this.extensions = new ArrayList<Extension>();
        this.extensions.add(this.createOsgiBusListenerExtension(context));
        this.extensions.add(CXFActivator.createManagedWorkQueueListExtension(this.workQueues));
        ExtensionRegistry.addExtensions(this.extensions);
    }

    private ServiceRegistration registerManagedServiceFactory(BundleContext context, Class<?> serviceClass, Object service, String servicePid) {
        Properties props = new Properties();
        props.put("service.pid", servicePid);
        return context.registerService(serviceClass.getName(), service, (Dictionary)props);
    }

    private Extension createOsgiBusListenerExtension(BundleContext context) {
        Extension busListener = new Extension(OSGIBusListener.class);
        busListener.setArgs(new Object[]{context});
        return busListener;
    }

    private static Extension createManagedWorkQueueListExtension(final ManagedWorkQueueList workQueues) {
        return new Extension(ManagedWorkQueueList.class){

            @Override
            public Object getLoadedObject() {
                return workQueues;
            }

            @Override
            public Extension cloneNoObject() {
                return this;
            }
        };
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this.cxfBundleListener);
        this.cxfBundleListener.shutdown();
        this.workQueues.shutDown();
        this.workQueueServiceRegistration.unregister();
        this.wqSingleConfigRegistratin.unregister();
        this.configAdminTracker.close();
        ExtensionRegistry.removeExtensions(this.extensions);
    }
}

