/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.consignor;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.SimpleTrustChecker;
import eu.unicore.samly2.validators.AssertionValidator;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;

public class ConsignorValidator
extends AssertionValidator {
    private X509Certificate issuerCert;

    public ConsignorValidator(X509Certificate issuerCertificate) {
        super(null, null, null, 180000L, new SimpleTrustChecker(issuerCertificate, true));
        this.issuerCert = issuerCertificate;
    }

    @Override
    public void validate(AssertionDocument assertionDoc) throws SAMLValidationException {
        super.validate(assertionDoc);
        AssertionType assertion = assertionDoc.getAssertion();
        if (assertion.getSubject().getNameID() == null || assertion.getSubject().getNameID().isNil()) {
            throw new SAMLValidationException("Assertion must have its Subject/NameID set");
        }
        String format = assertion.getSubject().getNameID().getFormat();
        if (!"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals(format)) {
            throw new SAMLValidationException("Assertion Subject must be of DN format");
        }
        String formatI = assertion.getIssuer().getFormat();
        if (!"urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals(formatI)) {
            throw new SAMLValidationException("Assertion Issuer must be of DN format");
        }
        X500Principal i2 = this.issuerCert.getSubjectX500Principal();
        if (!X500NameUtils.equal((X500Principal)i2, (String)assertion.getIssuer().getStringValue())) {
            throw new SAMLValidationException("Issuer of assertion is not equal to the expected one: " + X500NameUtils.getReadableForm((String)assertion.getIssuer().getStringValue()));
        }
    }
}

