/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.security.wsutil.client.SessionIDOutHandler;
import eu.unicore.security.wsutil.client.WSClientFactory;
import eu.unicore.util.Log;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import org.apache.cxf.clustering.FailoverFeature;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.clustering.FailoverTargetSelector;
import org.apache.cxf.clustering.RetryStrategy;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.log4j.Logger;

public class RetryFeature
extends FailoverFeature {
    private static final Logger log = Log.getLogger("unicore.client", RetryFeature.class);
    private final WSClientFactory factory;
    private boolean enabled = true;
    private boolean retryImmediately = false;
    private final Set<Class<? extends Throwable>> exceptionClasses = new HashSet<Class<? extends Throwable>>();
    private final Set<ExceptionChecker> exceptionCheckers = new HashSet<ExceptionChecker>();

    public RetryFeature(WSClientFactory factory) {
        this.factory = factory;
        this.setStrategy((FailoverStrategy)new IncreasingBackoffStrategy());
        this.setTargetSelector(new MyTargetSelector());
    }

    public Set<Class<? extends Throwable>> getRecoverableExceptions() {
        return this.exceptionClasses;
    }

    public Set<ExceptionChecker> getExceptionCheckers() {
        return this.exceptionCheckers;
    }

    public void setMaxRetries(int maxRetries) {
        this.getStrategy().setMaxNumberOfRetries(maxRetries);
    }

    public int getMaxRetries() {
        return this.getStrategy().getMaxNumberOfRetries();
    }

    public void setDelayBetweenRetries(long delay) {
        this.getStrategy().setDelayBetweenRetries(delay);
    }

    public long getDelayBetweenRetries() {
        long res = 0L;
        if (this.retryImmediately) {
            this.retryImmediately = false;
        } else {
            res = this.getStrategy().getDelayBetweenRetries();
        }
        if (log.isDebugEnabled()) {
            log.debug("Will retry " + (res > 0L ? "in " + res / 1000L + " sec." : "immediately."));
        }
        return res;
    }

    public void setRetryImmediately() {
        this.retryImmediately = true;
    }

    public RetryStrategy getStrategy() {
        return (RetryStrategy)super.getStrategy();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean requiresFailover(Throwable ex) {
        if (!this.enabled) {
            return false;
        }
        boolean retry = false;
        if (ex instanceof SocketTimeoutException) {
            return false;
        }
        for (Class<? extends Throwable> clazz : this.exceptionClasses) {
            if (!clazz.isAssignableFrom(ex.getClass())) continue;
            retry = true;
        }
        for (ExceptionChecker exceptionChecker : this.exceptionCheckers) {
            if (!exceptionChecker.requiresFailover(ex)) continue;
            retry = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Got " + (retry ? "" : "non-") + "recoverable exception " + ex.getClass().getName());
        }
        return retry;
    }

    public static class IncreasingBackoffStrategy
    extends RetryStrategy {
        private int counter = 0;
        private int factor = 1;
        private static Random rand = new Random();

        protected boolean stillTheSameAddress() {
            if (this.getMaxNumberOfRetries() == 0) {
                return true;
            }
            if (this.counter == 0) {
                this.factor = 1;
            }
            this.increaseFactor();
            if (++this.counter <= this.getMaxNumberOfRetries()) {
                return true;
            }
            this.counter = 0;
            return false;
        }

        protected void increaseFactor() {
            this.factor = 2 * this.factor;
        }

        public long getDelayBetweenRetries() {
            long base = super.getDelayBetweenRetries();
            if (base <= 0L) {
                return 0L;
            }
            int r = rand.nextInt((int)base / 10);
            return (long)this.factor * (base + (long)r);
        }
    }

    public static interface ExceptionChecker {
        public boolean requiresFailover(Throwable var1);
    }

    public class MyTargetSelector
    extends FailoverTargetSelector {
        protected long getDelayBetweenRetries() {
            return RetryFeature.this.getDelayBetweenRetries();
        }

        public Conduit selectConduit(Message message) {
            Conduit c = super.selectConduit(message);
            if (c != null && c instanceof HTTPConduit) {
                RetryFeature.this.factory.setupHTTPParams((HTTPConduit)c);
            }
            return c;
        }

        protected boolean requiresFailover(Exchange exchange) {
            Exception ex = this.getException(exchange);
            this.getLogger().log(Level.FINE, "CHECK_LAST_INVOKE_FAILED", new Object[]{ex != null});
            boolean failover = false;
            for (Throwable curr = ex; curr != null; curr = curr.getCause()) {
                int s;
                boolean isInvalidSession = false;
                if (curr.getMessage() != null && curr.getMessage().contains("432")) {
                    isInvalidSession = true;
                }
                if (curr instanceof HTTPException && (s = ((HTTPException)curr).getResponseCode()) == 432) {
                    isInvalidSession = true;
                }
                if (isInvalidSession) {
                    this.clearSessionID(exchange);
                    RetryFeature.this.setRetryImmediately();
                    if (log.isDebugEnabled()) {
                        log.debug("Received alert: No valid security session, retrying ... ");
                    }
                    return true;
                }
                failover = RetryFeature.this.requiresFailover(curr);
            }
            if (ex != null) {
                this.getLogger().log(Level.INFO, "CHECK_FAILURE_IN_TRANSPORT", new Object[]{ex, failover});
            }
            return failover;
        }

        protected Exception getException(Exchange exchange) {
            if (exchange.getInFaultMessage() != null) {
                return (Exception)exchange.getInFaultMessage().getContent(Exception.class);
            }
            if (exchange.getOutFaultMessage() != null) {
                return (Exception)exchange.getOutFaultMessage().getContent(Exception.class);
            }
            if (exchange.getInMessage() != null) {
                return (Exception)exchange.getInMessage().getContent(Exception.class);
            }
            if (exchange.getOutMessage() != null) {
                return (Exception)exchange.getOutMessage().getContent(Exception.class);
            }
            return null;
        }

        protected void clearSessionID(Exchange exchange) {
            SessionIDOutHandler.setSkip(true);
        }
    }
}

