/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.samlclient;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.security.wsutil.client.WSClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;

public abstract class AbstractSAMLClient {
    protected String address;
    protected NameID localIssuer = null;
    protected WSClientFactory factory;
    protected SamlTrustChecker trustChecker;
    protected transient X509CertChainValidator validator;

    protected AbstractSAMLClient(String address, IClientConfiguration secProv, SamlTrustChecker trustChecker) throws MalformedURLException {
        this(address, secProv, null, trustChecker);
    }

    protected NameID getLocalIssuer() {
        return this.localIssuer;
    }

    protected NameID generateIssuer(IClientConfiguration secCfg) {
        X509Certificate[] certificateC = null;
        if (secCfg.getCredential() != null) {
            certificateC = secCfg.getCredential().getCertificateChain();
        }
        if (certificateC == null || certificateC.length == 0) {
            return null;
        }
        return new NameID(certificateC[0].getSubjectX500Principal().getName(), "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
    }

    protected AbstractSAMLClient(String address, IClientConfiguration secCfg, NameID issuer, SamlTrustChecker trustChecker) throws MalformedURLException {
        this.trustChecker = trustChecker;
        this.validator = secCfg.getValidator();
        new URL(address);
        this.address = address;
        this.factory = new WSClientFactory(secCfg);
        this.localIssuer = this.generateIssuer(secCfg);
    }
}

