/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.db.event.manager.messaging.impl;

import java.util.Collections;
import java.util.List;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.db.event.manager.messaging.DBEventManagerException;
import org.apache.airavata.db.event.manager.messaging.DBEventManagerMessagingFactory;
import org.apache.airavata.db.event.manager.utils.DbEventManagerZkUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.model.dbevent.DBEventMessage;
import org.apache.airavata.model.dbevent.DBEventMessageContext;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.curator.framework.CuratorFramework;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBEventMessageHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DBEventMessageHandler.class);
    private CuratorFramework curatorClient;

    public DBEventMessageHandler() throws ApplicationSettingsException {
        this.startCuratorClient();
    }

    private void startCuratorClient() throws ApplicationSettingsException {
        this.curatorClient = DbEventManagerZkUtils.getCuratorClient();
        this.curatorClient.start();
    }

    public void onMessage(MessageContext messageContext) {
        log.info("Incoming DB event message. Message Id : " + messageContext.getMessageId());
        try {
            byte[] bytes = ThriftUtils.serializeThriftObject((TBase)messageContext.getEvent());
            DBEventMessage dbEventMessage = new DBEventMessage();
            ThriftUtils.createThriftFromBytes((byte[])bytes, (TBase)dbEventMessage);
            DBEventMessageContext dBEventMessageContext = dbEventMessage.getMessageContext();
            switch (dbEventMessage.getDbEventType()) {
                case SUBSCRIBER: {
                    log.info("Registering " + dBEventMessageContext.getSubscriber().getSubscriberService() + " subscriber for " + dbEventMessage.getPublisherService());
                    DbEventManagerZkUtils.createDBEventMgrZkNode(this.curatorClient, dbEventMessage.getPublisherService(), dBEventMessageContext.getSubscriber().getSubscriberService());
                    break;
                }
                case PUBLISHER: {
                    List<String> subscribers = DbEventManagerZkUtils.getSubscribersForPublisher(this.curatorClient, dbEventMessage.getPublisherService());
                    if (subscribers.isEmpty()) {
                        log.error("No Subscribers registered for the service");
                        throw new DBEventManagerException("No Subscribers registered for the service");
                    }
                    String routingKey = this.getRoutingKeyFromList(subscribers);
                    log.info("Publishing " + dbEventMessage.getPublisherService() + " db event to " + subscribers.toString());
                    MessageContext messageCtx = new MessageContext((TBase)dbEventMessage, MessageType.DB_EVENT, "", "");
                    messageCtx.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
                    DBEventManagerMessagingFactory.getDBEventPublisher().publish(messageCtx, routingKey);
                }
            }
            log.info("Sending ack. Message Delivery Tag : " + messageContext.getDeliveryTag());
            DBEventManagerMessagingFactory.getDBEventSubscriber().sendAck(messageContext.getDeliveryTag());
        }
        catch (Exception e) {
            log.error("Error processing message.", (Throwable)e);
        }
    }

    private String getRoutingKeyFromList(List<String> subscribers) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(subscribers);
        for (String subscriber : subscribers) {
            sb.append(subscriber).append(".");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

