/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import org.apache.lucene.search.QueryFilter;
import org.apache.lucene.search.RangeFilter;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryFilter;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.LuceneSearchEngineQueryFilter;
import org.compass.core.lucene.engine.query.LuceneSearchEngineBooleanQueryFilterBuilder;

public class LuceneSearchEngineQueryFilterBuilder
implements SearchEngineQueryFilterBuilder {
    public SearchEngineQueryFilter between(String resourcePropertyName, String low, String high, boolean includeLow, boolean includeHigh) {
        return new LuceneSearchEngineQueryFilter(new RangeFilter(resourcePropertyName, low, high, includeLow, includeHigh));
    }

    public SearchEngineQueryFilter lt(String resourcePropertyName, String value) {
        return this.between(resourcePropertyName, null, value, false, false);
    }

    public SearchEngineQueryFilter le(String resourcePropertyName, String value) {
        return this.between(resourcePropertyName, null, value, false, true);
    }

    public SearchEngineQueryFilter gt(String resourcePropertyName, String value) {
        return this.between(resourcePropertyName, value, null, false, false);
    }

    public SearchEngineQueryFilter ge(String resourcePropertyName, String value) {
        return this.between(resourcePropertyName, value, null, true, false);
    }

    public SearchEngineQueryFilter query(SearchEngineQuery query) {
        return new LuceneSearchEngineQueryFilter(new QueryFilter(((LuceneSearchEngineQuery)query).getQuery()));
    }

    public SearchEngineQueryFilterBuilder.SearchEngineBooleanQueryFilterBuilder bool() {
        return new LuceneSearchEngineBooleanQueryFilterBuilder();
    }
}

