/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.AbstractDirectoryStore;
import org.compass.core.lucene.engine.store.CopyFromHolder;

public class RAMDirectoryStore
extends AbstractDirectoryStore {
    public static final String PROTOCOL = "ram://";

    public Directory open(String subContext, String subIndex) throws SearchEngineException {
        return new RAMDirectory();
    }

    public CopyFromHolder beforeCopyFrom(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        try {
            String[] files;
            for (String file : files = dir.list()) {
                dir.deleteFile(file);
            }
        }
        catch (IOException e) {
            throw new SearchEngineException("Faield to delete ram directory before copy", e);
        }
        return new CopyFromHolder();
    }
}

