/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.DiscriminatorType;
import javax.persistence.EnumType;
import javax.persistence.InheritanceType;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.DiscriminatorMappingInfo;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldMappingInfo;
import org.apache.openjpa.jdbc.meta.MappingInfo;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.meta.SequenceMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.EnumValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.XMLPersistenceMetaDataParser;
import org.apache.openjpa.persistence.jdbc.AnnotationPersistenceMappingParser;
import org.apache.openjpa.persistence.jdbc.MappingTag;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.UserException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLPersistenceMappingParser
extends XMLPersistenceMetaDataParser {
    private static final Map<String, MappingTag> _elems = new HashMap<String, MappingTag>();
    private static final Localizer _loc;
    private String _override = null;
    private String _schema = null;
    private String _colTable = null;
    private String _secondaryTable = null;
    private List<Column> _cols = null;
    private List<Column> _joinCols = null;
    private List<Column> _supJoinCols = null;
    private boolean _lob = false;
    private TemporalType _temporal = null;
    private EnumSet<UniqueFlag> _unique = EnumSet.noneOf(UniqueFlag.class);
    private DiscriminatorType _discType;
    private Column _discCol;
    private int _resultIdx = 0;
    private final DBDictionary _dict;
    private Attributes _foreignKeyAttributes = null;
    private List<String> _columnNamesList = null;
    private String[] _columnNames = new String[0];
    private List<Column> _versionColumnsList = null;
    private final Map<Class<?>, ArrayList<DeferredEmbeddableOverrides>> _deferredMappings = new HashMap();

    public XMLPersistenceMappingParser(JDBCConfiguration conf) {
        super(conf);
        this._dict = conf.getDBDictionaryInstance();
    }

    @Override
    protected void reset() {
        super.reset();
        this.clearColumnInfo();
        this.clearClassInfo();
        this.clearSecondaryTableInfo();
        this._override = null;
        this._schema = null;
        this._resultIdx = 0;
    }

    @Override
    protected Object startSystemMappingElement(String name, Attributes attrs) throws SAXException {
        boolean ret;
        MappingTag tag = _elems.get(name);
        if (tag == null) {
            if ("schema".equals(name)) {
                return name;
            }
            return null;
        }
        switch (tag) {
            case TABLE_GEN: {
                ret = this.startTableGenerator(attrs);
                break;
            }
            case SQL_RESULT_SET_MAPPING: {
                ret = this.startSQLResultSetMapping(attrs);
                break;
            }
            case ENTITY_RESULT: {
                ret = this.startEntityResult(attrs);
                break;
            }
            case FIELD_RESULT: {
                ret = this.startFieldResult(attrs);
                break;
            }
            case COLUMN_RESULT: {
                ret = this.startColumnResult(attrs);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret ? tag : null;
    }

    @Override
    protected void endSystemMappingElement(String name) throws SAXException {
        MappingTag tag = _elems.get(name);
        if (tag == null) {
            if ("schema".equals(name)) {
                this._schema = this.currentText();
            }
            return;
        }
        switch (tag) {
            case SQL_RESULT_SET_MAPPING: {
                this.endSQLResultSetMapping();
                break;
            }
            case ENTITY_RESULT: {
                this.endEntityResult();
            }
        }
    }

    @Override
    protected Object startClassMappingElement(String name, Attributes attrs) throws SAXException {
        boolean ret;
        MappingTag tag = _elems.get(name);
        if (tag == null) {
            return null;
        }
        switch (tag) {
            case TABLE: {
                ret = this.startTable(attrs);
                break;
            }
            case SECONDARY_TABLE: {
                ret = this.startSecondaryTable(attrs);
                break;
            }
            case DISCRIM_COL: {
                this.parseDiscriminatorColumn(attrs);
                this._discCol = this.parseColumn(attrs);
                ret = true;
                break;
            }
            case DISCRIM_VAL: {
                ret = true;
                break;
            }
            case INHERITANCE: {
                ret = this.startInheritance(attrs);
                break;
            }
            case ASSOC_OVERRIDE: 
            case ATTR_OVERRIDE: {
                ret = this.startAttributeOverride(attrs);
                break;
            }
            case PK_JOIN_COL: {
                ret = this.startPrimaryKeyJoinColumn(attrs);
                break;
            }
            case COL: {
                ret = this.startColumn(attrs);
                break;
            }
            case COLS: {
                ret = true;
                break;
            }
            case JOIN_COL: {
                ret = this.startJoinColumn(attrs);
                break;
            }
            case JOIN_TABLE: {
                ret = this.startJoinTable(attrs);
                break;
            }
            case TABLE_GEN: {
                ret = this.startTableGenerator(attrs);
                break;
            }
            case UNIQUE: {
                ret = this.startUniqueConstraint(attrs);
                break;
            }
            case NAME: {
                ret = true;
                break;
            }
            case TEMPORAL: 
            case ENUMERATED: 
            case MAP_KEY_ENUMERATED: 
            case MAP_KEY_TEMPORAL: {
                ret = true;
                break;
            }
            case SQL_RESULT_SET_MAPPING: {
                ret = this.startSQLResultSetMapping(attrs);
                break;
            }
            case ENTITY_RESULT: {
                ret = this.startEntityResult(attrs);
                break;
            }
            case FIELD_RESULT: {
                ret = this.startFieldResult(attrs);
                break;
            }
            case COLUMN_RESULT: {
                ret = this.startColumnResult(attrs);
                break;
            }
            case COLUMN_NAME: {
                ret = true;
                break;
            }
            case COLLECTION_TABLE: {
                ret = this.startCollectionTable(attrs);
                break;
            }
            case MAP_KEY_COL: {
                ret = this.startMapKeyColumn(attrs);
                break;
            }
            case MAP_KEY_JOIN_COL: {
                ret = this.startMapKeyJoinColumn(attrs);
                break;
            }
            case DATASTORE_ID_COL: {
                ret = this.startDatastoreIdCol(attrs);
                break;
            }
            case INDEX: {
                ret = this.startIndex(attrs);
                break;
            }
            case FK: {
                ret = this.startForeignKey(attrs);
                break;
            }
            case FK_COL_NAMES: {
                ret = this.startFKColumnNames(attrs);
                break;
            }
            case FK_COL_NAME: {
                ret = true;
                break;
            }
            case VERSION_COLS: {
                ret = this.startVersionColumns(attrs);
                break;
            }
            case VERSION_COL: {
                ret = this.startVersionColumn(attrs);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret ? tag : null;
    }

    private boolean endName() {
        Object current;
        String name = this.currentText();
        if (StringUtils.isNotEmpty(name) && (current = this.currentElement()) instanceof Unique) {
            Unique unq = (Unique)current;
            unq.setIdentifier(DBIdentifier.newConstraint(name, this.delimit()));
        }
        return true;
    }

    @Override
    protected void endClassMappingElement(String name) throws SAXException {
        MappingTag tag = _elems.get(name);
        if (tag == null) {
            return;
        }
        switch (tag) {
            case SECONDARY_TABLE: {
                this.endSecondaryTable();
                break;
            }
            case DISCRIM_VAL: {
                this.endDiscriminatorValue();
                break;
            }
            case ASSOC_OVERRIDE: 
            case ATTR_OVERRIDE: {
                this.endAttributeOverride();
                break;
            }
            case JOIN_TABLE: {
                this.endJoinTable();
                break;
            }
            case TEMPORAL: {
                this.endTemporal();
                break;
            }
            case MAP_KEY_TEMPORAL: {
                this.endMapKeyTemporal();
                break;
            }
            case ENUMERATED: {
                this.endEnumerated();
                break;
            }
            case MAP_KEY_ENUMERATED: {
                this.endMapKeyEnumerated();
                break;
            }
            case SQL_RESULT_SET_MAPPING: {
                this.endSQLResultSetMapping();
                break;
            }
            case ENTITY_RESULT: {
                this.endEntityResult();
                break;
            }
            case UNIQUE: {
                this.endUniqueConstraint();
                break;
            }
            case COLUMN_NAME: {
                this.endColumnName();
                break;
            }
            case TABLE_GEN: {
                this.endTableGenerator();
                break;
            }
            case NAME: {
                this.endName();
                break;
            }
            case FK: {
                this.endForeignKey();
                break;
            }
            case FK_COL_NAMES: {
                this.endFKColumnNames();
                break;
            }
            case FK_COL_NAME: {
                this.endFKColumnName();
                break;
            }
            case VERSION_COLS: {
                this.endVersionColumns();
            }
        }
    }

    @Override
    protected void startClassMapping(ClassMetaData meta, boolean mappedSuper, Attributes attrs) throws SAXException {
        if (mappedSuper) {
            ((ClassMapping)meta).getMappingInfo().setStrategy("none");
        }
    }

    @Override
    protected void endClassMapping(ClassMetaData meta) throws SAXException {
        ClassMapping cm = (ClassMapping)meta;
        if (this._schema != null) {
            cm.getMappingInfo().setSchemaIdentifier(DBIdentifier.newSchema(this._schema, this.delimit()));
        }
        if (this._supJoinCols != null) {
            cm.getMappingInfo().setColumns(this._supJoinCols);
        }
        if (this._discCol != null) {
            DiscriminatorMappingInfo dinfo = cm.getDiscriminator().getMappingInfo();
            switch (this._discType) {
                case CHAR: {
                    this._discCol.setJavaType(2);
                    cm.getDiscriminator().setJavaType(2);
                    break;
                }
                case INTEGER: {
                    this._discCol.setJavaType(5);
                    cm.getDiscriminator().setJavaType(5);
                    break;
                }
                default: {
                    this._discCol.setJavaType(9);
                    cm.getDiscriminator().setJavaType(9);
                }
            }
            dinfo.setColumns(Arrays.asList(this._discCol));
        }
        this.clearClassInfo();
    }

    private void clearClassInfo() {
        this._supJoinCols = null;
        this._discCol = null;
        this._discType = null;
    }

    private boolean startSecondaryTable(Attributes attrs) throws SAXException {
        this._secondaryTable = this.toTableIdentifier(attrs.getValue("schema"), attrs.getValue("name")).getName();
        ((ClassMapping)this.currentElement()).getMappingInfo().addSecondaryTable(DBIdentifier.newTable(this._secondaryTable));
        return true;
    }

    private void endSecondaryTable() {
        ClassMapping cm = (ClassMapping)this.currentElement();
        ClassMappingInfo info = cm.getMappingInfo();
        info.setSecondaryTableJoinColumns(DBIdentifier.newTable(this._secondaryTable, this.delimit()), this._joinCols);
        this.clearSecondaryTableInfo();
    }

    private void clearSecondaryTableInfo() {
        this._joinCols = null;
        this._secondaryTable = null;
    }

    private boolean startTableGenerator(Attributes attrs) {
        Object cur;
        String name = attrs.getValue("name");
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace(_loc.get("parse-gen", name));
        }
        if (this.getRepository().getCachedSequenceMetaData(name) != null && log.isWarnEnabled()) {
            log.warn(_loc.get("override-gen", name));
        }
        SequenceMapping seq = (SequenceMapping)this.getRepository().addSequenceMetaData(name);
        seq.setSequencePlugin("value-table");
        seq.setTableIdentifier(this.toTableIdentifier(attrs.getValue("schema"), attrs.getValue("table")));
        seq.setPrimaryKeyColumnIdentifier(DBIdentifier.newColumn(attrs.getValue("pk-column-name"), this.delimit()));
        seq.setSequenceColumnIdentifier(DBIdentifier.newColumn(attrs.getValue("value-column-name"), this.delimit()));
        seq.setPrimaryKeyValue(attrs.getValue("pk-column-value"));
        String val = attrs.getValue("initial-value");
        if (val != null) {
            seq.setInitialValue(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("allocation-size")) != null) {
            seq.setAllocate(Integer.parseInt(val));
        }
        Class<?> scope = (cur = this.currentElement()) instanceof ClassMetaData ? ((ClassMetaData)cur).getDescribedType() : null;
        seq.setSource(this.getSourceFile(), scope, 2);
        Locator locator = this.getLocation().getLocator();
        if (locator != null) {
            seq.setLineNumber(locator.getLineNumber());
            seq.setColNumber(locator.getColumnNumber());
        }
        this.pushElement(seq);
        return true;
    }

    private void endTableGenerator() {
        this.popElement();
    }

    private boolean startInheritance(Attributes attrs) {
        String val = attrs.getValue("strategy");
        if (val == null) {
            return true;
        }
        ClassMapping cm = (ClassMapping)this.currentElement();
        ClassMappingInfo info = cm.getMappingInfo();
        switch (Enum.valueOf(InheritanceType.class, val)) {
            case SINGLE_TABLE: {
                info.setHierarchyStrategy("flat");
                break;
            }
            case JOINED: {
                info.setHierarchyStrategy("vertical");
                break;
            }
            case TABLE_PER_CLASS: {
                info.setHierarchyStrategy("full");
            }
        }
        return true;
    }

    private void endDiscriminatorValue() {
        String val = this.currentText();
        if (StringUtils.isEmpty(val)) {
            return;
        }
        ClassMapping cm = (ClassMapping)this.currentElement();
        cm.getDiscriminator().getMappingInfo().setValue(val);
        if (Modifier.isAbstract(cm.getDescribedType().getModifiers()) && this.getLog().isInfoEnabled()) {
            this.getLog().info(_loc.get("discriminator-on-abstract-class", cm.getDescribedType().getName()));
        }
    }

    private void endTemporal() {
        String temp = this.currentText();
        if (!StringUtils.isEmpty(temp)) {
            this._temporal = Enum.valueOf(TemporalType.class, temp);
        }
    }

    private void endMapKeyTemporal() {
        FieldMapping fm;
        List<Column> cols;
        String temp = this.currentText();
        TemporalType _mapKeyTemporal = null;
        if (!StringUtils.isEmpty(temp)) {
            _mapKeyTemporal = Enum.valueOf(TemporalType.class, temp);
        }
        if ((cols = (fm = (FieldMapping)this.currentElement()).getKeyMapping().getValueInfo().getColumns()).isEmpty()) {
            cols = Arrays.asList(new Column());
            fm.getKeyMapping().getValueInfo().setColumns(cols);
        }
        Column col = cols.get(0);
        switch (_mapKeyTemporal) {
            case DATE: {
                col.setType(91);
                break;
            }
            case TIME: {
                col.setType(92);
                break;
            }
            case TIMESTAMP: {
                col.setType(93);
            }
        }
    }

    private void endEnumerated() {
        String text = this.currentText();
        if (StringUtils.isEmpty(text)) {
            return;
        }
        EnumType type = Enum.valueOf(EnumType.class, text);
        FieldMapping fm = (FieldMapping)this.currentElement();
        String strat = EnumValueHandler.class.getName() + "(StoreOrdinal=" + String.valueOf(type == EnumType.ORDINAL) + ")";
        if (fm.isElementCollection()) {
            fm.getElementMapping().getValueInfo().setStrategy(strat);
        } else {
            fm.getValueInfo().setStrategy(strat);
        }
    }

    private void endMapKeyEnumerated() {
        String text = this.currentText();
        if (StringUtils.isEmpty(text)) {
            return;
        }
        EnumType type = Enum.valueOf(EnumType.class, text);
        FieldMapping fm = (FieldMapping)this.currentElement();
        String strat = EnumValueHandler.class.getName() + "(StoreOrdinal=" + String.valueOf(type == EnumType.ORDINAL) + ")";
        fm.getKeyMapping().getValueInfo().setStrategy(strat);
    }

    @Override
    protected boolean startLob(Attributes attrs) throws SAXException {
        if (super.startLob(attrs)) {
            this._lob = true;
            return true;
        }
        return false;
    }

    @Override
    protected void startFieldMapping(FieldMetaData field, Attributes attrs) throws SAXException {
        super.startFieldMapping(field, attrs);
        if (this.getAnnotationParser() != null) {
            FieldMapping fm = (FieldMapping)field;
            fm.getMappingInfo().clear();
            fm.getValueInfo().clear();
            fm.getElementMapping().getValueInfo().clear();
            fm.getKeyMapping().getValueInfo().clear();
        }
    }

    @Override
    protected void endFieldMapping(FieldMetaData field) throws SAXException {
        FieldMapping fm = (FieldMapping)field;
        if (this._lob || this._temporal != null) {
            Class type;
            int typeCode = fm.isElementCollection() ? fm.getElement().getDeclaredTypeCode() : fm.getDeclaredTypeCode();
            Class clazz = type = fm.isElementCollection() ? fm.getElement().getDeclaredType() : fm.getDeclaredType();
            if (this._cols == null) {
                this._cols = new ArrayList<Column>(1);
                this._cols.add(new Column());
            }
            for (Column col : this._cols) {
                if (this._lob && (typeCode == 9 || type == char[].class || type == Character[].class)) {
                    col.setSize(-1);
                    col.setType(2005);
                    continue;
                }
                if (this._lob) {
                    col.setType(2004);
                    continue;
                }
                switch (this._temporal) {
                    case DATE: {
                        col.setType(91);
                        break;
                    }
                    case TIME: {
                        col.setType(92);
                        break;
                    }
                    case TIMESTAMP: {
                        col.setType(93);
                    }
                }
            }
        }
        if (this._cols != null) {
            switch (fm.getDeclaredTypeCode()) {
                case 11: {
                    Class type = fm.getDeclaredType();
                    if (type == byte[].class || type == Byte[].class || type == char[].class || type == Character[].class) {
                        fm.getValueInfo().setColumns(this._cols);
                        break;
                    }
                }
                case 12: {
                    if (!fm.getValue().isSerialized()) {
                        fm.getElementMapping().getValueInfo().setColumns(this._cols);
                        break;
                    }
                    fm.getValueInfo().setColumns(this._cols);
                    break;
                }
                case 13: {
                    fm.getElementMapping().getValueInfo().setColumns(this._cols);
                    break;
                }
                default: {
                    fm.getValueInfo().setColumns(this._cols);
                }
            }
            if (this._colTable != null) {
                fm.getMappingInfo().setTableIdentifier(DBIdentifier.newTable(this._colTable, this.delimit()));
            }
            this.setUnique(fm);
        }
        this.clearColumnInfo();
    }

    private void setUnique(FieldMapping fm) {
        this.setUnique(fm, this._unique);
    }

    private void setUnique(FieldMapping fm, EnumSet<UniqueFlag> unique) {
        if (unique.size() == 2) {
            this.getLog().warn(_loc.get("inconsist-col-attrs", fm));
        } else if (unique.contains((Object)UniqueFlag.TRUE)) {
            fm.getValueInfo().setUnique(new Unique());
        }
    }

    private void clearColumnInfo() {
        this._cols = null;
        this._joinCols = null;
        this._colTable = null;
        this._lob = false;
        this._temporal = null;
        this._unique.clear();
    }

    private boolean startAttributeOverride(Attributes attr) {
        this._override = attr.getValue("name");
        return true;
    }

    private void endAttributeOverride() throws SAXException {
        Object elem = this.currentElement();
        FieldMapping fm = null;
        if (elem instanceof ClassMapping) {
            fm = this.getAttributeOverride((ClassMapping)elem);
        } else {
            FieldMapping basefm = (FieldMapping)elem;
            fm = this.getAttributeOverrideForEmbeddable(basefm, this._override, false);
            if (fm == null) {
                DeferredEmbeddableOverrides dfm = this.getDeferredFieldMappingInfo(AnnotationPersistenceMappingParser.getEmbeddedClassType(basefm, this._override), basefm, this._override, true);
                dfm._defCols = this._cols;
                dfm._defTable = DBIdentifier.newTable(this._colTable, this.delimit());
                dfm._attrName = this._override;
                dfm._unique = this._unique;
            }
        }
        if (fm != null && this._cols != null) {
            fm.getValueInfo().setColumns(this._cols);
            if (this._colTable != null) {
                fm.getMappingInfo().setTableIdentifier(DBIdentifier.newTable(this._colTable, this.delimit()));
            }
            this.setUnique(fm);
        }
        this.clearColumnInfo();
        this._override = null;
    }

    private FieldMapping getAttributeOverride(ClassMapping cm) {
        FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(this._override);
        if (sup == null) {
            sup = (FieldMapping)cm.addDefinedSuperclassField(this._override, Object.class, Object.class);
        }
        return sup;
    }

    private FieldMapping getAttributeOverrideForEmbeddable(FieldMapping fm, String attrName, boolean mustExist) throws SAXException {
        return AnnotationPersistenceMappingParser.getEmbeddedFieldMapping(fm, attrName, mustExist);
    }

    private boolean startTable(Attributes attrs) throws SAXException {
        ClassMapping mapping = (ClassMapping)this.currentElement();
        if (mapping.isAbstract()) {
            throw new UserException(_loc.get("table-not-allowed", mapping));
        }
        DBIdentifier table = this.toTableIdentifier(attrs.getValue("schema"), attrs.getValue("name"));
        if (!DBIdentifier.isNull(table)) {
            mapping.getMappingInfo().setTableIdentifier(table);
        }
        return true;
    }

    private boolean startJoinTable(Attributes attrs) throws SAXException {
        DBIdentifier sTable = this.toTableIdentifier(attrs.getValue("schema"), attrs.getValue("name"));
        if (!DBIdentifier.isNull(sTable)) {
            Object elem = this.currentElement();
            FieldMapping fm = null;
            if (elem instanceof FieldMapping) {
                FieldMapping basefm;
                fm = (FieldMapping)elem;
                if (this._override != null && (fm = this.getAttributeOverrideForEmbeddable(basefm = (FieldMapping)elem, this._override, false)) == null) {
                    DeferredEmbeddableOverrides dfm = this.getDeferredFieldMappingInfo(AnnotationPersistenceMappingParser.getEmbeddedClassType(basefm, this._override), basefm, this._override, true);
                    dfm._defTable = sTable.clone();
                    dfm._attrName = this._override;
                }
            } else if (elem instanceof ClassMapping) {
                ClassMapping cm = (ClassMapping)elem;
                fm = this.getAttributeOverride(cm);
            }
            if (fm != null) {
                fm.getMappingInfo().setTableIdentifier(sTable);
            }
        }
        return true;
    }

    private void endJoinTable() throws SAXException {
        Object elem = this.currentElement();
        FieldMapping fm = null;
        if (elem instanceof FieldMapping) {
            FieldMapping basefm;
            fm = (FieldMapping)elem;
            if (this._override != null && (fm = this.getAttributeOverrideForEmbeddable(basefm = (FieldMapping)elem, this._override, false)) == null) {
                DeferredEmbeddableOverrides dfm = this.getDeferredFieldMappingInfo(AnnotationPersistenceMappingParser.getEmbeddedClassType(basefm, this._override), basefm, this._override, true);
                dfm._defCols = this._cols;
                dfm._defElemJoinCols = this._joinCols;
                dfm._attrName = this._override;
            }
        } else if (elem instanceof ClassMapping) {
            ClassMapping cm = (ClassMapping)elem;
            fm = this.getAttributeOverride(cm);
        }
        if (fm != null) {
            if (this._joinCols != null) {
                fm.getMappingInfo().setColumns(this._joinCols);
            }
            if (this._cols != null) {
                fm.getElementMapping().getValueInfo().setColumns(this._cols);
            }
        }
        this.clearColumnInfo();
    }

    private boolean startPrimaryKeyJoinColumn(Attributes attrs) throws SAXException {
        Column col = this.parseColumn(attrs);
        col.setFlag(128, true);
        if (this.currentElement() instanceof FieldMapping) {
            if (this._cols == null) {
                this._cols = new ArrayList<Column>(3);
            }
            this._cols.add(col);
        } else if (this.currentParent() == MappingTag.SECONDARY_TABLE) {
            if (this._joinCols == null) {
                this._joinCols = new ArrayList<Column>(3);
            }
            this._joinCols.add(col);
        } else {
            if (this._supJoinCols == null) {
                this._supJoinCols = new ArrayList<Column>(3);
            }
            this._supJoinCols.add(col);
        }
        return true;
    }

    private boolean startJoinColumn(Attributes attrs) throws SAXException {
        Object currentParent = this.currentParent();
        if (currentParent == MappingTag.COLLECTION_TABLE) {
            FieldMapping fm = (FieldMapping)this.peekElement();
            Column col = this.parseColumn(attrs);
            List<Column> colList = fm.getMappingInfo().getColumns();
            if (colList.isEmpty()) {
                colList = new ArrayList<Column>();
                fm.getMappingInfo().setColumns(colList);
            }
            colList.add(col);
            fm.getMappingInfo().setColumns(colList);
            return true;
        }
        if (currentParent != MappingTag.JOIN_TABLE) {
            return this.startColumn(attrs);
        }
        if (this._joinCols == null) {
            this._joinCols = new ArrayList<Column>(3);
        }
        this._joinCols.add(this.parseColumn(attrs));
        return true;
    }

    private boolean startColumn(Attributes attrs) throws SAXException {
        FieldMapping fm;
        Column col = this.parseColumn(attrs);
        Object obj = this.peekElement();
        if (obj instanceof FieldMapping && (fm = (FieldMapping)obj).isElementCollection() && !fm.getElementMapping().isEmbedded()) {
            List<Column> list = fm.getElementMapping().getValueInfo().getColumns();
            if (list.size() == 0) {
                list = new ArrayList<Column>();
                fm.getElementMapping().getValueInfo().setColumns(list);
            }
            list.add(col);
            return true;
        }
        if (this._cols == null) {
            this._cols = new ArrayList<Column>(3);
        }
        this._cols.add(col);
        return true;
    }

    private boolean startMapKeyColumn(Attributes attrs) throws SAXException {
        FieldMapping fm = (FieldMapping)this.peekElement();
        Column col = this.parseColumn(attrs);
        ValueMappingInfo info = fm.getKeyMapping().getValueInfo();
        ArrayList<Column> cols = new ArrayList<Column>();
        cols.add(col);
        info.setColumns(cols);
        return true;
    }

    private boolean startMapKeyJoinColumn(Attributes attrs) throws SAXException {
        boolean retVal = this.startMapKeyColumn(attrs);
        FieldMapping fm = (FieldMapping)this.peekElement();
        ValueMappingInfo info = fm.getKeyMapping().getValueInfo();
        List<Column> cols = info.getColumns();
        Column col = cols.get(0);
        if (DBIdentifier.isNull(col.getIdentifier())) {
            col.setIdentifier(DBIdentifier.newColumn(fm.getName() + "_" + "KEY", this.delimit()));
        }
        return retVal;
    }

    private Column parseColumn(Attributes attrs) throws SAXException {
        Column col = new Column();
        String val = attrs.getValue("name");
        if (val != null) {
            col.setIdentifier(DBIdentifier.newColumn(val, this.delimit()));
        }
        if ((val = attrs.getValue("referenced-column-name")) != null) {
            col.setTargetIdentifier(DBIdentifier.newColumn(val, this.delimit()));
        }
        if ((val = attrs.getValue("column-definition")) != null) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition(val));
        }
        if ((val = attrs.getValue("precision")) != null) {
            col.setSize(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("length")) != null) {
            col.setSize(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("scale")) != null) {
            col.setDecimalDigits(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("nullable")) != null) {
            col.setNotNull("false".equals(val));
        }
        if ((val = attrs.getValue("insertable")) != null) {
            col.setFlag(2, "false".equals(val));
        }
        if ((val = attrs.getValue("updatable")) != null) {
            col.setFlag(4, "false".equals(val));
        }
        if ((val = attrs.getValue("unique")) != null) {
            this._unique.add(Enum.valueOf(UniqueFlag.class, val.toUpperCase()));
        }
        if ((val = attrs.getValue("table")) != null) {
            if (this._colTable != null && !this._colTable.equals(val)) {
                throw this.getException(_loc.get("second-inconsist", this.currentElement()));
            }
            this._colTable = val;
        }
        return col;
    }

    private boolean startCollectionTable(Attributes attrs) throws SAXException {
        FieldMapping fm = (FieldMapping)this.peekElement();
        FieldMappingInfo info = fm.getMappingInfo();
        DBIdentifier ctbl = this.parseCollectionTable(attrs);
        info.setTableIdentifier(ctbl);
        return true;
    }

    private DBIdentifier parseCollectionTable(Attributes attrs) {
        String tVal = attrs.getValue("name");
        String sVal = attrs.getValue("schema");
        return this.toTableIdentifier(sVal, tVal);
    }

    private DBIdentifier toTableIdentifier(String schema, String table) {
        DBIdentifier sName = DBIdentifier.newSchema(schema, this.delimit());
        DBIdentifier tName = DBIdentifier.newTable(table, this.delimit());
        if (DBIdentifier.isEmpty(tName) || DBIdentifier.isEmpty(sName)) {
            return tName;
        }
        return QualifiedDBIdentifier.newPath(sName, tName);
    }

    private boolean startSQLResultSetMapping(Attributes attrs) {
        MappingRepository repos;
        QueryResultMapping result;
        String name = attrs.getValue("name");
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace(_loc.get("parse-sqlrsmapping", name));
        }
        if ((result = (repos = (MappingRepository)this.getRepository()).getCachedQueryResultMapping(null, name)) != null && log.isWarnEnabled()) {
            log.warn(_loc.get("override-sqlrsmapping", name, this.currentLocation()));
        }
        result = repos.addQueryResultMapping(null, name);
        result.setListingIndex(this._resultIdx++);
        this.addComments(result);
        Object cur = this.currentElement();
        Class<?> scope = cur instanceof ClassMetaData ? ((ClassMetaData)cur).getDescribedType() : null;
        result.setSource(this.getSourceFile(), scope, 2);
        Locator locator = this.getLocation().getLocator();
        if (locator != null) {
            result.setLineNumber(locator.getLineNumber());
            result.setColNumber(locator.getColumnNumber());
        }
        this.pushElement(result);
        return true;
    }

    private void endSQLResultSetMapping() throws SAXException {
        this.popElement();
    }

    private boolean startEntityResult(Attributes attrs) throws SAXException {
        Class<?> entityClass = this.classForName(attrs.getValue("entity-class"));
        String discriminator = DBIdentifier.newColumn(attrs.getValue("discriminator-column"), this.delimit()).getName();
        QueryResultMapping parent = (QueryResultMapping)this.currentElement();
        QueryResultMapping.PCResult result = parent.addPCResult(entityClass);
        if (!StringUtils.isEmpty(discriminator)) {
            result.addMapping("<discriminator>", discriminator);
        }
        this.pushElement(result);
        return true;
    }

    private void endEntityResult() throws SAXException {
        this.popElement();
    }

    private boolean startFieldResult(Attributes attrs) throws SAXException {
        String fieldName = attrs.getValue("name");
        String columnName = DBIdentifier.newColumn(attrs.getValue("column"), this.delimit()).getName();
        QueryResultMapping.PCResult parent = (QueryResultMapping.PCResult)this.currentElement();
        parent.addMapping(fieldName, columnName);
        return true;
    }

    private boolean startColumnResult(Attributes attrs) throws SAXException {
        QueryResultMapping parent = (QueryResultMapping)this.currentElement();
        parent.addColumnResult(attrs.getValue("name"));
        return true;
    }

    private boolean startUniqueConstraint(Attributes attrs) throws SAXException {
        Unique unique = new Unique();
        DBIdentifier name = DBIdentifier.newConstraint(attrs.getValue("name"), this.delimit());
        if (!DBIdentifier.isEmpty(name)) {
            unique.setIdentifier(name);
        }
        this.pushElement(unique);
        return true;
    }

    private void endUniqueConstraint() {
        Unique unique = (Unique)this.popElement();
        Object ctx = this.currentElement();
        DBIdentifier tableName = DBIdentifier.newTable("?");
        if (ctx instanceof ClassMapping) {
            ClassMappingInfo info = ((ClassMapping)ctx).getMappingInfo();
            tableName = this._secondaryTable == null ? info.getTableIdentifier() : DBIdentifier.newTable(this._secondaryTable, this.delimit());
            info.addUnique(tableName, unique);
        } else if (ctx instanceof FieldMapping) {
            FieldMappingInfo info = ((FieldMapping)ctx).getMappingInfo();
            info.addJoinTableUnique(unique);
        } else if (ctx instanceof SequenceMapping) {
            SequenceMapping seq = (SequenceMapping)ctx;
            unique.setTableIdentifier(seq.getTableIdentifier());
            Column[] uniqueColumns = unique.getColumns();
            DBIdentifier[] columnNames = new DBIdentifier[uniqueColumns.length];
            int i = 0;
            for (Column uniqueColumn : uniqueColumns) {
                columnNames[i++] = uniqueColumn.getIdentifier().clone();
            }
            seq.setUniqueColumnsIdentifier(columnNames);
            if (!DBIdentifier.isEmpty(unique.getIdentifier())) {
                seq.setUniqueConstraintIdentifier(unique.getIdentifier());
            }
        } else {
            throw new InternalException();
        }
    }

    private boolean endColumnName() {
        Object current = this.currentElement();
        if (current instanceof Unique) {
            Unique unique = (Unique)current;
            Column column = new Column();
            column.setIdentifier(DBIdentifier.newColumn(this.currentText(), this.delimit()));
            unique.addColumn(column);
            return true;
        }
        return false;
    }

    private void parseDiscriminatorColumn(Attributes attrs) {
        String val = attrs.getValue("discriminator-type");
        this._discType = val != null ? Enum.valueOf(DiscriminatorType.class, val) : DiscriminatorType.STRING;
    }

    @Override
    protected boolean startOrderColumn(Attributes attrs) throws SAXException {
        Column col = this.parseOrderColumn(attrs);
        Object obj = this.peekElement();
        if (obj instanceof FieldMapping) {
            FieldMapping fm = (FieldMapping)obj;
            fm.getMappingInfo().setOrderColumn(col);
        }
        return true;
    }

    private Column parseOrderColumn(Attributes attrs) throws SAXException {
        Column col = new Column();
        String val = attrs.getValue("name");
        if (val != null) {
            col.setIdentifier(DBIdentifier.newColumn(val, this.delimit()));
        }
        if ((val = attrs.getValue("column-definition")) != null) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition(val));
        }
        if ((val = attrs.getValue("precision")) != null) {
            col.setSize(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("length")) != null) {
            col.setSize(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("scale")) != null) {
            col.setDecimalDigits(Integer.parseInt(val));
        }
        if ((val = attrs.getValue("nullable")) != null) {
            col.setNotNull("false".equals(val));
        }
        if ((val = attrs.getValue("insertable")) != null) {
            col.setFlag(2, "false".equals(val));
        }
        if ((val = attrs.getValue("updatable")) != null) {
            col.setFlag(4, "false".equals(val));
        }
        return col;
    }

    @Override
    protected void applyDeferredEmbeddableOverrides(Class<?> cls) throws SAXException {
        ArrayList<DeferredEmbeddableOverrides> defMappings = this._deferredMappings.get(cls);
        if (defMappings == null) {
            return;
        }
        for (DeferredEmbeddableOverrides defMap : defMappings) {
            FieldMapping fm = defMap._fm;
            if (defMap == null) {
                return;
            }
            fm = this.getAttributeOverrideForEmbeddable(fm, defMap._attrName, true);
            if (defMap._defCols != null) {
                fm.getValueInfo().setColumns(defMap._defCols);
                if (!DBIdentifier.isNull(defMap._defTable)) {
                    fm.getMappingInfo().setTableIdentifier(defMap._defTable);
                }
                this.setUnique(fm, defMap._unique);
            }
            if (defMap._defJoinCols != null) {
                fm.getMappingInfo().setColumns(defMap._defJoinCols);
            }
            if (defMap._defElemJoinCols == null) continue;
            fm.getElementMapping().getValueInfo().setColumns(defMap._defElemJoinCols);
        }
        defMappings.clear();
        this._deferredMappings.remove(cls);
    }

    private void deferEmbeddableOverrides(Class<?> cls, DeferredEmbeddableOverrides defMap) {
        ArrayList<DeferredEmbeddableOverrides> defMappings = this._deferredMappings.get(cls);
        if (defMappings == null) {
            defMappings = new ArrayList();
            this._deferredMappings.put(cls, defMappings);
        }
        defMappings.add(defMap);
    }

    @Override
    protected void clearDeferredMetaData() {
        super.clearDeferredMetaData();
        this._deferredMappings.clear();
    }

    private DeferredEmbeddableOverrides getDeferredFieldMappingInfo(Class<?> cls, FieldMapping fm, String attrName, boolean create) {
        DeferredEmbeddableOverrides dfm;
        ArrayList<DeferredEmbeddableOverrides> defMappings = this._deferredMappings.get(cls);
        if (defMappings == null && create) {
            defMappings = new ArrayList();
            this._deferredMappings.put(cls, defMappings);
        }
        if ((dfm = this.findDeferredMapping(cls, fm, attrName)) == null & create) {
            dfm = new DeferredEmbeddableOverrides(fm, attrName);
            this.deferEmbeddableOverrides(cls, dfm);
        }
        return dfm;
    }

    private DeferredEmbeddableOverrides findDeferredMapping(Class<?> cls, FieldMapping fm, String attrName) {
        ArrayList<DeferredEmbeddableOverrides> defMappings = this._deferredMappings.get(cls);
        if (defMappings == null) {
            return null;
        }
        for (DeferredEmbeddableOverrides dfm : defMappings) {
            if (dfm == null || dfm._fm != fm || !attrName.equals(dfm._attrName)) continue;
            return dfm;
        }
        return null;
    }

    @Override
    protected void addDeferredEmbeddableMetaData() {
        super.addDeferredEmbeddableMetaData();
        if (this._deferredMappings.size() > 0) {
            Set<Class<?>> keys = this._deferredMappings.keySet();
            Class[] classes = keys.toArray(new Class[keys.size()]);
            for (int i = 0; i < classes.length; ++i) {
                try {
                    this.applyDeferredEmbeddableOverrides(classes[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new MetaDataException(_loc.get("no-embeddable-metadata", classes[i].getName()), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected boolean startDelimitedIdentifiers() {
        JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        dict.setDelimitIdentifiers(true);
        return true;
    }

    @Override
    protected String normalizeSequenceName(String seqName) {
        if (StringUtils.isEmpty(seqName)) {
            return seqName;
        }
        return DBIdentifier.newSequence(seqName, this.delimit()).getName();
    }

    @Override
    protected String normalizeSchemaName(String schName) {
        if (StringUtils.isEmpty(schName)) {
            return schName;
        }
        return DBIdentifier.newSchema(schName, this.delimit()).getName();
    }

    @Override
    protected String normalizeCatalogName(String catName) {
        if (StringUtils.isEmpty(catName)) {
            return catName;
        }
        return DBIdentifier.newCatalog(catName, this.delimit()).getName();
    }

    private boolean delimit() {
        return this._dict.getDelimitIdentifiers();
    }

    private static int toEagerFetchModeConstant(String mode) {
        if (mode.equals("NONE")) {
            return 0;
        }
        if (mode.equals("JOIN")) {
            return 1;
        }
        if (mode.equals("PARALLEL")) {
            return 2;
        }
        throw new InternalException();
    }

    private boolean startDatastoreIdCol(Attributes attrs) throws SAXException {
        int precision;
        ClassMapping cm = (ClassMapping)this.peekElement();
        Column col = new Column();
        String name = attrs.getValue("name");
        if (!StringUtils.isEmpty(name)) {
            // empty if block
        }
        col.setIdentifier(DBIdentifier.newColumn(name, this.delimit()));
        String columnDefinition = attrs.getValue("column-definition");
        if (!StringUtils.isEmpty(columnDefinition)) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition(columnDefinition));
        }
        if ((precision = Integer.parseInt(attrs.getValue("precision"))) != 0) {
            col.setSize(precision);
        }
        col.setFlag(2, !Boolean.parseBoolean(attrs.getValue("insertable")));
        col.setFlag(4, !Boolean.parseBoolean(attrs.getValue("updatable")));
        cm.getMappingInfo().setColumns(Arrays.asList(col));
        return true;
    }

    private boolean startIndex(Attributes attrs) throws SAXException {
        FieldMapping fm = (FieldMapping)this.peekElement();
        this.parseIndex(fm.getValueInfo(), attrs.getValue("name"), Boolean.parseBoolean(attrs.getValue("enabled")), Boolean.parseBoolean(attrs.getValue("unique")));
        return true;
    }

    private void parseIndex(MappingInfo info, String name, boolean enabled, boolean unique) {
        if (!enabled) {
            info.setCanIndex(false);
            return;
        }
        Index idx = new Index();
        if (!StringUtils.isEmpty(name)) {
            idx.setIdentifier(DBIdentifier.newConstraint(name, this.delimit()));
        }
        idx.setUnique(unique);
        info.setIndex(idx);
    }

    private boolean startForeignKey(Attributes attrs) throws SAXException {
        this._foreignKeyAttributes = attrs;
        return true;
    }

    private void endForeignKey() {
        if (this._foreignKeyAttributes == null) {
            throw new InternalException();
        }
        boolean implicit = Boolean.parseBoolean(this._foreignKeyAttributes.getValue("implicit"));
        FieldMapping fm = (FieldMapping)this.peekElement();
        ValueMappingInfo info = fm.getValueInfo();
        String name = this._foreignKeyAttributes.getValue("name");
        boolean enabled = Boolean.parseBoolean(this._foreignKeyAttributes.getValue("enabled"));
        boolean deferred = Boolean.parseBoolean(this._foreignKeyAttributes.getValue("deferred"));
        boolean specified = Boolean.parseBoolean(this._foreignKeyAttributes.getValue("specified"));
        String deleteActionString = this._foreignKeyAttributes.getValue("delete-action");
        String updateActionString = this._foreignKeyAttributes.getValue("update-action");
        int deleteAction = this.toForeignKeyInt(deleteActionString);
        int updateAction = this.toForeignKeyInt(updateActionString);
        if (!implicit) {
            this.parseForeignKey(info, name, enabled, deferred, deleteAction, updateAction);
        } else {
            info.setImplicitRelation(true);
            this.assertDefault(name, enabled, deferred, specified, updateAction, deleteAction);
        }
        this._columnNamesList = null;
    }

    private void parseForeignKey(MappingInfo info, String name, boolean enabled, boolean deferred, int deleteAction, int updateAction) {
        if (!enabled) {
            info.setCanForeignKey(false);
            return;
        }
        ForeignKey fk = new ForeignKey();
        if (!StringUtils.isEmpty(name)) {
            fk.setIdentifier(DBIdentifier.newForeignKey(name, this.delimit()));
        }
        fk.setDeferred(deferred);
        fk.setDeleteAction(deleteAction);
        fk.setUpdateAction(updateAction);
        info.setForeignKey(fk);
    }

    private int toForeignKeyInt(String action) {
        if (action.equals("RESTRICT")) {
            return 2;
        }
        if (action.equals("CASCADE")) {
            return 3;
        }
        if (action.equals("NULL")) {
            return 4;
        }
        if (action.equals("DEFAULT")) {
            return 5;
        }
        throw new InternalException();
    }

    private void assertDefault(String name, boolean enabled, boolean deferred, boolean specified, int updateAction, int deleteAction) {
        boolean isDefault;
        boolean bl = isDefault = StringUtils.isEmpty(name) && enabled && !deferred && deleteAction == 2 && updateAction == 2 && this._columnNames.length == 0 && specified;
        if (!isDefault) {
            throw new UserException(_loc.get("implicit-non-default-fk", this._cls, this.getSourceFile()).getMessage());
        }
    }

    private boolean startFKColumnNames(Attributes attrs) throws SAXException {
        this._columnNamesList = new ArrayList<String>();
        return true;
    }

    private void endFKColumnNames() {
        if (this._columnNamesList.size() > 0) {
            this._columnNames = this._columnNamesList.toArray(this._columnNames);
            this._columnNamesList.removeAll(this._columnNamesList);
        }
    }

    private void endFKColumnName() {
        this._columnNamesList.add(this.currentText());
    }

    private boolean startVersionColumns(Attributes attrs) throws SAXException {
        this._versionColumnsList = new ArrayList<Column>();
        return true;
    }

    private void endVersionColumns() {
        if (this._versionColumnsList == null) {
            throw new InternalException();
        }
        if (this._versionColumnsList.size() > 0) {
            ClassMapping cm = (ClassMapping)this.peekElement();
            cm.getVersion().getMappingInfo().setColumns(this._versionColumnsList);
            this._versionColumnsList = null;
        }
    }

    private boolean startVersionColumn(Attributes attrs) throws SAXException {
        Column col = AnnotationPersistenceMappingParser.newColumn(attrs.getValue("name"), Boolean.parseBoolean(attrs.getValue("nullable")), Boolean.parseBoolean(attrs.getValue("insertable")), Boolean.parseBoolean(attrs.getValue("updatable")), attrs.getValue("columnDefinition"), Integer.parseInt(attrs.getValue("length")), Integer.parseInt(attrs.getValue("precision")), Integer.parseInt(attrs.getValue("scale")), attrs.getValue("table"), this.delimit());
        this._versionColumnsList.add(col);
        return true;
    }

    @Override
    protected void parseEagerFetchModeAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        FieldMapping fm = (FieldMapping)fmd;
        String eagerFetchMode = attrs.getValue("eager-fetch-mode");
        if (!StringUtils.isEmpty(eagerFetchMode)) {
            if (eagerFetchMode.equalsIgnoreCase("NONE")) {
                fm.setEagerFetchMode(0);
            } else if (eagerFetchMode.equalsIgnoreCase("JOIN")) {
                fm.setEagerFetchMode(1);
            } else if (eagerFetchMode.equalsIgnoreCase("PARALLEL")) {
                fm.setEagerFetchMode(2);
            }
        }
    }

    @Override
    protected void parseElementClassCriteriaAttr(FieldMetaData fmd, Attributes attrs) throws SAXException {
        String elementClassCriteriaString = attrs.getValue("element-class-criteria");
        if (!StringUtils.isEmpty(elementClassCriteriaString)) {
            FieldMapping fm = (FieldMapping)fmd;
            boolean elementClassCriteria = Boolean.parseBoolean(elementClassCriteriaString);
            fm.getElementMapping().getValueInfo().setUseClassCriteria(elementClassCriteria);
        }
    }

    @Override
    protected void parseStrategy(FieldMetaData fmd, Attributes attrs) {
        String strategy = attrs.getValue("strategy");
        if (!StringUtils.isEmpty(strategy)) {
            ((FieldMapping)fmd).getMappingInfo().setStrategy(strategy);
        }
    }

    @Override
    protected boolean startExtendedClass(String elem, Attributes attrs) throws SAXException {
        String subclassFetchMode;
        String discrimStrat;
        String versionStrat;
        ClassMapping mapping = (ClassMapping)this.currentElement();
        String strategy = attrs.getValue("strategy");
        if (!StringUtils.isEmpty(strategy)) {
            mapping.getMappingInfo().setStrategy(strategy);
        }
        if (!StringUtils.isEmpty(versionStrat = attrs.getValue("version-strategy"))) {
            mapping.getVersion().getMappingInfo().setStrategy(versionStrat);
        }
        if (!StringUtils.isEmpty(discrimStrat = attrs.getValue("discriminator-strategy"))) {
            mapping.getDiscriminator().getMappingInfo().setStrategy(discrimStrat);
        }
        if (!StringUtils.isEmpty(subclassFetchMode = attrs.getValue("subclass-fetch-mode"))) {
            mapping.setSubclassFetchMode(XMLPersistenceMappingParser.toEagerFetchModeConstant(subclassFetchMode));
        }
        return true;
    }

    static {
        _elems.put("association-override", MappingTag.ASSOC_OVERRIDE);
        _elems.put("attribute-override", MappingTag.ATTR_OVERRIDE);
        _elems.put("collection-table", MappingTag.COLLECTION_TABLE);
        _elems.put("column", MappingTag.COL);
        _elems.put("columns", MappingTag.COLS);
        _elems.put("column-name", MappingTag.COLUMN_NAME);
        _elems.put("column-result", MappingTag.COLUMN_RESULT);
        _elems.put("data-store-id-column", MappingTag.DATASTORE_ID_COL);
        _elems.put("delimited-identifiers", MappingTag.DELIMITED_IDS);
        _elems.put("discriminator-column", MappingTag.DISCRIM_COL);
        _elems.put("discriminator-value", MappingTag.DISCRIM_VAL);
        _elems.put("entity-result", MappingTag.ENTITY_RESULT);
        _elems.put("enumerated", MappingTag.ENUMERATED);
        _elems.put("field-result", MappingTag.FIELD_RESULT);
        _elems.put("foreign-key", MappingTag.FK);
        _elems.put("fk_column-names", MappingTag.FK_COL_NAMES);
        _elems.put("fk_column_name", MappingTag.FK_COL_NAME);
        _elems.put("inheritance", MappingTag.INHERITANCE);
        _elems.put("index", MappingTag.INDEX);
        _elems.put("join-column", MappingTag.JOIN_COL);
        _elems.put("inverse-join-column", MappingTag.COL);
        _elems.put("join-table", MappingTag.JOIN_TABLE);
        _elems.put("map-key-enumerated", MappingTag.MAP_KEY_ENUMERATED);
        _elems.put("map-key-column", MappingTag.MAP_KEY_COL);
        _elems.put("map-key-join-column", MappingTag.MAP_KEY_JOIN_COL);
        _elems.put("map-key-temporal", MappingTag.MAP_KEY_TEMPORAL);
        _elems.put("name", MappingTag.NAME);
        _elems.put("order-column", MappingTag.ORDER_COLUMN);
        _elems.put("primary-key-join-column", MappingTag.PK_JOIN_COL);
        _elems.put("secondary-table", MappingTag.SECONDARY_TABLE);
        _elems.put("sql-result-set-mapping", MappingTag.SQL_RESULT_SET_MAPPING);
        _elems.put("table", MappingTag.TABLE);
        _elems.put("table-generator", MappingTag.TABLE_GEN);
        _elems.put("temporal", MappingTag.TEMPORAL);
        _elems.put("unique-constraint", MappingTag.UNIQUE);
        _elems.put("version-columns", MappingTag.VERSION_COLS);
        _elems.put("version-column", MappingTag.VERSION_COL);
        _loc = Localizer.forPackage(XMLPersistenceMappingParser.class);
    }

    class DeferredEmbeddableOverrides {
        private FieldMapping _fm;
        private List<Column> _defCols;
        private List<Column> _defElemJoinCols;
        private List<Column> _defJoinCols;
        private DBIdentifier _defTable;
        private String _attrName;
        private EnumSet<UniqueFlag> _unique;

        DeferredEmbeddableOverrides(FieldMapping fm, String attrName) {
            this._fm = fm;
            this._attrName = attrName;
            this._defTable = DBIdentifier.NULL;
        }
    }

    private static enum UniqueFlag {
        TRUE,
        FALSE;

    }
}

