/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import org.databene.contiperf.InvocationRunner;
import org.databene.contiperf.PerfTestExecutionError;
import org.databene.contiperf.util.ContiPerfUtil;

public class ConcurrentRunner
implements InvocationRunner {
    private String name;
    private InvocationRunner[] runners;
    private int rampUp;

    public ConcurrentRunner(String name, InvocationRunner[] runners, int rampUp) {
        this.name = name;
        this.runners = runners;
        this.rampUp = rampUp;
    }

    @Override
    public void run() {
        CPThreadGroup threadGroup;
        block6: {
            int i;
            threadGroup = new CPThreadGroup(this.name);
            Thread[] threads = new Thread[this.runners.length];
            for (i = 0; i < this.runners.length; ++i) {
                threads[i] = new Thread((ThreadGroup)threadGroup, this.runners[i]);
            }
            for (i = 0; i < this.runners.length; ++i) {
                Thread thread = threads[i];
                thread.start();
                if (this.rampUp <= 0 || i >= this.runners.length - 1) continue;
                this.sleepForRampUpTime();
            }
            try {
                for (Thread thread : threads) {
                    thread.join();
                }
            }
            catch (InterruptedException e) {
                if (threadGroup.throwable != null) break block6;
                throw new PerfTestExecutionError(e);
            }
        }
        if (threadGroup.throwable != null) {
            throw ContiPerfUtil.executionError(threadGroup.throwable);
        }
    }

    private void sleepForRampUpTime() {
        try {
            Thread.sleep(this.rampUp);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        for (InvocationRunner runner : this.runners) {
            runner.close();
        }
        this.runners = null;
    }

    class CPThreadGroup
    extends ThreadGroup {
        Throwable throwable;

        public CPThreadGroup(String name) {
            super(name);
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (this.throwable == null) {
                this.throwable = throwable;
            }
            this.interrupt();
        }
    }
}

