/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

public class CharArraySet
extends AbstractSet {
    private static final int INIT_SIZE = 8;
    private char[][] entries;
    private int count;
    private final boolean ignoreCase;

    public CharArraySet(int startSize, boolean ignoreCase) {
        int size;
        this.ignoreCase = ignoreCase;
        for (size = 8; startSize + (startSize >> 2) > size; size <<= 1) {
        }
        this.entries = new char[size][];
    }

    public CharArraySet(Collection c, boolean ignoreCase) {
        this(c.size(), ignoreCase);
        this.addAll(c);
    }

    public boolean contains(char[] text, int off, int len) {
        return this.entries[this.getSlot(text, off, len)] != null;
    }

    public boolean contains(CharSequence cs) {
        return this.entries[this.getSlot(cs)] != null;
    }

    private int getSlot(char[] text, int off, int len) {
        int code = this.getHashCode(text, off, len);
        int pos = code & this.entries.length - 1;
        char[] text2 = this.entries[pos];
        if (text2 != null && !this.equals(text, off, len, text2)) {
            int inc = (code >> 8) + code | 1;
            while ((text2 = this.entries[pos = (code += inc) & this.entries.length - 1]) != null && !this.equals(text, off, len, text2)) {
            }
        }
        return pos;
    }

    private int getSlot(CharSequence text) {
        int code = this.getHashCode(text);
        int pos = code & this.entries.length - 1;
        char[] text2 = this.entries[pos];
        if (text2 != null && !this.equals(text, text2)) {
            int inc = (code >> 8) + code | 1;
            while ((text2 = this.entries[pos = (code += inc) & this.entries.length - 1]) != null && !this.equals(text, text2)) {
            }
        }
        return pos;
    }

    public boolean add(CharSequence text) {
        return this.add(((Object)text).toString());
    }

    public boolean add(String text) {
        return this.add(text.toCharArray());
    }

    public boolean add(char[] text) {
        int slot;
        if (this.ignoreCase) {
            for (int i = 0; i < text.length; ++i) {
                text[i] = Character.toLowerCase(text[i]);
            }
        }
        if (this.entries[slot = this.getSlot(text, 0, text.length)] != null) {
            return false;
        }
        this.entries[slot] = text;
        ++this.count;
        if (this.count + (this.count >> 2) > this.entries.length) {
            this.rehash();
        }
        return true;
    }

    private boolean equals(char[] text1, int off, int len, char[] text2) {
        if (len != text2.length) {
            return false;
        }
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                if (Character.toLowerCase(text1[off + i]) == text2[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1[off + i] == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean equals(CharSequence text1, char[] text2) {
        int len = text1.length();
        if (len != text2.length) {
            return false;
        }
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                if (Character.toLowerCase(text1.charAt(i)) == text2[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private void rehash() {
        int newSize = 2 * this.entries.length;
        char[][] oldEntries = this.entries;
        this.entries = new char[newSize][];
        for (int i = 0; i < oldEntries.length; ++i) {
            char[] text = oldEntries[i];
            if (text == null) continue;
            this.entries[this.getSlot((char[])text, (int)0, (int)text.length)] = text;
        }
    }

    private int getHashCode(char[] text, int offset, int len) {
        int code = 0;
        int stop = offset + len;
        if (this.ignoreCase) {
            for (int i = offset; i < stop; ++i) {
                code = code * 31 + Character.toLowerCase(text[i]);
            }
        } else {
            for (int i = offset; i < stop; ++i) {
                code = code * 31 + text[i];
            }
        }
        return code;
    }

    private int getHashCode(CharSequence text) {
        int code;
        if (this.ignoreCase) {
            code = 0;
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                code = code * 31 + Character.toLowerCase(text.charAt(i));
            }
        } else {
            code = 0;
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                code = code * 31 + text.charAt(i);
            }
        }
        return code;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object o) {
        if (o instanceof char[]) {
            char[] text = (char[])o;
            return this.contains(text, 0, text.length);
        }
        if (o instanceof CharSequence) {
            return this.contains((CharSequence)o);
        }
        return false;
    }

    public boolean add(Object o) {
        if (o instanceof char[]) {
            return this.add((char[])o);
        }
        if (o instanceof String) {
            return this.add((String)o);
        }
        if (o instanceof CharSequence) {
            return this.add((CharSequence)o);
        }
        return this.add(o.toString());
    }

    public Iterator iterator() {
        return new CharArraySetIterator();
    }

    public class CharArraySetIterator
    implements Iterator {
        int pos = -1;
        char[] next;

        CharArraySetIterator() {
            this.goNext();
        }

        private void goNext() {
            this.next = null;
            ++this.pos;
            while (this.pos < CharArraySet.this.entries.length && (this.next = CharArraySet.this.entries[this.pos]) == null) {
                ++this.pos;
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public char[] nextCharArray() {
            char[] ret = this.next;
            this.goNext();
            return ret;
        }

        public Object next() {
            return new String(this.nextCharArray());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

