/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.compass.core.CompassToken;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineAnalyzerHelper;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneToken;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerManager;

public class LuceneSearchEngineAnalyzerHelper
implements SearchEngineAnalyzerHelper {
    private LuceneAnalyzerManager analyzerManager;
    private Analyzer analyzer;

    public LuceneSearchEngineAnalyzerHelper(LuceneSearchEngine searchEngine) {
        this.analyzerManager = searchEngine.getSearchEngineFactory().getAnalyzerManager();
        this.analyzer = this.analyzerManager.getDefaultAnalyzer();
    }

    public SearchEngineAnalyzerHelper setAnalyzer(String analyzerName) {
        this.analyzer = this.analyzerManager.getAnalyzerMustExist(analyzerName);
        return this;
    }

    public SearchEngineAnalyzerHelper setAnalyzer(Resource resource) throws SearchEngineException {
        this.analyzer = this.analyzerManager.getAnalyzerByResource(resource);
        return this;
    }

    public SearchEngineAnalyzerHelper setAnalyzerByAlias(String alias) throws SearchEngineException {
        this.analyzer = this.analyzerManager.getAnalyzerByAliasMustExists(alias);
        return this;
    }

    public CompassToken analyzeSingle(String text) throws SearchEngineException {
        CompassToken[] tokens = this.analyze(text);
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        return tokens[0];
    }

    public CompassToken[] analyze(String text) {
        return this.analyze(new StringReader(text));
    }

    public CompassToken[] analyze(String propertyName, String text) throws SearchEngineException {
        return this.analyze(propertyName, new StringReader(text));
    }

    public CompassToken[] analyze(Reader textReader) throws SearchEngineException {
        return this.analyze(null, textReader);
    }

    public CompassToken[] analyze(String propertyName, Reader textReader) throws SearchEngineException {
        try {
            Token token;
            TokenStream tokenStream = this.analyzer.tokenStream(propertyName, textReader);
            ArrayList<LuceneToken> tokenList = new ArrayList<LuceneToken>();
            while ((token = tokenStream.next()) != null) {
                tokenList.add(new LuceneToken(token));
            }
            return tokenList.toArray(new CompassToken[tokenList.size()]);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to iterate token stream from analyzer [" + this.analyzer + "]");
        }
    }
}

