/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.store.impl.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.airavata.credential.store.store.impl.util.ConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorage {
    private static Logger log = LoggerFactory.getLogger(JdbcStorage.class);
    private ConnectionPool connectionPool;

    public JdbcStorage(String jdbcUrl, String jdbcDriver) {
        this(3, 50, jdbcUrl, jdbcDriver, true);
    }

    public JdbcStorage(int initCon, int maxCon, String url, String driver, boolean enableTransactions) {
        try {
            this.connectionPool = enableTransactions ? new ConnectionPool(driver, url, initCon, maxCon, true, false, 8) : new ConnectionPool(driver, url, initCon, maxCon, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create database connection pool.", e);
        }
    }

    public boolean isAutoCommit() {
        return this.connectionPool.isAutoCommit();
    }

    public void commit(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException sqle) {
            log.error("Cannot commit data", (Throwable)sqle);
        }
    }

    public void commitAndFree(Connection conn) {
        this.commit(conn);
        this.closeConnection(conn);
    }

    public void rollback(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                conn.rollback();
            }
        }
        catch (SQLException sqle) {
            log.error("Cannot Rollback data", (Throwable)sqle);
        }
    }

    public void rollbackAndFree(Connection conn) {
        this.rollback(conn);
        this.closeConnection(conn);
    }

    public Connection connect() {
        Connection conn = null;
        try {
            conn = this.connectionPool.getConnection();
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return conn;
    }

    public int executeUpdateAndClose(PreparedStatement stmt) throws SQLException {
        int rows = 0;
        try {
            rows = stmt.executeUpdate();
            if (rows == 0) {
                log.info("Problem: 0 rows affected by insert/update/delete statement.");
            }
        }
        finally {
            stmt.close();
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countRow(String tableName, String columnName) throws SQLException {
        String query = new String("SELECT COUNT(" + columnName + ") FROM " + tableName);
        int count = -1;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.connectionPool.getConnection();
            stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            count = rs.getInt(1);
            this.commit(conn);
        }
        catch (SQLException sql) {
            this.rollback(conn);
            throw sql;
        }
        finally {
            try {
                if (stmt != null && !stmt.isClosed()) {
                    stmt.close();
                }
            }
            finally {
                this.closeConnection(conn);
            }
        }
        return count;
    }

    public void quietlyClose(Connection conn, Statement ... stmts) {
        if (stmts != null) {
            for (Statement stmt : stmts) {
                try {
                    if (stmt == null || stmt.isClosed()) continue;
                    stmt.close();
                }
                catch (SQLException sql) {
                    log.error(sql.getMessage(), (Throwable)sql);
                }
            }
        }
        this.closeConnection(conn);
    }

    public void closeConnection(Connection conn) {
        if (conn != null) {
            this.connectionPool.free(conn);
        }
    }

    public void closeAllConnections() {
        if (this.connectionPool != null) {
            this.connectionPool.dispose();
        }
    }

    public void shutdown() throws SQLException {
        this.connectionPool.shutdown();
    }
}

