/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.infoset.view;

import javax.xml.namespace.QName;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlBuilderException;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlElementView;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.ext.XmlQNameAttribute;
import org.xmlpull.infoset.view.XmlValidationException;

public abstract class TypedXmlElementView
implements XmlElementView {
    protected XmlElement xml;

    public TypedXmlElementView(XmlElement el) {
        this.xml = el;
        this.xml().addView(this);
        this.checkNamespaceAndName();
    }

    @Override
    public XmlElement xml() {
        return this.xml;
    }

    public abstract XmlNamespace xmlTypeNs();

    public abstract String xmlTypeName();

    protected void checkNamespaceAndName() throws XmlValidationException {
        if (!this.xml.getNamespace().equals(this.xmlTypeNs())) {
            throw new XmlValidationException("element must be in '" + this.xmlTypeNs() + "'" + " and not '" + this.xml.getNamespace().getName() + "'");
        }
        if (!this.xml.getName().equals(this.xmlTypeName())) {
            throw new XmlValidationException("expected " + this.xmlTypeName() + " but got " + this.xml.getName());
        }
    }

    public <T extends XmlElementView> T xmlViewAs(Class<T> someViewClass) throws XmlBuilderException {
        return this.xml().viewAs(someViewClass);
    }

    protected void xmlSetAttributeQNameValue(String name, QName nameValue) {
        if (nameValue == null) {
            XmlAttribute oldAttribute = this.xml.attribute(name);
            if (oldAttribute != null) {
                this.xml.removeAttribute(oldAttribute);
            }
            return;
        }
        this.xmlSetRequiredAttributeQNameValue(name, nameValue);
    }

    protected void xmlSetRequiredAttributeQNameValue(String name, QName nameValue) {
        if (nameValue == null) {
            throw new XmlValidationException("attribute " + name + " is required to have value" + " in element " + this.xmlCuteElName());
        }
        XmlQNameAttribute aa = new XmlQNameAttribute(this.xml(), (XmlNamespace)null, name, nameValue);
        this.xml.setAttribute(aa);
    }

    protected QName xmlRequireAttributeQNameValue(String name) throws XmlValidationException {
        QName q = this.xmlGetAttributeQNameValue(name);
        if (q == null) {
            throw new XmlValidationException("required attribute " + name + " is missing from element " + this.xmlCuteElName());
        }
        return q;
    }

    protected QName xmlGetAttributeQNameValue(String name) {
        XmlAttribute aa = this.xml.attribute(name);
        if (aa == null) {
            return null;
        }
        if (aa instanceof XmlQNameAttribute) {
            return ((XmlQNameAttribute)aa).getValueAsQName();
        }
        XmlQNameAttribute qa = new XmlQNameAttribute(this.xml(), aa);
        this.xml.removeAttribute(aa);
        this.xml.setAttribute(qa);
        return qa.getValueAsQName();
    }

    protected void xmlSetRequiredAttributeNcNameValue(String name, String ncNameValue) {
        if (ncNameValue == null) {
            throw new XmlValidationException("attribute " + name + " is required ot have value" + " in element " + this.xmlCuteElName());
        }
        if (ncNameValue.indexOf(58) != -1) {
            throw new IllegalArgumentException("NcName attribute " + name + " value can not have double colon (':')" + " but got '" + ncNameValue + "'" + " in element " + this.xmlCuteElName());
        }
        this.xml.setAttributeValue(name, ncNameValue);
    }

    protected void xmlSetAttributeNcNameValue(String name, String ncNameValue) {
        if (ncNameValue == null) {
            XmlAttribute attr = this.xml.attribute(name);
            if (attr != null) {
                this.xml.removeAttribute(attr);
            }
            return;
        }
        this.xmlSetRequiredAttributeNcNameValue(name, ncNameValue);
    }

    protected String xmlRequireAttributeNcNameValue(String name) throws XmlValidationException {
        String s = this.xmlGetAttributeNcNameValue(name);
        if (s == null) {
            throw new XmlValidationException("required attribute " + name + " is missing from " + this.xmlCuteElName());
        }
        return s;
    }

    protected String xmlGetAttributeNcNameValue(String name) {
        String ncNameValue = this.xml.attributeValue(name);
        if (ncNameValue != null && ncNameValue.indexOf(58) != -1) {
            throw new IllegalArgumentException("NcName attribute value can not have double colon (':')but got '" + ncNameValue + "'" + " in " + this.xmlCuteElName());
        }
        return ncNameValue;
    }

    protected String xmlCuteElName() {
        return "{" + this.xml().getNamespaceName() + "}" + this.xml().getName();
    }

    public void xmlValidate() throws XmlValidationException {
        this.checkNamespaceAndName();
    }
}

