/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers;

import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public abstract class UIEnabledHandler
extends Handler {
    private String defaultBrowseView;
    private String defaultEditView;
    private String defaultNewView;
    private static final String REG_PARENT_PATH = "<reg>parentPath</reg>";

    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        ResourcePath resourcePath = requestContext.getResourcePath();
        Resource resource = resourcePath.parameterExists("view") ? this.generateBrowseView(resourcePath, requestContext) : (resourcePath.parameterExists("edit") ? this.generateEditView(resourcePath, requestContext) : (resourcePath.parameterExists("new") ? this.generateNewView(resourcePath, requestContext) : this.getRawResource(requestContext)));
        this.fillViews(resource);
        return resource;
    }

    public Resource getRawResource(RequestContext requestContext) throws RegistryException {
        if (requestContext.getResource() != null) {
            return requestContext.getResource();
        }
        if (requestContext.getResourcePath().isCurrentVersion()) {
            return requestContext.getRepository().get(requestContext.getResourcePath().getPath());
        }
        return null;
    }

    public abstract String[] getBrowseViews();

    public abstract String[] getEditViews();

    public String[] getNewViews() {
        return new String[]{"undefined:UI name is not defined"};
    }

    public String getDefaultBrowseView() {
        if (this.defaultBrowseView == null) {
            this.defaultBrowseView = this.calculateDefaultView(this.getBrowseViews());
        }
        return this.defaultBrowseView;
    }

    protected void setDefaultBrowseView(String viewName) {
        this.defaultBrowseView = viewName;
    }

    public String getDefaultEditView() {
        if (this.defaultEditView == null) {
            this.defaultEditView = this.calculateDefaultView(this.getEditViews());
        }
        return this.defaultEditView;
    }

    protected void setDefaultEditView(String viewName) {
        this.defaultEditView = viewName;
    }

    public String getDefaultNewView() {
        if (this.defaultNewView == null) {
            this.defaultNewView = this.calculateDefaultView(this.getNewViews());
        }
        return this.defaultNewView;
    }

    protected void setDefaultNewView(String viewName) {
        this.defaultNewView = viewName;
    }

    public Resource getBrowseView(String browseViewKey, RequestContext requestContext) throws RegistryException {
        return null;
    }

    public Resource getEditView(String editViewKey, RequestContext requestContext) throws RegistryException {
        return null;
    }

    public Resource getNewView(String newViewKey, RequestContext requestContext) throws RegistryException {
        Resource resource = requestContext.getRegistry().newResource();
        resource.setContent("Resource creation UI is not provided.");
        return resource;
    }

    private Resource generateBrowseView(ResourcePath resourcePath, RequestContext requestContext) throws RegistryException {
        Resource resource;
        String viewName = resourcePath.getParameterValue("view");
        if (viewName == null || "".equals(viewName) || "default".equals(viewName)) {
            viewName = this.getDefaultBrowseView();
        }
        if ("raw".equals(viewName)) {
            resource = this.getRawResource(requestContext);
        } else {
            resource = this.getBrowseView(viewName, requestContext);
            if (resource.getProperty("registry.ui.renderingMethod") == null) {
                if ("text".equals(viewName)) {
                    resource.setProperty("registry.ui.renderingMethod", "view.text");
                } else if ("xml".equals(viewName)) {
                    resource.setProperty("registry.ui.renderingMethod", "view.xml");
                } else {
                    resource.setProperty("registry.ui.renderingMethod", "general");
                }
            }
        }
        resource.setProperty("registry.ui.mode", "browse.mode");
        return resource;
    }

    private Resource generateEditView(ResourcePath resourcePath, RequestContext requestContext) throws RegistryException {
        Resource resource;
        String viewName = resourcePath.getParameterValue("edit");
        if (viewName == null || "".equals(viewName) || "default".equals(viewName)) {
            viewName = this.getDefaultEditView();
        }
        if ("raw".equals(viewName)) {
            resource = this.getRawResource(requestContext);
        } else {
            resource = this.getEditView(viewName, requestContext);
            if (resource.getProperty("registry.ui.renderingMethod") == null) {
                if ("text".equals(viewName)) {
                    resource.setProperty("registry.ui.renderingMethod", "edit.text");
                } else if ("xml".equals(viewName)) {
                    resource.setProperty("registry.ui.renderingMethod", "edit.xml");
                } else {
                    resource.setProperty("registry.ui.renderingMethod", "general");
                }
            }
        }
        resource.setProperty("registry.ui.mode", "edit.mode");
        return resource;
    }

    private Resource generateNewView(ResourcePath resourcePath, RequestContext requestContext) throws RegistryException {
        String viewName = resourcePath.getParameterValue("new");
        if (viewName == null || "".equals(viewName) || "default".equals(viewName)) {
            viewName = this.getDefaultNewView();
        }
        Resource resource = this.getNewView(viewName, requestContext);
        this.replaceRegistryParameters(resource, resourcePath);
        if (resource.getProperty("registry.ui.renderingMethod") == null) {
            if ("text".equals(viewName)) {
                resource.setProperty("registry.ui.renderingMethod", "new.text");
            } else if ("xml".equals(viewName)) {
                resource.setProperty("registry.ui.renderingMethod", "new.xml");
            } else {
                resource.setProperty("registry.ui.renderingMethod", "general");
            }
        }
        resource.setProperty("registry.ui.mode", "new.mode");
        requestContext.setProcessingComplete(true);
        return resource;
    }

    private void replaceRegistryParameters(Resource resource, ResourcePath resourcePath) throws RegistryException {
        Object o = resource.getContent();
        if (o == null || !(o instanceof String)) {
            return;
        }
        String content = (String)o;
        String parentPath = resourcePath.getParameterValue("parentPath");
        content = content.replaceFirst(REG_PARENT_PATH, "<input type='hidden' name='parentPath' value='" + parentPath + "'/>");
        resource.setContent(content);
    }

    private void fillViews(Resource resource) {
        String[] newViews;
        String[] editViews;
        String[] browseViews;
        for (String browseView : browseViews = this.getBrowseViews()) {
            resource.addProperty("registry.browse-views", browseView);
        }
        for (String editView : editViews = this.getEditViews()) {
            resource.addProperty("registry.edit-views", editView);
        }
        for (String newView : newViews = this.getNewViews()) {
            resource.addProperty("registry.new-views", newView);
        }
    }

    private String calculateDefaultView(String[] views) {
        if (views.length > 0) {
            String[] viewParts = views[0].split(":");
            return viewParts[0];
        }
        return "raw";
    }
}

