/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.map.record.AbstractRecord;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class DataRecord
extends AbstractRecord<Data>
implements Record<Data>,
IdentifiedDataSerializable {
    protected volatile Data value;

    public DataRecord(Data keyData, Data value, boolean statisticsEnabled) {
        super(keyData, statisticsEnabled);
        this.value = value;
    }

    public DataRecord() {
    }

    @Override
    public long getCost() {
        return this.key.totalSize() + (this.value == null ? 0 : this.value.totalSize());
    }

    @Override
    public Data getValue() {
        return this.value;
    }

    @Override
    public Data setValue(Data o) {
        Data old = this.value;
        this.value = o;
        return old;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        this.value.writeData(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 5;
    }
}

