/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.model.workspace.Project;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.resources.GatewayResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProjectResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.ProjectUserResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.UserResource;
import org.apache.airavata.registry.core.experiment.catalog.resources.WorkerResource;
import org.apache.airavata.registry.core.experiment.catalog.utils.ThriftDataModelConversion;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.ResultOrderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRegistry {
    private GatewayResource gatewayResource;
    private WorkerResource workerResource;
    private static final Logger logger = LoggerFactory.getLogger(ProjectRegistry.class);

    public ProjectRegistry(GatewayResource gatewayResource, UserResource user) throws RegistryException {
        this.gatewayResource = !ExpCatResourceUtils.isGatewayExist(gatewayResource.getGatewayId()) ? gatewayResource : (GatewayResource)ExpCatResourceUtils.getGateway(gatewayResource.getGatewayId());
        this.workerResource = !gatewayResource.isExists(ResourceType.GATEWAY_WORKER, user.getUserName()) ? ExpCatResourceUtils.addGatewayWorker(gatewayResource, user) : (WorkerResource)ExpCatResourceUtils.getWorker(gatewayResource.getGatewayId(), user.getUserName());
    }

    public String addProject(Project project, String gatewayId) throws RegistryException {
        String projectId;
        try {
            if (!ExpCatResourceUtils.isUserExist(project.getOwner(), gatewayId)) {
                ExpCatResourceUtils.addUser(project.getOwner(), null, gatewayId);
            }
            ProjectResource projectResource = new ProjectResource();
            projectId = this.getProjectId(project.getName());
            projectResource.setId(projectId);
            project.setProjectID(projectId);
            projectResource.setName(project.getName());
            projectResource.setDescription(project.getDescription());
            projectResource.setCreationTime(AiravataUtils.getTime((long)project.getCreationTime()));
            projectResource.setGatewayId(gatewayId);
            WorkerResource worker = new WorkerResource(project.getOwner(), gatewayId);
            projectResource.setWorker(worker);
            projectResource.save();
            ProjectUserResource resource = (ProjectUserResource)projectResource.create(ResourceType.PROJECT_USER);
            resource.setProjectId(project.getProjectID());
            resource.setUserName(project.getOwner());
            resource.save();
        }
        catch (Exception e) {
            logger.error("Error while saving project to registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return projectId;
    }

    private String getProjectId(String projectName) {
        String pro = projectName.replaceAll("\\s", "");
        return pro + "_" + UUID.randomUUID();
    }

    public void updateProject(Project project, String projectId) throws RegistryException {
        try {
            ProjectResource existingProject = this.workerResource.getProject(projectId);
            existingProject.setDescription(project.getDescription());
            existingProject.setName(project.getName());
            WorkerResource worker = new WorkerResource(project.getOwner(), project.getGatewayId());
            existingProject.setWorker(worker);
            existingProject.save();
            ProjectUserResource resource = (ProjectUserResource)existingProject.create(ResourceType.PROJECT_USER);
            resource.setProjectId(projectId);
            resource.setUserName(project.getOwner());
            resource.save();
        }
        catch (Exception e) {
            logger.error("Error while saving project to registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public Project getProject(String projectId) throws RegistryException {
        try {
            ProjectResource project = this.workerResource.getProject(projectId);
            if (project != null) {
                return ThriftDataModelConversion.getProject(project);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving project from registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public List<Project> getProjectList(String fieldName, Object value) throws RegistryException {
        return this.getProjectList(fieldName, value, -1, -1, null, null);
    }

    public List<Project> getProjectList(String fieldName, Object value, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        ArrayList<Project> projects = new ArrayList<Project>();
        try {
            if (fieldName.equals("owner")) {
                this.workerResource.setUser((String)value);
                List<ProjectResource> projectList = this.workerResource.getProjects();
                if (projectList != null && !projectList.isEmpty()) {
                    for (ProjectResource pr : projectList) {
                        projects.add(ThriftDataModelConversion.getProject(pr));
                    }
                }
                return projects;
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving project from registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return projects;
    }

    public List<Project> searchProjects(Map<String, String> filters) throws RegistryException {
        return this.searchProjects(filters, -1, -1, null, null);
    }

    public List<Project> searchProjects(Map<String, String> filters, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        HashMap<String, String> fil = new HashMap<String, String>();
        if (filters != null && filters.size() != 0) {
            ArrayList<Project> projects = new ArrayList<Project>();
            try {
                for (String field : filters.keySet()) {
                    if (field.equals("name")) {
                        fil.put("projectName", filters.get(field));
                        continue;
                    }
                    if (field.equals("owner")) {
                        fil.put("userName", filters.get(field));
                        continue;
                    }
                    if (field.equals("description")) {
                        fil.put("description", filters.get(field));
                        continue;
                    }
                    if (!field.equals("gateway_id")) continue;
                    fil.put("gatewayId", filters.get(field));
                }
                List<ProjectResource> projectResources = this.workerResource.searchProjects(fil, null, limit, offset, orderByIdentifier, resultOrderType);
                if (projectResources != null && !projectResources.isEmpty()) {
                    for (ProjectResource pr : projectResources) {
                        projects.add(ThriftDataModelConversion.getProject(pr));
                    }
                }
                return projects;
            }
            catch (Exception e) {
                logger.error("Error while retrieving project from registry", (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        return null;
    }

    public List<Project> searchAllAccessibleProjects(List<String> accessibleIds, Map<String, String> filters, int limit, int offset, Object orderByIdentifier, ResultOrderType resultOrderType) throws RegistryException {
        HashMap<String, String> fil = new HashMap<String, String>();
        if (filters != null && filters.size() != 0) {
            ArrayList<Project> projects = new ArrayList<Project>();
            try {
                for (String field : filters.keySet()) {
                    if (field.equals("name")) {
                        fil.put("projectName", filters.get(field));
                        continue;
                    }
                    if (field.equals("owner")) {
                        fil.put("userName", filters.get(field));
                        continue;
                    }
                    if (field.equals("description")) {
                        fil.put("description", filters.get(field));
                        continue;
                    }
                    if (!field.equals("gateway_id")) continue;
                    fil.put("gatewayId", filters.get(field));
                }
                List<ProjectResource> projectResources = this.workerResource.searchProjects(fil, accessibleIds, limit, offset, orderByIdentifier, resultOrderType);
                if (projectResources != null && !projectResources.isEmpty()) {
                    for (ProjectResource pr : projectResources) {
                        projects.add(ThriftDataModelConversion.getProject(pr));
                    }
                }
                return projects;
            }
            catch (Exception e) {
                logger.error("Error while retrieving project from registry", (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        return null;
    }

    public List<String> getProjectIDs(String fieldName, Object value) throws RegistryException {
        ArrayList<String> projectIds = new ArrayList<String>();
        try {
            if (fieldName.equals("owner")) {
                this.workerResource.setUser((String)value);
                List<ProjectResource> projectList = this.workerResource.getProjects();
                if (projectList != null && !projectList.isEmpty()) {
                    for (ProjectResource pr : projectList) {
                        projectIds.add(pr.getName());
                    }
                }
                return projectIds;
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving projects from registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return projectIds;
    }

    public void removeProject(String projectId) throws RegistryException {
        try {
            this.workerResource.removeProject(projectId);
        }
        catch (Exception e) {
            logger.error("Error while removing the project..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isProjectExist(String projectId) throws RegistryException {
        try {
            return this.workerResource.isProjectExists(projectId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving project...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }
}

