/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.workflow.catalog.utils;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.registry.core.workflow.catalog.model.ComponentStatus;
import org.apache.airavata.registry.core.workflow.catalog.model.Edge;
import org.apache.airavata.registry.core.workflow.catalog.model.Node;
import org.apache.airavata.registry.core.workflow.catalog.model.Port;
import org.apache.airavata.registry.core.workflow.catalog.model.Workflow;
import org.apache.airavata.registry.core.workflow.catalog.model.WorkflowInput;
import org.apache.airavata.registry.core.workflow.catalog.model.WorkflowOutput;
import org.apache.airavata.registry.core.workflow.catalog.model.WorkflowStatus;
import org.apache.airavata.registry.core.workflow.catalog.resources.ComponentStatusResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.EdgeResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.NodeResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.PortResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowCatalogResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowInputResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowOutputResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowResource;
import org.apache.airavata.registry.core.workflow.catalog.resources.WorkflowStatusResource;
import org.apache.airavata.registry.core.workflow.catalog.utils.WorkflowCatalogResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowCatalogJPAUtils {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowCatalogJPAUtils.class);
    private static final String PERSISTENCE_UNIT_NAME = "workflowcatalog_data";
    private static final String WFCATALOG_JDBC_DRIVER = "wfcatalog.jdbc.driver";
    private static final String WFCATALOG_JDBC_URL = "wfcatalog.jdbc.url";
    private static final String WFCATALOG_JDBC_USER = "wfcatalog.jdbc.user";
    private static final String WFCATALOG_JDBC_PASSWORD = "wfcatalog.jdbc.password";
    private static final String WFCATALOG_VALIDATION_QUERY = "wfcatalog.validationQuery";
    private static final String JPA_CACHE_SIZE = "jpa.cache.size";
    private static final String JPA_CACHE_ENABLED = "cache.enable";
    @PersistenceUnit(unitName="workflowcatalog_data")
    protected static EntityManagerFactory factory;
    @PersistenceContext(unitName="worlkflowcatalog_data")
    private static EntityManager wfCatEntityManager;

    public static EntityManager getEntityManager() throws ApplicationSettingsException {
        if (factory == null) {
            String connectionProperties = "DriverClassName=" + WorkflowCatalogJPAUtils.readServerProperties(WFCATALOG_JDBC_DRIVER) + ",Url=" + WorkflowCatalogJPAUtils.readServerProperties(WFCATALOG_JDBC_URL) + "?autoReconnect=true,Username=" + WorkflowCatalogJPAUtils.readServerProperties(WFCATALOG_JDBC_USER) + ",Password=" + WorkflowCatalogJPAUtils.readServerProperties(WFCATALOG_JDBC_PASSWORD) + ",validationQuery=" + WorkflowCatalogJPAUtils.readServerProperties(WFCATALOG_VALIDATION_QUERY);
            System.out.println(connectionProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("openjpa.ConnectionDriverName", "org.apache.commons.dbcp.BasicDataSource");
            properties.put("openjpa.ConnectionProperties", connectionProperties);
            properties.put("openjpa.DynamicEnhancementAgent", "true");
            properties.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
            properties.put("openjpa.RemoteCommitProvider", "sjvm");
            properties.put("openjpa.Log", "DefaultLevel=INFO, Runtime=INFO, Tool=INFO, SQL=INFO");
            properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
            properties.put("openjpa.jdbc.QuerySQLCache", "false");
            properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72, PrintParameters=true, MaxActive=10, MaxIdle=5, MinIdle=2, MaxWait=31536000,  autoReconnect=true");
            factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, properties);
        }
        wfCatEntityManager = factory.createEntityManager();
        return wfCatEntityManager;
    }

    private static String readServerProperties(String propertyName) throws ApplicationSettingsException {
        try {
            return ServerSettings.getSetting((String)propertyName);
        }
        catch (ApplicationSettingsException e) {
            logger.error("Unable to read airavata-server.properties...", (Throwable)e);
            throw new ApplicationSettingsException("Unable to read airavata-server.properties...");
        }
    }

    public static WorkflowCatalogResource getResource(WorkflowCatalogResourceType type, Object o) {
        switch (type) {
            case WORKFLOW: {
                if (o instanceof Workflow) {
                    return WorkflowCatalogJPAUtils.createWorkflow((Workflow)o);
                }
                logger.error("Object should be a Workflow.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Workflow.");
            }
            case WORKFLOW_INPUT: {
                if (o instanceof WorkflowInput) {
                    return WorkflowCatalogJPAUtils.createWorflowInput((WorkflowInput)o);
                }
                logger.error("Object should be a Workflow Input.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Workflow Input.");
            }
            case WORKFLOW_OUTPUT: {
                if (o instanceof WorkflowOutput) {
                    return WorkflowCatalogJPAUtils.createWorkflowOutput((WorkflowOutput)o);
                }
                logger.error("Object should be a Workflow Output.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Workflow Output.");
            }
            case COMPONENT_STATUS: {
                if (o instanceof ComponentStatus) {
                    return WorkflowCatalogJPAUtils.createComponentStatus((ComponentStatus)o);
                }
                logger.error("Object should be a Workflow Output.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Workflow Output.");
            }
            case NODE: {
                if (o instanceof Node) {
                    return WorkflowCatalogJPAUtils.createNode((Node)o);
                }
                logger.error("Object should be a Node.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Node.");
            }
            case PORT: {
                if (o instanceof Port) {
                    return WorkflowCatalogJPAUtils.createPort((Port)o);
                }
                logger.error("Object should be a Port.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Port.");
            }
            case EDGE: {
                if (o instanceof Edge) {
                    return WorkflowCatalogJPAUtils.createEdge((Edge)o);
                }
                logger.error("Object should be a Edge.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Edge.");
            }
        }
        logger.error("Illegal data type..", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Illegal data type..");
    }

    private static WorkflowCatalogResource createWorflowInput(WorkflowInput o) {
        WorkflowInputResource resource = new WorkflowInputResource();
        if (o != null) {
            resource.setWfTemplateId(o.getTemplateID());
            resource.setInputKey(o.getInputKey());
            if (o.getInputVal() != null) {
                resource.setInputVal(new String(o.getInputVal()));
            }
            resource.setDataType(o.getDataType());
            resource.setMetadata(o.getMetadata());
            resource.setAppArgument(o.getAppArgument());
            resource.setInputOrder(o.getInputOrder());
            resource.setUserFriendlyDesc(o.getUserFriendlyDesc());
            resource.setStandardInput(o.isStandardInput());
            resource.setRequired(o.isRequired());
            resource.setRequiredToCMD(o.isRequiredToCMD());
            resource.setDataStaged(o.isDataStaged());
            resource.setWorkflowResource((WorkflowResource)WorkflowCatalogJPAUtils.createWorkflow(o.getWorkflow()));
        }
        return resource;
    }

    private static WorkflowCatalogResource createWorkflowOutput(WorkflowOutput o) {
        WorkflowOutputResource resource = new WorkflowOutputResource();
        if (o != null) {
            resource.setWfTemplateId(o.getTemplateId());
            resource.setOutputKey(o.getOutputKey());
            if (o.getOutputVal() != null) {
                resource.setOutputVal(new String(o.getOutputVal()));
            }
            resource.setDataType(o.getDataType());
            resource.setDataMovement(o.isDataMovement());
            resource.setDataNameLocation(o.getDataNameLocation());
            resource.setWorkflowResource((WorkflowResource)WorkflowCatalogJPAUtils.createWorkflow(o.getWorkflow()));
        }
        return resource;
    }

    private static ComponentStatusResource createComponentStatus(ComponentStatus o) {
        ComponentStatusResource resource = new ComponentStatusResource();
        if (o != null) {
            resource.setStatusId(o.getStatusId());
            resource.setTemplateId(o.getTemplateId());
            resource.setUpdatedTime(o.getUpdateTime());
            resource.setReason(o.getReason());
            resource.setState(o.getState());
        }
        return resource;
    }

    private static WorkflowStatusResource createWorkflowStatus(WorkflowStatus o) {
        WorkflowStatusResource resource = new WorkflowStatusResource();
        if (o != null) {
            resource.setStatusId(o.getStatusId());
            resource.setTemplateId(o.getTemplateId());
            resource.setReason(o.getReason());
            resource.setState(o.getState());
            resource.setUpdatedTime(o.getUpdateTime());
        }
        return resource;
    }

    private static EdgeResource createEdge(Edge o) {
        EdgeResource resource = new EdgeResource();
        if (o != null) {
            resource.setStatusId(o.getComponentStatusId());
            resource.setTemplateId(o.getTemplateId());
            resource.setEdgeId(o.getEdgeId());
            resource.setDescription(o.getDescription());
            resource.setName(o.getName());
            resource.setCreatedTime(o.getCreatedTime());
        }
        return resource;
    }

    private static PortResource createPort(Port o) {
        PortResource resource = new PortResource();
        if (o != null) {
            resource.setStatusId(o.getComponentStatusId());
            resource.setTemplateId(o.getTemplateId());
            resource.setPortId(o.getPortId());
            resource.setDescription(o.getDescription());
            resource.setName(o.getName());
            resource.setCreatedTime(o.getCreatedTime());
        }
        return resource;
    }

    private static NodeResource createNode(Node o) {
        NodeResource resource = new NodeResource();
        if (o != null) {
            resource.setStatusId(o.getComponentStatusId());
            resource.setTemplateId(o.getTemplateId());
            resource.setNodeId(o.getNodeId());
            resource.setDescription(o.getDescription());
            resource.setName(o.getName());
            resource.setCreatedTime(o.getCreatedTime());
            resource.setApplicationId(o.getApplicationId());
            resource.setApplicationName(o.getApplicationName());
        }
        return resource;
    }

    private static WorkflowCatalogResource createWorkflow(Workflow o) {
        WorkflowResource workflowResource = new WorkflowResource();
        workflowResource.setWfName(o.getWorkflowName());
        workflowResource.setCreatedUser(o.getCreatedUser());
        if (o.getGraph() != null) {
            workflowResource.setGraph(new String(o.getGraph()));
        }
        if (o.getImage() != null) {
            workflowResource.setImage(new String(o.getImage()));
        }
        workflowResource.setCreatedTime(o.getCreationTime());
        if (o.getUpdateTime() != null) {
            workflowResource.setUpdatedTime(o.getUpdateTime());
        }
        workflowResource.setWfTemplateId(o.getTemplateId());
        workflowResource.setGatewayId(o.getGatewayId());
        return workflowResource;
    }
}

