/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.operations.CollectionBackupAwareOperation;
import com.hazelcast.collection.operations.RemoveIndexBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.List;

public class RemoveIndexOperation
extends CollectionBackupAwareOperation {
    int index;

    public RemoveIndexOperation() {
    }

    public RemoveIndexOperation(CollectionProxyId proxyId, Data dataKey, int threadId, int index) {
        super(proxyId, dataKey, threadId);
        this.index = index;
    }

    @Override
    public void run() throws Exception {
        List list = (List)this.getOrCreateCollectionWrapper().getCollection();
        try {
            CollectionRecord record = (CollectionRecord)list.remove(this.index);
            this.response = record == null ? null : record.getObject();
        }
        catch (IndexOutOfBoundsException e) {
            this.response = e;
        }
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveIndexBackupOperation(this.proxyId, this.dataKey, this.index);
    }

    @Override
    public boolean shouldBackup() {
        return !(this.response instanceof Exception);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.index);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.index = in.readInt();
    }

    @Override
    public int getId() {
        return 22;
    }
}

