/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.dsig;

import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StandaloneCanonizer {
    private DocumentBuilder documentBuilder;

    public StandaloneCanonizer() throws Exception {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setValidating(false);
        this.documentBuilder = dfactory.newDocumentBuilder();
    }

    public static void main(String[] args) {
        boolean doEnvTr = false;
        if (args.length > 0 && args[0].equals("-e")) {
            doEnvTr = true;
        }
        try {
            StandaloneCanonizer instance = new StandaloneCanonizer();
            Document doc = instance.readDoc(null);
            String res = instance.fireCanon(doc, doEnvTr);
            System.out.println(res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readDoc(String file) throws Exception {
        if (file == null) {
            Document inputDoc = this.documentBuilder.parse(System.in);
            return inputDoc;
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            Document inputDoc;
            Document document = inputDoc = this.documentBuilder.parse(fis);
            return document;
        }
        finally {
            fis.close();
        }
    }

    public static Element createDSctx(Document doc, String prefix, String namespace) {
        Element ctx = doc.createElementNS(null, "namespaceContext");
        ctx.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        return ctx;
    }

    public String fireCanon(Document inputDoc, boolean envSigTr) throws Exception {
        XMLSignatureInput result;
        Init.init();
        XMLSignatureInput signatureInput = new XMLSignatureInput((Node)inputDoc);
        Document transformDoc = this.documentBuilder.newDocument();
        if (envSigTr) {
            Element nscontext = StandaloneCanonizer.createDSctx(inputDoc, "ds", "http://www.w3.org/2000/09/xmldsig#");
            Element transformsElement = (Element)XPathAPI.selectSingleNode((Node)inputDoc, (String)"//ds:Transforms", (Node)nscontext);
            Transforms transforms = new Transforms(transformsElement, "memory://");
            result = transforms.performTransforms(signatureInput);
        } else {
            Transforms c14nTrans = new Transforms(transformDoc);
            transformDoc.appendChild(c14nTrans.getElement());
            c14nTrans.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            result = c14nTrans.performTransforms(signatureInput);
        }
        byte[] outputBytes = result.getBytes();
        return new String(outputBytes);
    }
}

