/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufPropertiesModule
extends Module {
    private static final Logger log = LoggerFactory.getLogger(ProtobufPropertiesModule.class);
    private final Map<Class<?>, Map<String, Descriptors.FieldDescriptor>> CACHE = new ConcurrentHashMap();
    NopAnnotationIntrospector annotationIntrospector = new NopAnnotationIntrospector(){

        public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
            if (Message.class.isAssignableFrom(ac.getRawType())) {
                return checker.withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withFieldVisibility(JsonAutoDetect.Visibility.ANY);
            }
            return super.findAutoDetectVisibility(ac, checker);
        }

        public Object findNamingStrategy(AnnotatedClass ac) {
            if (!Message.class.isAssignableFrom(ac.getRawType())) {
                return super.findNamingStrategy(ac);
            }
            return new PropertyNamingStrategy.PropertyNamingStrategyBase(){

                public String translate(String propertyName) {
                    if (propertyName.endsWith("_")) {
                        return propertyName.substring(0, propertyName.length() - 1);
                    }
                    return propertyName;
                }
            };
        }
    };

    public String getModuleName() {
        return "ProtobufPropertiesModule";
    }

    public Version version() {
        return VersionUtil.versionFor(((Object)((Object)this)).getClass());
    }

    public void setupModule(Module.SetupContext context) {
        context.setClassIntrospector((ClassIntrospector)new ProtobufClassIntrospector());
        context.insertAnnotationIntrospector((AnnotationIntrospector)this.annotationIntrospector);
    }

    class ProtobufClassIntrospector
    extends BasicClassIntrospector {
        ProtobufClassIntrospector() {
        }

        public BasicBeanDescription forDeserialization(DeserializationConfig cfg, JavaType type, ClassIntrospector.MixInResolver r) {
            BasicBeanDescription desc = super.forDeserialization(cfg, type, r);
            if (Message.class.isAssignableFrom(type.getRawClass())) {
                return this.protobufBeanDescription((MapperConfig<?>)cfg, type, r, desc);
            }
            return desc;
        }

        public BasicBeanDescription forSerialization(SerializationConfig cfg, JavaType type, ClassIntrospector.MixInResolver r) {
            BasicBeanDescription desc = super.forSerialization(cfg, type, r);
            if (Message.class.isAssignableFrom(type.getRawClass())) {
                return this.protobufBeanDescription((MapperConfig<?>)cfg, type, r, desc);
            }
            return desc;
        }

        private BasicBeanDescription protobufBeanDescription(MapperConfig<?> cfg, JavaType type, ClassIntrospector.MixInResolver r, BasicBeanDescription baseDesc) {
            Map types = ProtobufPropertiesModule.this.CACHE.computeIfAbsent(type.getRawClass(), this::getDescriptorForType);
            AnnotatedClass ac = AnnotatedClassResolver.resolve(cfg, (JavaType)type, (ClassIntrospector.MixInResolver)r);
            ArrayList<BeanPropertyDefinition> props = new ArrayList<BeanPropertyDefinition>();
            for (BeanPropertyDefinition p : baseDesc.findProperties()) {
                String name = p.getName();
                if (!types.containsKey(name)) continue;
                if (p.hasField() && p.getField().getType().isJavaLangObject() && ((Descriptors.FieldDescriptor)types.get(name)).getType().equals((Object)Descriptors.FieldDescriptor.Type.STRING)) {
                    this.addStringFormatAnnotation(p);
                }
                props.add(p.withSimpleName(name));
            }
            return new BasicBeanDescription(cfg, type, ac, new ArrayList(props)){};
        }

        private void addStringFormatAnnotation(BeanPropertyDefinition p) {
            JsonFormat annotation = AnnotationHelper.class.getAnnotation(JsonFormat.class);
            p.getField().getAllAnnotations().addIfNotPresent((Annotation)annotation);
        }

        private Map<String, Descriptors.FieldDescriptor> getDescriptorForType(Class<?> type) {
            try {
                Descriptors.Descriptor invoke = (Descriptors.Descriptor)type.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
                HashMap<String, Descriptors.FieldDescriptor> descriptorsForType = new HashMap<String, Descriptors.FieldDescriptor>();
                invoke.getFields().forEach(fieldDescriptor -> {
                    descriptorsForType.put(fieldDescriptor.getName(), (Descriptors.FieldDescriptor)fieldDescriptor);
                    descriptorsForType.put(fieldDescriptor.getJsonName(), (Descriptors.FieldDescriptor)fieldDescriptor);
                });
                return descriptorsForType;
            }
            catch (Exception e) {
                log.error("Error getting protobuf descriptor for swagger.", (Throwable)e);
                return new HashMap<String, Descriptors.FieldDescriptor>();
            }
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING)
        class AnnotationHelper {
            AnnotationHelper() {
            }
        }
    }
}

