/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xylem.types.LambdaType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;

public class FunctionCallValueIsFunctionReturningLambdaEvaluator
extends PartialEvaluator {
    public static String generateIntermediateIdentifier() {
        return OptimizerUtilities.generateIntermediateIdentifier("fcwl");
    }

    private static FunctionCallInstruction getSpecializedFunction(Function function, FunctionCallInstruction functionCallInstruction, Instruction[] instructionArray, int[] nArray, BindingEnvironment bindingEnvironment, TypeEnvironment typeEnvironment, PartialInformationCollector partialInformationCollector) {
        Object object;
        int n;
        ValueSpecializedDerivative valueSpecializedDerivative = new ValueSpecializedDerivative(bindingEnvironment, instructionArray, nArray);
        Function function2 = function.lookupDerivative(valueSpecializedDerivative);
        Module module = function.getTypeEnvironment().getModule();
        String string = FunctionCallValueIsFunctionReturningLambdaEvaluator.generateIntermediateIdentifier();
        Instruction instruction = function.getBody().cloneWithoutTypeInformation();
        int n2 = function.m_parameters.length - valueSpecializedDerivative.m_args.length;
        TreeSet treeSet = new TreeSet();
        for (n = 0; n < valueSpecializedDerivative.m_args.length; ++n) {
            valueSpecializedDerivative.m_args[n].accumulateFreeBindings(treeSet, bindingEnvironment);
        }
        Binding[] bindingArray = new Binding[n2 += treeSet.size()];
        Instruction[] instructionArray2 = new Instruction[n2];
        int n3 = 0;
        int n4 = -1;
        Iterator iterator = treeSet.iterator();
        HashMap<Object, IdentifierInstruction> hashMap = new HashMap<Object, IdentifierInstruction>();
        while (iterator.hasNext()) {
            IBinding iBinding = (IBinding)iterator.next();
            hashMap.put(iBinding.getName(), new IdentifierInstruction(ReductionHelper.generateIntermediateIdentifier2()));
        }
        for (n = 0; n < valueSpecializedDerivative.m_args.length; ++n) {
            for (int i = n4 + 1; i < valueSpecializedDerivative.m_position[n]; ++i) {
                object = function.m_parameters[i];
                bindingArray[n3] = new Binding(((Binding)object).getName(), ((Binding)object).getBindingType());
                instructionArray2[n3] = functionCallInstruction.getParameters()[i];
                if (treeSet.contains(bindingArray[n3])) {
                    return null;
                }
                ++n3;
            }
            n4 = valueSpecializedDerivative.m_position[n];
            instruction = new LetInstruction(function.m_parameters[valueSpecializedDerivative.m_position[n]].getName(), valueSpecializedDerivative.m_args[n].assignNewNames(hashMap), instruction);
            if (!treeSet.contains(function.m_parameters[valueSpecializedDerivative.m_position[n]])) continue;
            return null;
        }
        for (int i = n4 + 1; i < functionCallInstruction.getParameterCount(); ++i) {
            object = function.m_parameters[i];
            bindingArray[n3] = new Binding(((Binding)object).getName(), ((Binding)object).getBindingType());
            instructionArray2[n3] = functionCallInstruction.getParameters()[i];
            if (treeSet.contains(bindingArray[n3])) {
                return null;
            }
            ++n3;
        }
        for (IBinding iBinding : treeSet) {
            object = (Instruction)hashMap.get(iBinding.getName());
            if (object instanceof IdentifierInstruction) {
                bindingArray[n3] = new Binding(((IdentifierInstruction)object).getVariable(), Binding.resolveBindingType(iBinding, typeEnvironment, bindingEnvironment));
                instructionArray2[n3] = object;
                ++n3;
            }
            if (null != Binding.resolveBindingType(iBinding, typeEnvironment, bindingEnvironment)) continue;
            System.out.println("ERROR ERROR ERROR ERROR ERROR No type!!!");
        }
        if (function2 == null) {
            function2 = new Function(function.generateNewFixupName(), bindingArray, instruction);
            function2.setMemoizeResult(function.getMemoizeResult());
            function2.m_comment = function.getComment();
            function2.setConstraints(function.getConstraints());
            function2.m_resolvedConstraintTypes = new HashMap(function.m_resolvedConstraintTypes);
            module.addFunction(function2);
            function.registerDerivative(valueSpecializedDerivative, function2);
        } else {
            int n5 = 23;
        }
        FunctionCallInstruction functionCallInstruction2 = new FunctionCallInstruction(function2.getName(), instructionArray2);
        return functionCallInstruction2;
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        Object object;
        FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
        TypeEnvironment typeEnvironment = letChainManager.getCurrentFunction().getTypeEnvironment();
        BindingEnvironment bindingEnvironment = letChainManager.getCurrentFunction().getBindingEnvironment();
        Function function = typeEnvironment.getModule().getFunction(functionCallInstruction.getFunction());
        Binding[] bindingArray = function.getParameters();
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        for (int i = 0; i < bindingArray.length; ++i) {
            if (!(bindingArray[i].getBindingType() instanceof LambdaType) || bindingArray[i].getName().equals("__prefixmapping__")) continue;
            partialInformationCollector.partiallyEvaluate(functionCallInstruction.getParameters()[i], letChainManager);
            object = letChainManager.lookupBinding(functionCallInstruction.getParameters()[i]);
            if (!(object instanceof LambdaInstruction)) continue;
            linkedList.add((int[])object);
            linkedList2.add(new Integer(i));
        }
        if (linkedList.size() > 0) {
            Instruction[] instructionArray = new Instruction[linkedList.size()];
            object = new int[linkedList.size()];
            linkedList.toArray(instructionArray);
            for (int i = 0; i < linkedList.size(); ++i) {
                object[i] = (Integer)linkedList2.get(i);
            }
            FunctionCallInstruction functionCallInstruction2 = FunctionCallValueIsFunctionReturningLambdaEvaluator.getSpecializedFunction(function, functionCallInstruction, instructionArray, object, bindingEnvironment, typeEnvironment, partialInformationCollector);
            if (null == functionCallInstruction2) {
                return PartialEvaluationResult.s_emptyResult;
            }
            return new PartialEvaluationResult((Instruction)functionCallInstruction2, true);
        }
        return PartialEvaluationResult.s_emptyResult;
    }

    static final class ValueSpecializedDerivative {
        BindingEnvironment m_benv;
        Instruction[] m_args;
        int[] m_position;

        ValueSpecializedDerivative(BindingEnvironment bindingEnvironment, Instruction instruction, int n) {
            this.m_benv = bindingEnvironment;
            this.m_args = new Instruction[]{instruction};
            this.m_position = new int[]{n};
        }

        ValueSpecializedDerivative(BindingEnvironment bindingEnvironment, Instruction[] instructionArray, int[] nArray) {
            this.m_benv = bindingEnvironment;
            this.m_args = instructionArray;
            this.m_position = nArray;
        }

        public String toString() {
            String string = "(ValueSpecializedDerivative ";
            for (int i = 0; i < this.m_args.length; ++i) {
                if (i != 0) {
                    string = string + ", ";
                }
                string = string + "(" + this.m_position[i] + ": " + this.m_args[i].toString() + ")";
            }
            string = string + ")";
            return string;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.m_args.length; ++i) {
                n += 2 * i * this.m_args[i].hashCode() + 3 * i * this.m_position[i];
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ValueSpecializedDerivative)) {
                return false;
            }
            ValueSpecializedDerivative valueSpecializedDerivative = (ValueSpecializedDerivative)object;
            Instruction[] instructionArray = valueSpecializedDerivative.m_args;
            int[] nArray = valueSpecializedDerivative.m_position;
            if (instructionArray.length != this.m_args.length) {
                return false;
            }
            for (int i = 0; i < this.m_args.length; ++i) {
                if (this.m_position[i] != nArray[i]) {
                    return false;
                }
                if (this.m_args[i].equals(instructionArray[i])) continue;
                return false;
            }
            return true;
        }
    }
}

