/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PartialEvaluator {
    protected static final Logger s_logger = Logger.getInstance(Optimizer.class);

    public abstract PartialEvaluationResult extractPartialInformation(Instruction var1, PartialInformationCollector var2, LetInstruction var3, LetChainManager var4);

    public Class[] getSupportedInstructionClasses() {
        return new Class[0];
    }

    public static final Object extractLiteralValue(PartialInformationCollector partialInformationCollector, Instruction instruction, LetChainManager letChainManager) {
        if (instruction == null) {
            return null;
        }
        if (instruction instanceof LiteralInstruction) {
            return ((LiteralInstruction)instruction).getValue();
        }
        if (instruction instanceof IdentifierInstruction) {
            return PartialEvaluator.extractLiteralValue(partialInformationCollector, letChainManager.lookupBinding(instruction), letChainManager);
        }
        return null;
    }

    public static final Integer extractIntegerValue(PartialInformationCollector partialInformationCollector, Instruction instruction, LetChainManager letChainManager) {
        Object object = PartialEvaluator.extractLiteralValue(partialInformationCollector, instruction, letChainManager);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return null;
    }

    public static final Object[] extractStreamOfLiteralsValue(PartialInformationCollector partialInformationCollector, Instruction instruction, LetChainManager letChainManager) {
        if (instruction == null) {
            return null;
        }
        if (instruction instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            int n = streamInstruction.getChildInstructionCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                Instruction instruction2 = streamInstruction.getChildInstruction(i);
                if (!(instruction2 instanceof LiteralInstruction)) {
                    return null;
                }
                objectArray[i] = ((LiteralInstruction)instruction2).getValue();
            }
            return objectArray;
        }
        if (instruction instanceof IdentifierInstruction) {
            return PartialEvaluator.extractStreamOfLiteralsValue(partialInformationCollector, letChainManager.lookupBinding(instruction), letChainManager);
        }
        return null;
    }

    public static final LiteralInstruction.KnownValue extractKnownValue(PartialInformationCollector partialInformationCollector, Instruction instruction, LetChainManager letChainManager) {
        if (instruction == null) {
            return null;
        }
        if (instruction instanceof LiteralInstruction) {
            return new LiteralInstruction.KnownValue(((LiteralInstruction)instruction).getValue());
        }
        if (instruction instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            int n = streamInstruction.getChildInstructionCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                Instruction instruction2 = streamInstruction.getChildInstruction(i);
                if (!(instruction2 instanceof LiteralInstruction)) {
                    return null;
                }
                objectArray[i] = ((LiteralInstruction)instruction2).getValue();
            }
            return new LiteralInstruction.KnownValue(objectArray);
        }
        if (instruction instanceof IdentifierInstruction) {
            return PartialEvaluator.extractKnownValue(partialInformationCollector, letChainManager.lookupBinding(instruction), letChainManager);
        }
        return null;
    }

    public static final Iterator accumulateStream(StreamInstruction streamInstruction, PartialInformationCollector partialInformationCollector, LetChainManager letChainManager) {
        AccumulatedStreamIterator accumulatedStreamIterator = new AccumulatedStreamIterator();
        PartialEvaluator.accumulateStreamInner(streamInstruction, accumulatedStreamIterator.m_list, partialInformationCollector, letChainManager);
        return accumulatedStreamIterator;
    }

    private static final void accumulateStreamInner(StreamInstruction streamInstruction, List list, PartialInformationCollector partialInformationCollector, LetChainManager letChainManager) {
        if (streamInstruction.isStoredAsString()) {
            String string = streamInstruction.getStringContent();
            if (string.length() > 0) {
                list.add(string);
            }
        } else {
            int n = streamInstruction.getChildInstructionCount();
            for (int i = 0; i < n; ++i) {
                Instruction instruction = streamInstruction.getChildInstruction(i);
                partialInformationCollector.partiallyEvaluate(instruction, letChainManager);
                Instruction instruction2 = letChainManager.lookupBinding(instruction);
                if (instruction2 instanceof StreamInstruction) {
                    PartialEvaluator.accumulateStreamInner((StreamInstruction)instruction2, list, partialInformationCollector, letChainManager);
                    continue;
                }
                list.add(NavigationUtilities.resolveIdentifierAliases(instruction, partialInformationCollector.getCurrentBindingEnvironment()));
            }
        }
    }

    public static final void accumulateStream(StreamInstruction streamInstruction, List list, PartialInformationCollector partialInformationCollector, LetChainManager letChainManager) {
        int n = streamInstruction.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            Instruction instruction = streamInstruction.getChildInstruction(i);
            partialInformationCollector.partiallyEvaluate(instruction, letChainManager);
            Instruction instruction2 = letChainManager.lookupBinding(instruction);
            if (instruction2 instanceof StreamInstruction) {
                PartialEvaluator.accumulateStream((StreamInstruction)instruction2, list, partialInformationCollector, letChainManager);
                continue;
            }
            list.add(NavigationUtilities.resolveIdentifierAliases(instruction, partialInformationCollector.getCurrentBindingEnvironment()));
        }
    }

    public static final Instruction moveToBottom(Instruction instruction, Object object, Instruction instruction2) {
        return PartialEvaluator.moveToBottom(instruction, object, instruction2, null);
    }

    public static final Instruction moveToBottom(Instruction instruction, Object object, Instruction instruction2, BindingEnvironment bindingEnvironment) {
        LetInstruction letInstruction;
        Instruction instruction3 = instruction;
        LetInstruction letInstruction2 = null;
        while (instruction3 instanceof LetInstruction) {
            letInstruction2 = (LetInstruction)instruction3;
            instruction3 = letInstruction2.getBody();
        }
        if (letInstruction2 != null) {
            letInstruction = new LetInstruction(object, instruction3, instruction2);
            letInstruction2.setBody(letInstruction);
            instruction2 = instruction;
        } else {
            letInstruction = new LetInstruction(object, instruction3, instruction2);
            instruction2 = letInstruction;
        }
        if (bindingEnvironment != null) {
            bindingEnvironment.setVariableBinding(letInstruction);
        }
        return instruction2;
    }

    private static final class AccumulatedStreamIterator
    implements Iterator {
        ArrayList m_list = new ArrayList();
        String m_subPartStream;
        int m_part = 0;
        int m_subPart = 0;

        private AccumulatedStreamIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.m_part < this.m_list.size() || this.m_subPartStream != null && this.m_subPart < this.m_subPartStream.length();
        }

        public Object next() {
            Object e;
            if (this.m_subPartStream != null) {
                if (this.m_subPart < this.m_subPartStream.length()) {
                    return LiteralInstruction.charLiteral(this.m_subPartStream.charAt(this.m_subPart++));
                }
                this.m_subPartStream = null;
            }
            if ((e = this.m_list.get(this.m_part++)) instanceof String) {
                this.m_subPartStream = (String)e;
                this.m_subPart = 1;
                return LiteralInstruction.charLiteral(this.m_subPartStream.charAt(0));
            }
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

