/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.resolver.tools;

import com.ibm.xml.resolver.Catalog;
import com.ibm.xml.resolver.CatalogManager;
import com.ibm.xml.resolver.tools.CatalogResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class ResolvingXMLFilter
extends XMLFilterImpl {
    public static boolean suppressExplanation = false;
    private CatalogManager catalogManager = CatalogManager.getStaticManager();
    private CatalogResolver catalogResolver = null;
    private CatalogResolver piCatalogResolver = null;
    private boolean allowXMLCatalogPI = false;
    private boolean oasisXMLCatalogPI = false;
    private URL baseURL = null;

    public ResolvingXMLFilter() {
        this.catalogResolver = new CatalogResolver(this.catalogManager);
    }

    public ResolvingXMLFilter(XMLReader xMLReader) {
        super(xMLReader);
        this.catalogResolver = new CatalogResolver(this.catalogManager);
    }

    public ResolvingXMLFilter(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.catalogResolver = new CatalogResolver(this.catalogManager);
    }

    public ResolvingXMLFilter(XMLReader xMLReader, CatalogManager catalogManager) {
        super(xMLReader);
        this.catalogManager = catalogManager;
        this.catalogResolver = new CatalogResolver(this.catalogManager);
    }

    public Catalog getCatalog() {
        return this.catalogResolver.getCatalog();
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.allowXMLCatalogPI = true;
        this.setupBaseURI(inputSource.getSystemId());
        try {
            super.parse(inputSource);
        }
        catch (InternalError internalError) {
            this.explain(inputSource.getSystemId());
            throw internalError;
        }
    }

    public void parse(String string) throws IOException, SAXException {
        this.allowXMLCatalogPI = true;
        this.setupBaseURI(string);
        try {
            super.parse(string);
        }
        catch (InternalError internalError) {
            this.explain(string);
            throw internalError;
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        this.allowXMLCatalogPI = false;
        String string3 = this.catalogResolver.getResolvedEntity(string, string2);
        if (string3 == null && this.piCatalogResolver != null) {
            string3 = this.piCatalogResolver.getResolvedEntity(string, string2);
        }
        if (string3 != null) {
            try {
                InputSource inputSource = new InputSource(string3);
                inputSource.setPublicId(string);
                URL uRL = new URL(string3);
                InputStream inputStream = uRL.openStream();
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                this.catalogManager.debug.message(1, "Failed to create InputSource", string3);
                return null;
            }
        }
        return null;
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.allowXMLCatalogPI = false;
        super.notationDecl(string, string2, string3);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.allowXMLCatalogPI = false;
        super.unparsedEntityDecl(string, string2, string3, string4);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.allowXMLCatalogPI = false;
        super.startElement(string, string2, string3, attributes);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string.equals("oasis-xml-catalog")) {
            URL uRL = null;
            String string3 = string2;
            int n = string3.indexOf("catalog=");
            if (n >= 0 && (string3 = string3.substring(n + 8)).length() > 1) {
                String string4 = string3.substring(0, 1);
                n = (string3 = string3.substring(1)).indexOf(string4);
                if (n >= 0) {
                    string3 = string3.substring(0, n);
                    try {
                        uRL = this.baseURL != null ? new URL(this.baseURL, string3) : new URL(string3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (this.allowXMLCatalogPI) {
                if (this.catalogManager.allowOasisXMLCatalogPI()) {
                    this.catalogManager.debug.message(4, "oasis-xml-catalog PI", string2);
                    if (uRL != null) {
                        try {
                            this.catalogManager.debug.message(4, "oasis-xml-catalog", uRL.toString());
                            this.oasisXMLCatalogPI = true;
                            if (this.piCatalogResolver == null) {
                                this.piCatalogResolver = new CatalogResolver(true);
                            }
                            this.piCatalogResolver.getCatalog().parseCatalog(uRL.toString());
                        }
                        catch (Exception exception) {
                            this.catalogManager.debug.message(3, "Exception parsing oasis-xml-catalog: " + uRL.toString());
                        }
                    } else {
                        this.catalogManager.debug.message(3, "PI oasis-xml-catalog unparseable: " + string2);
                    }
                } else {
                    this.catalogManager.debug.message(4, "PI oasis-xml-catalog ignored: " + string2);
                }
            } else {
                this.catalogManager.debug.message(3, "PI oasis-xml-catalog occurred in an invalid place: " + string2);
            }
        } else {
            super.processingInstruction(string, string2);
        }
    }

    private void setupBaseURI(String string) {
        String string2 = System.getProperty("user.dir");
        URL uRL = null;
        string2.replace('\\', '/');
        try {
            uRL = new URL("file:///" + string2 + "/basename");
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        try {
            this.baseURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL != null) {
                try {
                    this.baseURL = new URL(uRL, string);
                }
                catch (MalformedURLException malformedURLException2) {
                    this.baseURL = null;
                }
            }
            this.baseURL = null;
        }
    }

    private void explain(String string) {
        if (!suppressExplanation) {
            System.out.println("XMLReader probably encountered bad URI in " + string);
            System.out.println("For example, replace '/some/uri' with 'file:/some/uri'.");
        }
        suppressExplanation = true;
    }
}

