/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.instructions.BeginInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.TryCatchInstruction;

public class CodeGenerationOptUtils {
    public static final int LEN_UNKNOWN = -1;

    public static int getStreamLength(Instruction instruction, BindingEnvironment bindingEnvironment) {
        int n = 0;
        if (instruction instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            int n2 = streamInstruction.getChildInstructionCount();
            for (int i = 0; i < n2; ++i) {
                Instruction instruction2 = streamInstruction.getChildInstruction(i);
                int n3 = CodeGenerationOptUtils.numberOfElements(instruction2, bindingEnvironment);
                if (n3 == -1) {
                    return -1;
                }
                n += n3;
            }
            return n;
        }
        if (instruction instanceof IdentifierInstruction) {
            Object object;
            IBinding iBinding;
            LetInstruction letInstruction;
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            BindingEnvironment bindingEnvironment2 = identifierInstruction.getBindingEnvironment();
            if (bindingEnvironment2 == null) {
                bindingEnvironment2 = bindingEnvironment;
            }
            if ((letInstruction = (iBinding = bindingEnvironment2.getVariableBinding(object = identifierInstruction.getVariable())).getLet()) != null) {
                Instruction instruction3 = letInstruction.getValue();
                return CodeGenerationOptUtils.getStreamLength(instruction3, bindingEnvironment);
            }
        } else if (instruction instanceof BeginInstruction) {
            BeginInstruction beginInstruction = (BeginInstruction)instruction;
            int n4 = beginInstruction.getChildInstructionCount();
            if (n4 >= 0) {
                Instruction instruction4 = beginInstruction.getChildInstruction(n4 - 1);
                return CodeGenerationOptUtils.getStreamLength(instruction4, bindingEnvironment);
            }
        } else if (instruction instanceof TryCatchInstruction) {
            TryCatchInstruction tryCatchInstruction = (TryCatchInstruction)instruction;
            Instruction instruction5 = tryCatchInstruction.getBody();
            return CodeGenerationOptUtils.getStreamLength(instruction5, bindingEnvironment);
        }
        return -1;
    }

    private static int numberOfElements(Instruction instruction, BindingEnvironment bindingEnvironment) {
        if (instruction instanceof LiteralInstruction) {
            return 1;
        }
        return CodeGenerationOptUtils.getStreamLength(instruction, bindingEnvironment);
    }
}

