/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.fast_hdfs_resource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    private String source;
    private String target;
    private String type;
    private String action;
    private String owner;
    private String group;
    private String mode;
    private boolean recursiveChown;
    private boolean recursiveChmod;
    private boolean changePermissionforParents;
    private boolean manageIfExists;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean isRecursiveChown() {
        return this.recursiveChown;
    }

    public void setRecursiveChown(boolean recursiveChown) {
        this.recursiveChown = recursiveChown;
    }

    public boolean isRecursiveChmod() {
        return this.recursiveChmod;
    }

    public void setRecursiveChmod(boolean recursiveChmod) {
        this.recursiveChmod = recursiveChmod;
    }

    public boolean isChangePermissionOnParents() {
        return this.changePermissionforParents;
    }

    public void setChangePermissionOnParents(boolean changePermissionforParents) {
        this.changePermissionforParents = changePermissionforParents;
    }

    public boolean isManageIfExists() {
        return this.manageIfExists;
    }

    public void setManageIfExists(boolean manageIfExists) {
        this.manageIfExists = manageIfExists;
    }

    public String toString() {
        return "Resource [source=" + this.source + ", target=" + this.target + ", type=" + this.type + ", action=" + this.action + ", owner=" + this.owner + ", group=" + this.group + ", mode=" + this.mode + ", recursiveChown=" + this.recursiveChown + ", recursiveChmod=" + this.recursiveChmod + ", changePermissionforParents=" + this.changePermissionforParents + ", manageIfExists=" + this.manageIfExists + "]";
    }

    public static void checkResourceParameters(Resource resource, FileSystem dfs) throws IllegalArgumentException, IOException {
        ArrayList<String> actionsAvailable = new ArrayList<String>();
        actionsAvailable.add("create");
        actionsAvailable.add("delete");
        actionsAvailable.add("download");
        ArrayList<String> typesAvailable = new ArrayList<String>();
        typesAvailable.add("file");
        typesAvailable.add("directory");
        if (resource.getAction() == null || !actionsAvailable.contains(resource.getAction())) {
            throw new IllegalArgumentException("Action is not supported.");
        }
        String dfsPath = resource.getTarget();
        String localPath = resource.getSource();
        if (resource.getAction().equals("download")) {
            dfsPath = resource.getSource();
            localPath = resource.getTarget();
        }
        if (dfsPath == null) {
            throw new IllegalArgumentException("Path to resource in HadoopFs must be filled.");
        }
        if (resource.getType() == null || !typesAvailable.contains(resource.getType())) {
            throw new IllegalArgumentException("Type is not supported.");
        }
        if (dfs.isFile(new Path(dfsPath)) && !"file".equals(resource.getType())) {
            throw new IllegalArgumentException("Cannot create a directory " + dfsPath + " because file is present on the given path.");
        }
        if (dfs.isDirectory(new Path(dfsPath)) && !"directory".equals(resource.getType())) {
            throw new IllegalArgumentException("Cannot create a file " + dfsPath + " because directory is present on the given path.");
        }
        if (localPath != null) {
            File local = new File(localPath);
            if (local.isFile() && !"file".equals(resource.getType())) {
                throw new IllegalArgumentException("Cannot create a directory " + dfsPath + " because source " + localPath + "is a file");
            }
            if (local.isDirectory() && !"directory".equals(resource.getType())) {
                throw new IllegalArgumentException("Cannot create a file " + dfsPath + " because source " + localPath + "is a directory");
            }
        }
    }

    public static void createResource(Resource resource, FileSystem dfs, Path pathHadoop) throws IOException {
        boolean isCreate;
        boolean bl = isCreate = resource.getSource() == null;
        if (isCreate && resource.getType().equals("directory")) {
            dfs.mkdirs(pathHadoop);
        } else if (isCreate && resource.getType().equals("file")) {
            dfs.createNewFile(pathHadoop);
        } else if (dfs.exists(pathHadoop) && dfs.getFileStatus(pathHadoop).isDir()) {
            System.out.println("Skipping copy from local, as target " + pathHadoop + " is an existing directory.");
        } else {
            dfs.copyFromLocalFile(new Path(resource.getSource()), pathHadoop);
        }
    }

    public static void setMode(Resource resource, FileSystem dfs, Path pathHadoop) throws IOException {
        if (resource.getMode() != null) {
            FsPermission permission = new FsPermission((short)Integer.parseInt(resource.getMode(), 8));
            dfs.setPermission(pathHadoop, permission);
            HashSet<String> resultSet = new HashSet<String>();
            if (resource.isRecursiveChmod()) {
                resource.fillDirectoryList(dfs, resource.getTarget(), resultSet);
            }
            if (resource.isChangePermissionOnParents()) {
                resource.fillInParentDirectories(dfs, resource.getTarget(), resultSet);
            }
            for (String path : resultSet) {
                dfs.setPermission(new Path(path), permission);
            }
        }
    }

    public static void setOwner(Resource resource, FileSystem dfs, Path pathHadoop) throws IOException {
        if (resource.getOwner() != null || resource.getGroup() != null) {
            dfs.setOwner(pathHadoop, resource.getOwner(), resource.getGroup());
            HashSet<String> resultSet = new HashSet<String>();
            if (resource.isRecursiveChown()) {
                resource.fillDirectoryList(dfs, resource.getTarget(), resultSet);
            }
            if (resource.isChangePermissionOnParents()) {
                resource.fillInParentDirectories(dfs, resource.getTarget(), resultSet);
            }
            for (String path : resultSet) {
                dfs.setOwner(new Path(path), resource.getOwner(), resource.getGroup());
            }
        }
    }

    public void fillInParentDirectories(FileSystem dfs, String path, HashSet<String> resultSet) throws IOException {
        Path filePath = new Path(path);
        while ((filePath = filePath.getParent()).getParent() != null) {
            resultSet.add(filePath.toString());
        }
    }

    public void fillDirectoryList(FileSystem dfs, String path, HashSet<String> resultSet) throws IOException {
        FileStatus[] fileStatus = dfs.listStatus(new Path(path));
        if (fileStatus != null) {
            for (FileStatus fs : fileStatus) {
                String pathToResource = path + "/" + fs.getPath().getName();
                resultSet.add(pathToResource);
                if (!fs.isDir()) continue;
                this.fillDirectoryList(dfs, pathToResource, resultSet);
            }
        }
    }
}

