/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.dtm.ref;

import com.ibm.xtq.xml.dtm.DTM;
import com.ibm.xtq.xml.dtm.DTMDOMException;
import com.ibm.xtq.xml.dtm.ref.DTMChildIterNodeList;
import com.ibm.xtq.xml.dtm.ref.DTMNamedNodeMap;
import com.ibm.xtq.xml.xdm.XDMCursor;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class DTMNodeProxy
implements Node,
Document,
Text,
Element,
Attr,
ProcessingInstruction,
Comment,
DocumentFragment {
    public DTM dtm;
    int node;
    XDMCursor m_cursor;
    String xmlVersion;
    boolean xmlStandalone;
    private static final String EMPTYSTRING = "";
    static final DOMImplementation implementation = new DTMNodeProxyImplementation();

    public DTMNodeProxy(DTM dTM, int n) {
        this.dtm = dTM;
        this.node = n;
    }

    public final DTM getDTM() {
        return this.dtm;
    }

    public final int getDTMNodeNumber() {
        return this.node;
    }

    public final boolean equals(Node node) {
        try {
            DTMNodeProxy dTMNodeProxy = (DTMNodeProxy)node;
            return dTMNodeProxy.node == this.node && dTMNodeProxy.dtm == this.dtm;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean equals(Object object) {
        try {
            return this.equals((Node)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean sameNodeAs(Node node) {
        if (!(node instanceof DTMNodeProxy)) {
            return false;
        }
        DTMNodeProxy dTMNodeProxy = (DTMNodeProxy)node;
        return this.dtm == dTMNodeProxy.dtm && this.node == dTMNodeProxy.node;
    }

    @Override
    public final String getNodeName() {
        if (this.dtm.getNodeType(this.node) == 13) {
            String string = this.dtm.getNodeName(this.node);
            if ("xmlns".equals(string)) {
                return string;
            }
            return "xmlns:" + string;
        }
        return this.dtm.getNodeName(this.node);
    }

    @Override
    public final String getTarget() {
        return this.dtm.getNodeName(this.node);
    }

    @Override
    public final String getLocalName() {
        return this.dtm.getLocalName(this.node);
    }

    @Override
    public final String getPrefix() {
        if (this.dtm.getNodeType(this.node) == 13) {
            String string = this.dtm.getNodeName(this.node);
            if ("xmlns".equals(string)) {
                return EMPTYSTRING;
            }
            return "xmlns";
        }
        return this.dtm.getPrefix(this.node);
    }

    @Override
    public final void setPrefix(String string) throws DOMException {
        throw new DTMDOMException(7);
    }

    @Override
    public final String getNamespaceURI() {
        return this.dtm.getNamespaceURI(this.node);
    }

    public final boolean supports(String string, String string2) {
        return implementation.hasFeature(string, string2);
    }

    @Override
    public final boolean isSupported(String string, String string2) {
        return implementation.hasFeature(string, string2);
    }

    @Override
    public final String getNodeValue() throws DOMException {
        return this.dtm.getNodeValue(this.node);
    }

    public final String getStringValue() throws DOMException {
        return ((Object)this.dtm.getStringValue(this.node)).toString();
    }

    @Override
    public final void setNodeValue(String string) throws DOMException {
        throw new DTMDOMException(7);
    }

    @Override
    public final short getNodeType() {
        int n = this.dtm.getNodeType(this.node);
        if (n == 13) {
            return 2;
        }
        return (short)n;
    }

    @Override
    public final Node getParentNode() {
        if (this.getNodeType() == 2) {
            return null;
        }
        int n = this.dtm.getParent(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    public final Node getOwnerNode() {
        int n = this.dtm.getParent(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    @Override
    public final NodeList getChildNodes() {
        return new DTMChildIterNodeList(this.dtm, this.node);
    }

    @Override
    public final Node getFirstChild() {
        int n = this.dtm.getFirstChild(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    @Override
    public final Node getLastChild() {
        int n = this.dtm.getLastChild(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    @Override
    public final Node getPreviousSibling() {
        if (this.getNodeType() == 2) {
            return null;
        }
        int n = this.dtm.getPreviousSibling(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    @Override
    public final Node getNextSibling() {
        if (this.getNodeType() == 2) {
            return null;
        }
        int n = this.dtm.getNextSibling(this.node);
        return n == -1 ? null : this.dtm.getNode(n);
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return new DTMNamedNodeMap(this.dtm, this.node);
    }

    @Override
    public boolean hasAttribute(String string) {
        return -1 != this.dtm.getAttributeNode(this.node, null, string);
    }

    @Override
    public boolean hasAttributeNS(String string, String string2) {
        return -1 != this.dtm.getAttributeNode(this.node, string, string2);
    }

    @Override
    public final Document getOwnerDocument() {
        return (Document)this.dtm.getNode(this.dtm.getOwnerDocument(this.node));
    }

    @Override
    public final Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DTMDOMException(7);
    }

    @Override
    public final Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DTMDOMException(7);
    }

    @Override
    public final Node removeChild(Node node) throws DOMException {
        throw new DTMDOMException(7);
    }

    @Override
    public final Node appendChild(Node node) throws DOMException {
        throw new DTMDOMException(7);
    }

    @Override
    public final boolean hasChildNodes() {
        return -1 != this.dtm.getFirstChild(this.node);
    }

    @Override
    public final Node cloneNode(boolean bl) {
        throw new DTMDOMException(9);
    }

    @Override
    public final DocumentType getDoctype() {
        return null;
    }

    @Override
    public final DOMImplementation getImplementation() {
        return implementation;
    }

    @Override
    public final Element getDocumentElement() {
        int n = this.dtm.getDocument();
        int n2 = -1;
        int n3 = this.dtm.getFirstChild(n);
        while (n3 != -1) {
            switch (this.dtm.getNodeType(n3)) {
                case 1: {
                    if (n2 != -1) {
                        n2 = -1;
                        n3 = this.dtm.getLastChild(n);
                        break;
                    }
                    n2 = n3;
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    n2 = -1;
                    n3 = this.dtm.getLastChild(n);
                }
            }
            n3 = this.dtm.getNextSibling(n3);
        }
        if (n2 == -1) {
            throw new DTMDOMException(9);
        }
        return (Element)this.dtm.getNode(n2);
    }

    @Override
    public final Element createElement(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final DocumentFragment createDocumentFragment() {
        throw new DTMDOMException(9);
    }

    @Override
    public final Text createTextNode(String string) {
        throw new DTMDOMException(9);
    }

    @Override
    public final Comment createComment(String string) {
        throw new DTMDOMException(9);
    }

    @Override
    public final CDATASection createCDATASection(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final Attr createAttribute(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final EntityReference createEntityReference(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final NodeList getElementsByTagName(String string) {
        Vector vector = new Vector();
        Node node = this.dtm.getNode(this.node);
        if (node != null) {
            boolean bl = "*".equals(string);
            if (1 == node.getNodeType()) {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.traverseChildren(vector, nodeList.item(i), string, bl);
                }
            } else if (9 == node.getNodeType()) {
                this.traverseChildren(vector, this.dtm.getNode(this.node), string, bl);
            }
        }
        return new NodeListImpl(vector);
    }

    private final void traverseChildren(Vector vector, Node node, String string, boolean bl) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1 && (bl || node.getNodeName().equals(string))) {
            vector.add(node);
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.traverseChildren(vector, nodeList.item(i), string, bl);
            }
        }
    }

    @Override
    public final Node importNode(Node node, boolean bl) throws DOMException {
        throw new DTMDOMException(7);
    }

    @Override
    public final Element createElementNS(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final Attr createAttributeNS(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final NodeList getElementsByTagNameNS(String string, String string2) {
        Vector vector = new Vector();
        Node node = this.dtm.getNode(this.node);
        if (node != null) {
            boolean bl = "*".equals(string);
            boolean bl2 = "*".equals(string2);
            if (1 == node.getNodeType()) {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.traverseChildren(vector, nodeList.item(i), string, string2, bl, bl2);
                }
            } else if (9 == node.getNodeType()) {
                this.traverseChildren(vector, this.dtm.getNode(this.node), string, string2, bl, bl2);
            }
        }
        return new NodeListImpl(vector);
    }

    private final void traverseChildren(Vector vector, Node node, String string, String string2, boolean bl, boolean bl2) {
        Object object;
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1 && (bl2 || node.getLocalName().equals(string2))) {
            object = node.getNamespaceURI();
            if (string == null && object == null || bl || string != null && string.equals(object)) {
                vector.add(node);
            }
        }
        if (node.hasChildNodes()) {
            object = node.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                this.traverseChildren(vector, object.item(i), string, string2, bl, bl2);
            }
        }
    }

    @Override
    public final Element getElementById(String string) {
        return (Element)this.dtm.getNode(this.dtm.getElementById(string));
    }

    @Override
    public final Text splitText(int n) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final String getData() throws DOMException {
        return this.dtm.getNodeValue(this.node);
    }

    @Override
    public final void setData(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final int getLength() {
        return this.dtm.getNodeValue(this.node).length();
    }

    @Override
    public final String substringData(int n, int n2) throws DOMException {
        return this.getData().substring(n, n + n2);
    }

    @Override
    public final void appendData(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final void insertData(int n, String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final void deleteData(int n, int n2) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final void replaceData(int n, int n2, String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final String getTagName() {
        return this.dtm.getNodeName(this.node);
    }

    @Override
    public final String getAttribute(String string) {
        DTMNamedNodeMap dTMNamedNodeMap = new DTMNamedNodeMap(this.dtm, this.node);
        Node node = dTMNamedNodeMap.getNamedItem(string);
        return null == node ? EMPTYSTRING : node.getNodeValue();
    }

    @Override
    public final void setAttribute(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final void removeAttribute(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final Attr getAttributeNode(String string) {
        DTMNamedNodeMap dTMNamedNodeMap = new DTMNamedNodeMap(this.dtm, this.node);
        return (Attr)dTMNamedNodeMap.getNamedItem(string);
    }

    @Override
    public final Attr setAttributeNode(Attr attr) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final Attr removeAttributeNode(Attr attr) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public boolean hasAttributes() {
        return -1 != this.dtm.getFirstAttribute(this.node);
    }

    @Override
    public final void normalize() {
        throw new DTMDOMException(9);
    }

    @Override
    public final String getAttributeNS(String string, String string2) {
        Node node = null;
        int n = this.dtm.getAttributeNode(this.node, string, string2);
        if (n != -1) {
            node = this.dtm.getNode(n);
        }
        return null == node ? EMPTYSTRING : node.getNodeValue();
    }

    @Override
    public final void setAttributeNS(String string, String string2, String string3) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final void removeAttributeNS(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final Attr getAttributeNodeNS(String string, String string2) {
        Attr attr = null;
        int n = this.dtm.getAttributeNode(this.node, string, string2);
        if (n != -1) {
            attr = (Attr)this.dtm.getNode(n);
        }
        return attr;
    }

    @Override
    public final Attr setAttributeNodeNS(Attr attr) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public final String getName() {
        return this.dtm.getNodeName(this.node);
    }

    @Override
    public final boolean getSpecified() {
        return true;
    }

    @Override
    public final String getValue() {
        return this.dtm.getNodeValue(this.node);
    }

    @Override
    public final void setValue(String string) {
        throw new DTMDOMException(9);
    }

    @Override
    public final Element getOwnerElement() {
        if (this.getNodeType() != 2) {
            return null;
        }
        int n = this.dtm.getParent(this.node);
        return n == -1 ? null : (Element)this.dtm.getNode(n);
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new DTMDOMException(9);
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        throw new DTMDOMException(9);
    }

    @Override
    public String getBaseURI() {
        throw new DTMDOMException(9);
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        if (node instanceof DTMNodeProxy) {
            DTMNodeProxy dTMNodeProxy = (DTMNodeProxy)node;
            int n = this.dtm.getDocument() - dTMNodeProxy.dtm.getDocument();
            if (n != 0) {
                return 1;
            }
            short s = (short)(this.node - dTMNodeProxy.node);
            if (s < 0) {
                return 4;
            }
            if (s > 0) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    @Override
    public String getTextContent() throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public void setTextContent(String string) throws DOMException {
    }

    @Override
    public boolean isSameNode(Node node) {
        if (node instanceof DTMNodeProxy) {
            DTMNodeProxy dTMNodeProxy = (DTMNodeProxy)node;
            if (this.dtm._document() == dTMNodeProxy.dtm._document()) {
                return dTMNodeProxy.node == this.node;
            }
            return false;
        }
        return node.isSameNode(this);
    }

    @Override
    public String lookupPrefix(String string) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String string) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node node) {
        return this == node;
    }

    @Override
    public Object getFeature(String string, String string2) {
        return null;
    }

    @Override
    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return this.getOwnerDocument().setUserData(string, object, userDataHandler);
    }

    @Override
    public Object getUserData(String string) {
        return this.getOwnerDocument().getUserData(string);
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        this.xmlStandalone = bl;
    }

    @Override
    public String getXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
        this.xmlVersion = string;
    }

    @Override
    public String getDocumentURI() {
        return null;
    }

    @Override
    public void setDocumentURI(String string) {
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public Node renameNode(Node node, String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    @Override
    public boolean isElementContentWhitespace() {
        return false;
    }

    @Override
    public String getWholeText() {
        if (this.dtm.getNodeType(this.node) != 3) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getNodeValue());
        int n = this.node;
        while (this.dtm.getNodeType(--n) == 3) {
            stringBuffer.insert(0, this.dtm.getNodeValue(n));
        }
        n = this.node;
        while (this.dtm.getNodeType(++n) == 3) {
            stringBuffer.append(this.dtm.getNodeValue(n));
        }
        return stringBuffer.toString();
    }

    @Override
    public Text replaceWholeText(String string) throws DOMException {
        throw new DTMDOMException(7);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public void setIdAttribute(String string, boolean bl) throws DOMException {
    }

    @Override
    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
    }

    @Override
    public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
    }

    @Override
    public boolean isId() {
        return false;
    }

    static class DTMNodeProxyImplementation
    implements DOMImplementation {
        DTMNodeProxyImplementation() {
        }

        @Override
        public DocumentType createDocumentType(String string, String string2, String string3) {
            throw new DTMDOMException(9);
        }

        @Override
        public Document createDocument(String string, String string2, DocumentType documentType) {
            throw new DTMDOMException(9);
        }

        @Override
        public boolean hasFeature(String string, String string2) {
            return !(!"CORE".equals(string.toUpperCase()) && !"XML".equals(string.toUpperCase()) || !"1.0".equals(string2) && !"2.0".equals(string2));
        }

        @Override
        public Object getFeature(String string, String string2) {
            return null;
        }
    }

    private static class NodeListImpl
    implements NodeList {
        private Vector m_list;

        NodeListImpl(Vector vector) {
            this.m_list = vector;
        }

        @Override
        public int getLength() {
            return this.m_list.size();
        }

        @Override
        public Node item(int n) {
            if (n >= 0 && n < this.m_list.size()) {
                return (Node)this.m_list.elementAt(n);
            }
            return null;
        }
    }
}

