/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionInstantiation;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.ClosureGenerationUtilities;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.ApplyInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.interpreter.Closure;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.optimizers.FindFreeVariables;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.TypeVariable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoopInstruction
extends Instruction
implements ISpecialForm,
IBinding {
    protected Binding[] m_parameters;
    protected Instruction[] m_initialValues;
    protected Instruction m_body;
    protected Object m_name;
    protected LambdaType m_bindingType;
    protected boolean m_isPure = true;

    public LoopInstruction() {
    }

    public LoopInstruction(Object object, Instruction instruction, Binding[] bindingArray, Instruction[] instructionArray, boolean bl) {
        this.init(object, instruction, bindingArray, instructionArray, new TypeVariable(), bl);
    }

    public LoopInstruction(Object object, Instruction instruction, Binding[] bindingArray, Instruction[] instructionArray, Type type, boolean bl) {
        this.init(object, instruction, bindingArray, instructionArray, type, bl);
    }

    private void init(Object object, Instruction instruction, Binding[] bindingArray, Instruction[] instructionArray, Type type, boolean bl) {
        this.m_name = object;
        this.m_body = instruction;
        this.m_initialValues = instructionArray;
        this.m_parameters = bindingArray;
        this.m_isPure = bl;
        if (bindingArray != null) {
            this.m_bindingType = new LambdaType(Binding.getTypeArrayFromBindingArray(bindingArray), type, bl);
        }
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_body.getType(typeEnvironment, bindingEnvironment);
    }

    public LambdaType getLambdaType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_initialValues[i].getType(typeEnvironment, bindingEnvironment);
        }
        return new LambdaType(typeArray, this.m_body.getType(typeEnvironment, bindingEnvironment), this.m_isPure);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        Object[] objectArray;
        Object object2;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        BindingEnvironment bindingEnvironment = this.evaluateBindingEnvironment(function);
        Set set = FindFreeVariables.findFreeVariables(this);
        Iterator iterator = set.iterator();
        int n = 0;
        IBinding[] iBindingArray = new IBinding[set.size()];
        Object[] objectArray2 = new Object[set.size()];
        while (iterator.hasNext()) {
            object2 = iterator.next();
            objectArray = bindingEnvironment.getVariableBinding(object2);
            iBindingArray[n] = objectArray;
            objectArray2[n++] = environment.lookupBinding((IBinding)objectArray);
        }
        object2 = new Closure(iBindingArray, objectArray2, function, this.m_body, this.m_parameters, this.m_sourceFilename, this.m_sourceLineNumber);
        environment.bind(this, object2);
        objectArray = new Object[this.m_initialValues.length];
        for (n = 0; n < this.m_initialValues.length; ++n) {
            objectArray[n] = object = this.m_initialValues[n].evaluate(environment, function, iDebuggerInterceptor, false);
        }
        object = ((Closure)object2).evaluate(environment, objectArray, iDebuggerInterceptor);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    protected boolean markApplies(final Object object) {
        final boolean[] blArray = new boolean[]{false};
        new Optimizer(){
            Set m_isTailPosition = new HashSet();
            Set m_skip = new HashSet();

            @Override
            protected Instruction optimizeStep(Instruction instruction, Instruction instruction2, int n) {
                if (this.m_skip.contains(instruction)) {
                    return null;
                }
                if (this.m_isTailPosition.contains(instruction2) && instruction2 instanceof ISpecialForm && ((ISpecialForm)((Object)instruction2)).isChildInstructionInTailPosition(n)) {
                    this.m_isTailPosition.add(instruction);
                }
                if (instruction instanceof ApplyInstruction) {
                    Instruction instruction3 = ((ApplyInstruction)instruction).m_lambda;
                    if (!(instruction3 instanceof IdentifierInstruction)) {
                        blArray[0] = true;
                        return instruction;
                    }
                    if (!((IdentifierInstruction)instruction3).getVariable().equals(LoopInstruction.this.m_name)) {
                        return instruction;
                    }
                    if (this.m_isTailPosition.contains(instruction)) {
                        ((ApplyInstruction)instruction).setTailLoopApply(object, LoopInstruction.this.m_parameters);
                        this.m_skip.add(((ApplyInstruction)instruction).m_lambda);
                        return instruction;
                    }
                    ((ApplyInstruction)instruction).setTailLoopApply(null, null);
                    blArray[0] = true;
                    return null;
                }
                if (instruction instanceof IdentifierInstruction && ((IdentifierInstruction)instruction).getVariable().equals(LoopInstruction.this.m_name)) {
                    blArray[0] = true;
                }
                return instruction;
            }

            @Override
            public Instruction optimize(Instruction instruction) {
                this.m_isTailPosition.add(instruction);
                return super.optimize(instruction);
            }
        }.optimize(this.m_body);
        return blArray[0];
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        codeGenerationTracker.generateFreeBindings(this, dataFlowCodeGenerationHelper);
        boolean bl2 = this.markApplies(this.m_name);
        if (bl2) {
            s_logger.error("***************************IsProblem? " + bl2 + " (" + this.getClass() + ")");
        }
        Type type = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        if (!bl2) {
            String string2;
            dataFlowCodeGenerationHelper.append("// generating LoopInstruction as just loop\n");
            codeGenerationTracker.registerExtantBinding(this, "__should_never_be_used__");
            String[] stringArray = new String[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
                String string3 = this.m_initialValues[i].generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, string, bl);
                dataFlowCodeGenerationHelper.append(this.m_parameters[i].getBindingType().getImplementationName(dataFlowCodeGenerationHelper) + " " + string2 + " = " + string3 + ";\n");
                codeGenerationTracker.registerExtantBinding(this.m_parameters[i], string2);
            }
            String string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
            type.appendHolderVariableDeclaration(dataFlowCodeGenerationHelper, string4, false, null, codeGenerationTracker);
            type.appendFinalHolderVariableDeclaration(dataFlowCodeGenerationHelper, "__tailrecurse_loop_" + this.m_name + "_result__", false, null, codeGenerationTracker);
            dataFlowCodeGenerationHelper.append("__tailrecurse_loop_" + this.m_name + "__:\n" + "while (true) {\n");
            string2 = this.m_body.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, null, false);
            type.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string4, string2, false, null, codeGenerationTracker);
            dataFlowCodeGenerationHelper.append("break; // don't actually loop, unless explicitly 'continue'\n} // end the loop's tail recursion loop for __tailrecurse_loop_" + this.m_name + "__\n");
            return string4;
        }
        String string5 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        LambdaType lambdaType = this.getLambdaType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        Type type2 = lambdaType.getReturnType().resolveType(typeEnvironment);
        String string6 = lambdaType.getImplementationName(dataFlowCodeGenerationHelper);
        StringBuffer stringBuffer = new StringBuffer();
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        FunctionInstantiation.generateParamSpecs(dataFlowCodeGenerationHelper, stringBuffer, codeGenerationTracker2, lambdaType.getElementTypes(), this.m_parameters);
        String string7 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        dataFlowCodeGenerationHelper.append("// generating LoopInstruction normally as lambda\n");
        dataFlowCodeGenerationHelper.append("final " + string6 + "[] " + string7 + " = new " + string6 + "[1];\n");
        codeGenerationTracker.registerExtantBinding(this, string7 + "[0]");
        dataFlowCodeGenerationHelper.append("final " + string6 + " " + string5 + " = new " + string6 + "() {\n" + "public " + type2.getImplementationName(dataFlowCodeGenerationHelper) + " invoke(" + stringBuffer + ") {\n");
        type.appendFinalHolderVariableDeclaration(dataFlowCodeGenerationHelper, "__tailrecurse_loop_" + this.m_name + "_result__", false, null, codeGenerationTracker);
        dataFlowCodeGenerationHelper.append("__tailrecurse_loop_" + this.m_name + "__:\n" + "while (true) {\n");
        HashSet hashSet = new HashSet();
        this.m_body.accumulateNonLiteralFreeBindings(hashSet, codeGenerationTracker.m_bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            hashSet.remove(this.m_parameters[i]);
        }
        String string8 = this.m_body.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker2, null, false);
        dataFlowCodeGenerationHelper.append("return " + string8 + ";\n" + "} // end the loop's tail recursion loop for __tailrecurse_loop_" + this.m_name + "__\n" + "}\n");
        ClosureGenerationUtilities.generateClosureInitSuffix(string6, hashSet, codeGenerationTracker, dataFlowCodeGenerationHelper, true);
        dataFlowCodeGenerationHelper.append(string7 + "[0] = " + string5 + ";\n");
        String string9 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            String string10 = codeGenerationTracker.generateConventionally(this.m_initialValues[i], dataFlowCodeGenerationHelper);
            codeGenerationTracker.resolveType(this.m_initialValues[i]).generateParam(stringBuffer2, dataFlowCodeGenerationHelper, string10, codeGenerationTracker.getCurrentModule());
            if (i >= this.m_parameters.length - 1) continue;
            stringBuffer2.append(", ");
        }
        dataFlowCodeGenerationHelper.appendAssignment(string9, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string5 + ".invoke(" + stringBuffer2.toString() + ")", codeGenerationTracker);
        return string9;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        codeGenerationTracker.generateFreeBindings(this, bCELCodeGenerationHelper, instructionListBuilder, this);
        int[] nArray = new int[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            nArray[i] = codeGenerationTracker.generateConventionallyIntoRegister(this.m_initialValues[i], bCELCodeGenerationHelper, instructionListBuilder);
        }
        InstructionHandle instructionHandle2 = instructionListBuilder.appendNOP();
        boolean bl = this.markApplies(instructionHandle2);
        if (bl) {
            s_logger.error("***************************IsProblem? " + bl + " (" + this.getClass() + ")");
        }
        Type type = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        if (!bl) {
            codeGenerationTracker.registerExtantBinding(this, -2, type.getImplementationType(bCELCodeGenerationHelper));
            for (int i = 0; i < this.m_parameters.length; ++i) {
                codeGenerationTracker.registerExtantBinding(this.m_parameters[i], nArray[i], this.m_parameters[i].getBindingType().getImplementationType(bCELCodeGenerationHelper));
            }
            this.m_body.generateCode(bCELCodeGenerationHelper, codeGenerationTracker, null, null, instructionListBuilder);
            return;
        }
        super.generateCode(bCELCodeGenerationHelper, codeGenerationTracker, string, instructionHandle, instructionListBuilder);
    }

    @Override
    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Object object = iNewNameGenerator.getNewName();
            map.put(this.m_parameters[i].getName(), new IdentifierInstruction(object));
            bindingArray[i] = new Binding(object, this.m_parameters[i].getBindingType(), this);
        }
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_initialValues[i].assignNewNames(map, iNewNameGenerator);
        }
        Object object = iNewNameGenerator.getNewName();
        map.put(this.m_name, new IdentifierInstruction(object));
        return new LoopInstruction(object, this.m_body.assignNewNames(map, iNewNameGenerator), bindingArray, instructionArray, this.m_bindingType.getReturnType(), this.m_isPure);
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_initialValues[i].cloneWithoutTypeInformation();
        }
        LoopInstruction loopInstruction = new LoopInstruction(this.m_name, this.m_body.cloneWithoutTypeInformation(), null, instructionArray, this.m_bindingType.getReturnType(), this.m_isPure);
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), loopInstruction);
        }
        loopInstruction.setParameters(bindingArray, this.m_bindingType.getReturnType(), this.m_isPure);
        return loopInstruction;
    }

    @Override
    public Instruction cloneShallow() {
        Binding[] bindingArray = new Binding[this.m_parameters.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(this.m_parameters[i].getName(), this.m_parameters[i].getBindingType(), this);
        }
        return new LoopInstruction(this.m_name, this.m_body, bindingArray, (Instruction[])this.m_initialValues.clone(), this.m_bindingType.getReturnType(), this.m_isPure);
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction) {
        this.m_body = instruction;
    }

    private void setParameters(Binding[] bindingArray, Type type, boolean bl) {
        this.m_parameters = bindingArray;
        this.m_bindingType = new LambdaType(Binding.getTypeArrayFromBindingArray(bindingArray), type, bl);
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("loop", n);
        prettyPrinter.printIdentifier(this.m_name, n);
        prettyPrinter.print(" (");
        for (int i = 0; i < this.m_parameters.length; ++i) {
            Binding binding = this.m_parameters[i];
            Instruction instruction = this.m_initialValues[i];
            prettyPrinter.printFormOpenIdentifier(binding.getName(), n + 2);
            instruction.toString(prettyPrinter, n + 3);
            prettyPrinter.printFormClose(n + 2);
        }
        prettyPrinter.printFormClose(n);
        this.m_body.toString(prettyPrinter, n + 1);
        prettyPrinter.printFormClose(n);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type[] typeArray = new Type[this.m_parameters.length];
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeEnvironment.unify(this.m_bindingType.getElementTypes()[i], this.m_initialValues[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
            bindingEnvironment2.setVariableBinding(this.m_parameters[i]);
        }
        bindingEnvironment2.setVariableBinding(this);
        Type type = this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList);
        typeEnvironment.unify(this.m_bindingType.getReturnType(), type, this);
        return this.setCachedType(type);
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        int n;
        ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        reductionHelper2.upgradeBinding(this);
        bindingEnvironment.setVariableBinding(this);
        this.m_bindingEnvironment = null;
        for (n = 0; n < this.m_parameters.length; ++n) {
            reductionHelper2.upgradeBinding(this.m_parameters[n]);
            bindingEnvironment.setVariableBinding(this.m_parameters[n]);
        }
        for (n = 0; n < this.m_initialValues.length; ++n) {
            this.m_initialValues[n] = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_initialValues[n], bindingEnvironment);
        }
        this.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        instructionArray[0] = this;
    }

    @Override
    public int getChildInstructionCount() {
        return 1 + this.m_initialValues.length;
    }

    @Override
    public Instruction getChildInstruction(int n) {
        return n == 0 ? this.m_body : this.m_initialValues[n - 1];
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        if (n == 0) {
            this.m_body = instruction;
        } else {
            this.m_initialValues[n - 1] = instruction;
        }
    }

    @Override
    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set.remove(this.m_parameters[i]);
        }
        set.remove(this);
    }

    @Override
    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            set.remove(this.m_parameters[i]);
        }
        set.remove(this);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_name = readObjectFileHelper.readBindingName();
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_parameters = readObjectFileHelper.readTypeSpecificBindingSet(this);
        this.m_bindingType = (LambdaType)readObjectFileHelper.readType();
        this.m_isPure = readObjectFileHelper.readBoolean();
        int n = this.m_parameters.length;
        this.m_initialValues = new Instruction[n];
        for (int i = 0; i < n; ++i) {
            this.m_initialValues[i] = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeBindingName(this.m_name);
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeTypeSpecificBindingSet(this.m_parameters);
        writeObjectFileHelper.writeType(this.m_bindingType);
        writeObjectFileHelper.writeBoolean(this.m_isPure);
        int n = this.m_initialValues.length;
        for (int i = 0; i < n; ++i) {
            writeObjectFileHelper.writeInstruction(this.m_initialValues[i]);
        }
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        Type[] typeArray = new Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            typeArray[i] = this.m_parameters[i].getBindingType();
            bindingEnvironment.setVariableBinding(this.m_parameters[i]);
        }
        bindingEnvironment.setVariableBinding(this);
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
    }

    @Override
    public Type getTypeParameter(int n) {
        if (0 == n) {
            return this.m_bindingType.getReturnType();
        }
        return this.m_parameters[--n].getBindingType();
    }

    @Override
    public int getTypeParameterCount() {
        return this.m_parameters.length + 1;
    }

    @Override
    public void setTypeParameter(int n, Type type) {
        if (0 == n) {
            this.m_bindingType.setReturnType(type);
            return;
        }
        this.m_parameters[--n].setType(type);
    }

    @Override
    public boolean isChildInstructionBody(int n) {
        return true;
    }

    @Override
    public IBinding[] getChildInstructionBindings(int n) {
        IBinding[] iBindingArray = new IBinding[this.m_parameters.length + 1];
        System.arraycopy(this.m_parameters, 0, iBindingArray, 1, this.m_parameters.length);
        iBindingArray[0] = this;
        return iBindingArray;
    }

    public List getBindings() {
        ArrayList<IBinding> arrayList = new ArrayList<IBinding>();
        arrayList.addAll(Arrays.asList(this.m_parameters));
        arrayList.add(this);
        return arrayList;
    }

    public Binding[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        LoopInstruction loopInstruction = (LoopInstruction)object;
        int n = this.m_parameters.length;
        if (loopInstruction.m_parameters.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (loopInstruction.m_parameters[i].getName().equals(this.m_parameters[i].getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isChildInstructionInTailPosition(int n) {
        return false;
    }

    @Override
    public Type getBindingType() {
        return this.m_bindingType;
    }

    @Override
    public Type getBindingType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_bindingType;
    }

    public int compareTo(Object object) {
        return Binding.compare(this, object);
    }

    @Override
    public LetInstruction getLet() {
        return null;
    }

    @Override
    public Object getName() {
        return this.m_name;
    }

    @Override
    public ISpecialForm getOrigin() {
        return this;
    }

    @Override
    public void setName(Object object) {
        this.m_name = object;
    }
}

