/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import java.util.ArrayList;

public class TerminalLetOptimizer
extends Optimizer {
    @Override
    public void optimizeFunction(Function function) {
        super.optimizeFunction(function);
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction) {
        if (instruction instanceof LetInstruction) {
            ArrayList arrayList = new ArrayList();
            instruction = OptimizerUtilities.skipLets(instruction, arrayList);
            LetInstruction[] letInstructionArray = arrayList.toArray(new LetInstruction[0]);
            for (int i = 0; i < letInstructionArray.length; ++i) {
                letInstructionArray[i].setValue(this.optimize(letInstructionArray[i].getValue()));
            }
            LetInstruction letInstruction = letInstructionArray[letInstructionArray.length - 1];
            if (letInstruction.getBody() instanceof IdentifierInstruction) {
                Object object = ((IdentifierInstruction)letInstruction.getBody()).getVariable();
                if (object.equals(letInstruction.getVariable())) {
                    Instruction instruction2 = this.optimize(letInstruction.getValue());
                    if (letInstructionArray.length == 1) {
                        return instruction2;
                    }
                    letInstructionArray[letInstructionArray.length - 2].setBody(instruction2);
                }
            } else {
                letInstruction.setBody(this.optimize(letInstruction.getBody()));
            }
            return null;
        }
        return instruction;
    }
}

