/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.yarn.server.applicationhistoryservice.timeline;

import org.apache.hadoop.classification.InterfaceAudience.Private;
import org.apache.hadoop.classification.InterfaceStability.Unstable;

/**
 * The unique identifier for an entity
 */
@Private
@Unstable
public class EntityIdentifier implements Comparable<EntityIdentifier> {

  private String id;
  private String type;

  public EntityIdentifier(String id, String type) {
    this.id = id;
    this.type = type;
  }

  /**
   * Get the entity Id.
   * @return The entity Id.
   */
  public String getId() {
    return id;
  }

  /**
   * Get the entity type.
   * @return The entity type.
   */
  public String getType() {
    return type;
  }

  @Override
  public int compareTo(EntityIdentifier other) {
    int c = type.compareTo(other.type);
    if (c != 0) return c;
    return id.compareTo(other.id);
  }

  @Override
  public int hashCode() {
    // generated by eclipse
    final int prime = 31;
    int result = 1;
    result = prime * result + ((id == null) ? 0 : id.hashCode());
    result = prime * result + ((type == null) ? 0 : type.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    // generated by eclipse
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    EntityIdentifier other = (EntityIdentifier) obj;
    if (id == null) {
      if (other.id != null)
        return false;
    } else if (!id.equals(other.id))
      return false;
    if (type == null) {
      if (other.type != null)
        return false;
    } else if (!type.equals(other.type))
      return false;
    return true;
  }

  @Override
  public String toString() {
    return "{ id: " + id + ", type: "+ type + " }";
  }

}
