/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.net.NodeBase;

public class DFSUtil {
    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".") && element.indexOf(":") < 0 && element.indexOf("/") < 0) continue;
            return false;
        }
        return true;
    }

    public static String bytes2String(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static BlockLocation[] locatedBlocks2Locations(LocatedBlocks blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.locatedBlockCount();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        int idx = 0;
        for (LocatedBlock blk : blocks.getLocatedBlocks()) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] names = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                names[hCnt] = locations[hCnt].getName();
                NodeBase node = new NodeBase(names[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            blkLocations[idx] = new BlockLocation(names, hosts, racks, blk.getStartOffset(), blk.getBlockSize());
            ++idx;
        }
        return blkLocations;
    }

    public static URI createUri(String scheme, InetSocketAddress address) {
        try {
            return new URI(scheme, null, address.getHostName(), address.getPort(), null, null, null);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException(ue);
        }
    }

    public static float getInvalidateWorkPctPerIteration(Configuration conf) {
        float blocksInvalidateWorkPct = conf.getFloat("dfs.namenode.invalidate.work.pct.per.iteration", 0.32f);
        if (blocksInvalidateWorkPct <= 0.0f || blocksInvalidateWorkPct > 1.0f) {
            throw new IllegalArgumentException("dfs.namenode.invalidate.work.pct.per.iteration = '" + blocksInvalidateWorkPct + "' is invalid. " + "It should be a positive, non-zero float value " + "indicating a percentage.");
        }
        return blocksInvalidateWorkPct;
    }

    public static int getReplWorkMultiplier(Configuration conf) {
        int blocksReplWorkMultiplier = conf.getInt("dfs.namenode.replication.work.multiplier.per.iteration", 2);
        if (blocksReplWorkMultiplier <= 0) {
            throw new IllegalArgumentException("dfs.namenode.replication.work.multiplier.per.iteration = '" + blocksReplWorkMultiplier + "' is invalid. " + "It should be a positive, non-zero integer value.");
        }
        return blocksReplWorkMultiplier;
    }

    public static class StaleComparator
    implements Comparator<DatanodeInfo> {
        private long staleInterval;

        public StaleComparator(long interval) {
            this.staleInterval = interval;
        }

        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            boolean bStale;
            boolean aStale = a.isStale(this.staleInterval);
            return aStale == (bStale = b.isStale(this.staleInterval)) ? 0 : (aStale ? 1 : -1);
        }
    }
}

