/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.commons.vfs2.util.RandomAccessMode;

class SftpRandomAccessContent
extends AbstractRandomAccessStreamContent {
    protected long filePointer = 0L;
    private final SftpFileObject fileObject;
    private DataInputStream dis = null;
    private InputStream mis = null;

    SftpRandomAccessContent(SftpFileObject fileObject, RandomAccessMode mode) {
        super(mode);
        this.fileObject = fileObject;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", (Object)pos);
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = pos;
    }

    @Override
    protected DataInputStream getDataInputStream() throws IOException {
        if (this.dis != null) {
            return this.dis;
        }
        this.mis = this.fileObject.getInputStream(this.filePointer);
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            @Override
            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++SftpRandomAccessContent.this.filePointer;
                }
                return ret;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret > -1) {
                    SftpRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                if (ret > -1) {
                    SftpRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public void close() throws IOException {
                SftpRandomAccessContent.this.close();
            }
        });
        return this.dis;
    }

    @Override
    public void close() throws IOException {
        if (this.dis != null) {
            this.mis.close();
            DataInputStream oldDis = this.dis;
            this.dis = null;
            oldDis.close();
            this.mis = null;
        }
    }

    @Override
    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

